package MT::Plugin::Print;

use strict;
use File::Temp qw( tempfile );
use base qw( MT::Plugin );
our $VERSION = '0.5a';

my $plugin = MT::Plugin::Print->new(
	{
		id          => 'copper_pdf',
		key         => 'copper-pdf',
		name        => 'Copper PDF MT Plugin',
		description => "PDFを出力します。",
		version     => $VERSION,
		author_name => "GNN Co.,Ltd",
		author_link => "http://copper-pdf.com/",
		plugin_link => "https://sourceforge.jp/projects/copper/",
	}
);
MT->add_plugin($plugin);

sub init_registry {
	my $plugin = shift;
	$plugin->registry(
		{
			applications => {
				'cms' => {
					tags => {
						block => {
							'CopperPDF' => \&_hdlr_copper_pdf,
						},
					},
				},
			},
		}
	);
}

sub _hdlr_copper_pdf {
	my ($ctx, $args, $cond) = @_;
	my $builder = $ctx->stash('builder');
	my $tokens  = $ctx->stash('tokens');
	my $out = $builder->build ($ctx, $tokens, $cond);
	
	my ($fh, $fn) = tempfile();
	
	require CSSJ::Driver;
	my $driver = CSSJ::Driver::create_driver_for( 'localhost', 8099 , "UTF-8" );
	my $session = $driver->create_session( "user", "kappa" );
	$session->set_output(*$fh);
	$session->start_main(*STDOUT, 'file:/index.html', 'text/html', 'UTF-8');
	
print <<EOD;
<html>
  <head>
  <title></title>
  <style type="text/css">
    body {
      font-size: normal 10.5pt/1.2 serif;
    }
    a:link {
    	text-decoration: none;
    	color: Black;
    }
    .body {
      margin: 1em 0;
      text-align: justify;
      border-top: 1pt solid Black;
      border-bottom: 1pt solid Black;
      padding: .5em 0;
    }
    h1, h2, h3, h4, h5, h6, table th, .published {
      font-family: sans-serif;
      font-weight: normal;
    }
    .asset-name:before {
    	content: '「';
    }
    .asset-name:after {
    	content: '」';
    }
    .entry-asset {
    	border-bottom: 1pt solid Black;
    }
    .asset-header {
    	border-bottom: .5pt solid Black;
    }
    .asset-content {
      margin: 1em 0;
    }
    p {
      text-indent: 1em;
    }
    table {
      border-collapse: collapse;
    }
    table th {
      white-space: nowrap;
    }
    table th, table td {
      border: 1pt solid Black;
    }
  </style>
  </head>
  <body>
EOD
	print $out;
print <<EOD;
  </body>
</html>
EOD

	$session->end_main(*STDOUT);
	$session->close();
	
	close($fh);
	$out = '';
	open(FH, $fn);
	while (<FH>) {	$out .= $_;	}
	close(FH);
	
	return $out;
}
