/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.registerer;

import java.util.ArrayList;
import jp.sourceforge.concierge.mdocument.TypeDomImpl;
import jp.sourceforge.concierge.mdocument.TypeManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.w3c.dom.Document;

public class TypeSelectionDialog
extends Dialog {
    private String type;
    private String filename = "no file";
    private Composite base;
    private TableViewer tableviewer;
    public static final String USEPREFERENCE = "    [Use preference configuration]";

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            IStructuredSelection is = (IStructuredSelection)this.tableviewer.getSelection();
            if (is == null || is.size() == 0) {
                MessageDialog.openError((Shell)this.tableviewer.getTable().getShell(), (String)"Error", (String)"Type is not specified.");
                return;
            }
            this.type = (String)is.getFirstElement();
            if (this.type.equals("Not Classify")) {
                this.type = "Unclassified";
            }
        } else {
            this.type = null;
        }
        super.buttonPressed(buttonId);
        this.close();
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Select type");
        this.base = (Composite)super.createDialogArea(parent);
        this.base.setLayout((Layout)new GridLayout(1, false));
        this.base.setLayoutData((Object)new GridData(1808));
        Composite comp = new Composite(this.base, 0);
        comp.setLayout((Layout)new GridLayout(1, false));
        comp.setLayoutData((Object)new GridData(768));
        Label titleLabel = new Label(comp, 16384);
        titleLabel.setLayoutData((Object)new GridData());
        titleLabel.setText("File: " + this.filename);
        titleLabel.setToolTipText(this.filename);
        this.tableviewer = new TableViewer(comp, 2052);
        this.tableviewer.getTable().setLayoutData((Object)new GridData(1808));
        TableColumn tc = new TableColumn(this.tableviewer.getTable(), 0);
        tc.setWidth(200);
        tc.setText("Type");
        tc.setResizable(false);
        tc.setMoveable(false);
        this.tableviewer.setContentProvider((IContentProvider)new TypeContentProvider());
        this.tableviewer.setLabelProvider((IBaseLabelProvider)new TypeLabelProvider());
        ArrayList tdocs = TypeManager.getAllTypeDocuments((boolean)true, (boolean)false, (boolean)true);
        ArrayList<String> types = new ArrayList<String>();
        types.add(USEPREFERENCE);
        int i = 0;
        while (i < tdocs.size()) {
            if (TypeDomImpl.getDialogMode((Document)((Document)tdocs.get(i)))) {
                String t = TypeDomImpl.getTypeName((Document)((Document)tdocs.get(i)));
                if (t.equals("Unclassified")) {
                    t = "Not Classify";
                }
                types.add(t);
            }
            ++i;
        }
        this.tableviewer.setInput(types);
        return this.base;
    }

    protected boolean canHandleShellCloseEvent() {
        this.setReturnCode(1);
        return super.canHandleShellCloseEvent();
    }

    public TypeSelectionDialog(Shell parentShell) {
        super(parentShell);
    }

    public void setFile(String file) {
        this.filename = file;
    }

    public String getType() {
        return this.type;
    }

    private class TypeContentProvider
    implements IStructuredContentProvider {
        private TypeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((ArrayList)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class TypeLabelProvider
    implements ITableLabelProvider {
        private TypeLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (((String)element).equals(TypeSelectionDialog.USEPREFERENCE)) {
                return null;
            }
            String t = ((String)element).equals("Not Classify") ? "Unclassified" : (String)element;
            Document doc = TypeManager.getTypeDocument((String)t);
            return TypeDomImpl.getImage((Document)doc, (Device)TypeSelectionDialog.this.tableviewer.getTable().getDisplay());
        }

        public String getColumnText(Object element, int columnIndex) {
            return (String)element;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

