/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import jp.sourceforge.concierge.editor.DataDialog;
import jp.sourceforge.concierge.editor.DataDialogInput;
import jp.sourceforge.concierge.event.CCGUpdateEvent;
import jp.sourceforge.concierge.event.CCGUpdateThread;
import jp.sourceforge.concierge.event.ICCGUpdateListener;
import jp.sourceforge.concierge.framework.ConciergeViewPart;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.mdocument.TypeDomImpl;
import jp.sourceforge.concierge.mdocument.TypeManager;
import jp.sourceforge.concierge.plugin.Configure;
import jp.sourceforge.concierge.plugin.RegistererPlugin;
import jp.sourceforge.concierge.plugin.registerer.FileListDialog;
import jp.sourceforge.concierge.plugin.registerer.TypeSelectionDialog;
import jp.sourceforge.concierge.plugin.registerer.comparator.BaseComparator;
import jp.sourceforge.concierge.plugin.registerer.comparator.IDComparator;
import jp.sourceforge.concierge.plugin.registerer.comparator.PathComparator;
import jp.sourceforge.concierge.plugin.registerer.comparator.TypeComparator;
import jp.sourceforge.concierge.plugin.registerer.preferences.RegistererPreferencePage;
import jp.sourceforge.concierge.util.SystemUtil;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Registerer
extends ConciergeViewPart {
    private IMemento memento;
    private TableViewer typeviewer;
    private TableViewer fileviewer;
    private Action addAction;
    private Action editAction;
    private Action editedAction;
    private Action removeAction;
    private Action monitorAction;
    private static final Color BLACKCOLOR = new Color(null, 0, 0, 0);
    private static final Color GREENCOLOR = new Color(null, 0, 128, 0);
    private static final ImageDescriptor openeye = RegistererPlugin.getImageDescriptor("icons/openeye.png");
    private static final ImageDescriptor closeeye = RegistererPlugin.getImageDescriptor("icons/closeeye.png");
    private static final ImageDescriptor editicon = RegistererPlugin.getImageDescriptor("icons/editmetadata.png");
    private static final ImageDescriptor addicon = RegistererPlugin.getImageDescriptor("icons/additem.png");
    private SashForm sashform;
    private ArrayList<Document> typedocs;

    private String getLabelFromType(String type) {
        if (type.equals("Unclassified")) {
            return "Not Classify";
        }
        return type;
    }

    private int getColumnWidth(String column) {
        Integer w = this.memento.getInteger(column);
        if (w != null) {
            return w;
        }
        return 100;
    }

    private boolean isEdited(Document doc) {
        long tlmd;
        long tcrt = DomImpl.getCreatedTime((Document)doc);
        return tcrt != (tlmd = DomImpl.getLastModifiedTime((Document)doc));
    }

    private boolean contains(Document doc) {
        Document ed = this.getByDocument(doc);
        return ed != null;
    }

    private Document getByDocument(Document doc) {
        ArrayList docs = (ArrayList)this.fileviewer.getInput();
        int i = 0;
        while (i < docs.size()) {
            if (DomImpl.equalsByID((Document)((Document)docs.get(i)), (Document)doc)) {
                return (Document)docs.get(i);
            }
            ++i;
        }
        return null;
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.memento = memento;
        super.init(site, memento);
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        TableColumn[] tcs = this.fileviewer.getTable().getColumns();
        int i = 0;
        while (i < tcs.length) {
            memento.putInteger(tcs[i].getText(), tcs[i].getWidth());
            ++i;
        }
        int[] w = this.sashform.getWeights();
        memento.putInteger("RegistererSashRatioU", w[0]);
        memento.putInteger("RegistererSashRatioD", w[1]);
        Configure.saveDocuments((ArrayList)this.fileviewer.getInput(), false);
    }

    private void addColumn(TableViewer parent, String title, int width, int alignment, boolean rsz, boolean mv, BaseComparator bc) {
        Table tbl = parent.getTable();
        TableColumn tc = new TableColumn(tbl, 16384);
        tc.setText(title);
        tc.setWidth(width);
        tc.setAlignment(alignment);
        tc.setResizable(rsz);
        tc.setMoveable(mv);
        if (bc != null) {
            tc.setData("Comparator", (Object)bc);
            tc.setData("Direction", (Object)String.valueOf(128));
            tc.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    ArrayList list = (ArrayList)parent.getInput();
                    if (list == null) {
                        return;
                    }
                    TableColumn tc = (TableColumn)e.widget;
                    BaseComparator comp = (BaseComparator)tc.getData("Comparator");
                    if (comp == null) {
                        return;
                    }
                    parent.setInput(null);
                    comp.setColumn(tc);
                    comp.changeSortOrder();
                    Collections.sort(list, comp);
                    parent.setInput((Object)list);
                    int newdir = Integer.parseInt((String)tc.getData("Direction")) == 128 ? 1024 : 128;
                    parent.getTable().setSortColumn(tc);
                    parent.getTable().setSortDirection(newdir);
                    tc.setData("Direction", (Object)String.valueOf(newdir));
                }
            });
        }
    }

    public void createPartControl(Composite parent) {
        GridLayout gl = new GridLayout(1, true);
        gl.marginWidth = 3;
        gl.marginHeight = 3;
        gl.verticalSpacing = 0;
        parent.setLayout((Layout)gl);
        this.sashform = new SashForm(parent, 256);
        this.sashform.setLayoutData((Object)new GridData(1808));
        this.typeviewer = new TableViewer((Composite)this.sashform, 66306);
        this.typeviewer.getControl().setLayoutData((Object)new GridData(1808));
        this.addColumn(this.typeviewer, "Type", 100, 16384, true, false, null);
        this.typeviewer.getTable().setFont(new Font((Device)parent.getDisplay(), "Vernada", 10, 0));
        this.typeviewer.setContentProvider((IContentProvider)new TypeContentProvider());
        this.typeviewer.setLabelProvider((IBaseLabelProvider)new TypeLabelProvider());
        this.typeviewer.addDropSupport(19, new Transfer[]{FileTransfer.getInstance()}, (DropTargetListener)new TableDropListener());
        this.typeviewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Registerer.this.typeviewer.getTable().deselectAll();
            }
        });
        this.typedocs = TypeManager.getSortedTypeDocuments((boolean)true, (boolean)false, (boolean)true);
        ArrayList<Document> tdocs = new ArrayList<Document>();
        int i = 0;
        while (i < this.typedocs.size()) {
            Document tdoc = this.typedocs.get(i);
            if (TypeDomImpl.getDialogMode((Document)tdoc)) {
                tdocs.add(tdoc);
            }
            ++i;
        }
        this.typedocs = tdocs;
        this.typeviewer.setInput(this.typedocs);
        this.fileviewer = new TableViewer((Composite)this.sashform, 66306);
        this.fileviewer.getTable().setLinesVisible(true);
        this.fileviewer.getTable().setHeaderVisible(true);
        this.fileviewer.addDropSupport(19, new Transfer[]{FileTransfer.getInstance()}, (DropTargetListener)new FileTableDropListener());
        if (this.memento != null) {
            this.addColumn(this.fileviewer, "File", this.getColumnWidth("File"), 16384, true, false, new PathComparator());
            this.addColumn(this.fileviewer, "Type", this.getColumnWidth("Type"), 16384, true, false, new TypeComparator());
            this.addColumn(this.fileviewer, "ID", this.getColumnWidth("ID"), 16384, true, false, new IDComparator());
            this.addColumn(this.fileviewer, "Content", this.getColumnWidth("Content"), 16384, true, false, null);
        } else {
            this.addColumn(this.fileviewer, "File", 300, 16384, true, false, new PathComparator());
            this.addColumn(this.fileviewer, "Type", 100, 16384, true, false, new TypeComparator());
            this.addColumn(this.fileviewer, "ID", 150, 16384, true, false, new IDComparator());
            this.addColumn(this.fileviewer, "Content", 300, 16384, true, false, null);
        }
        this.fileviewer.setContentProvider((IContentProvider)new FileContentProvider());
        this.fileviewer.setLabelProvider((IBaseLabelProvider)new FileLabelProvider());
        this.fileviewer.setInput(Configure.loadDocuments());
        this.fileviewer.getTable().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                Registerer.this.editAction.run();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        try {
            int uratio = this.memento.getInteger("RegistererSashRatioU");
            int dratio = this.memento.getInteger("RegistererSashRatioD");
            this.sashform.setWeights(new int[]{uratio, dratio});
        }
        catch (Exception exception) {
            this.sashform.setWeights(new int[]{30, 70});
        }
        FrameworkPlugin.addDatabaseListener((String)"data", (ICCGUpdateListener)new CCGUpdateThread(this.fileviewer.getControl(), new ICCGUpdateListener(){

            public void updated(CCGUpdateEvent ev) {
                if (!ev.success.booleanValue() || ev.collection.equals("ccgconfig")) {
                    return;
                }
                switch (ev.type) {
                    case ADD_DOCUMENT: {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        if (page == null) {
                            ArrayList<Document> docs = new ArrayList<Document>();
                            int i = 0;
                            while (i < ev.documents.size()) {
                                docs.add((Document)ev.documents.get(i));
                                ++i;
                            }
                            Configure.saveDocuments(docs, true);
                            break;
                        }
                        ConciergeViewPart registerer = (ConciergeViewPart)page.findView("jp.sourceforge.concierge.plugin.registerer");
                        if (registerer == null) {
                            ArrayList<Document> docs = new ArrayList<Document>();
                            int i = 0;
                            while (i < ev.documents.size()) {
                                docs.add((Document)ev.documents.get(i));
                                ++i;
                            }
                            Configure.saveDocuments(docs, true);
                            break;
                        }
                        Registerer.this.addDocuments(ev.documents);
                        int i = 0;
                        while (i < ev.documents.size()) {
                            String msg = "Added document(" + DataDomImpl.getFilePath((Document)((Document)ev.documents.get(i))) + ")";
                            RegistererPlugin.getDefault().setConsoleMessage(msg);
                            ++i;
                        }
                        break;
                    }
                    case DEL_DOCUMENT: {
                        ArrayList docsd = (ArrayList)Registerer.this.fileviewer.getInput();
                        int i = 0;
                        while (i < ev.documents.size()) {
                            long id = DomImpl.getID((Document)((Document)ev.documents.get(i)));
                            int j = 0;
                            while (j < docsd.size()) {
                                long did = DomImpl.getID((Document)((Document)docsd.get(j)));
                                if (did == id) {
                                    docsd.remove(j);
                                    break;
                                }
                                ++j;
                            }
                            ++i;
                        }
                        Registerer.this.fileviewer.refresh();
                        break;
                    }
                    case UPD_DOCUMENT: {
                        ArrayList docsu = (ArrayList)Registerer.this.fileviewer.getInput();
                        int i = 0;
                        while (i < docsu.size()) {
                            Document doc = DomImpl.findDocument((ArrayList)ev.documents, (Document)((Document)docsu.get(i)));
                            if (doc != null) {
                                DomImpl.copyDocumentContents((Document)doc, (Document)((Document)docsu.get(i)));
                            }
                            ++i;
                        }
                        Registerer.this.fileviewer.refresh();
                    }
                }
            }
        }));
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
    }

    private ArrayList<String> getAllFiles(String dir) {
        ArrayList<String> files = new ArrayList<String>();
        File f = new File(dir);
        File[] cf = f.listFiles();
        int i = 0;
        while (i < cf.length) {
            if (!cf[i].getName().startsWith(".")) {
                if (cf[i].isDirectory()) {
                    files.addAll(this.getAllFiles(cf[i].getAbsolutePath()));
                } else {
                    files.add(cf[i].getAbsolutePath());
                }
            }
            ++i;
        }
        return files;
    }

    private void getUpdateDocuments(ArrayList<Document> adddocs, ArrayList<Document> upddocs, ArrayList<String> files, Document typedoc) {
        int i = 0;
        while (i < files.size()) {
            ArrayList docs = FrameworkPlugin.getDocumentsByOriginalPath((String)files.get(i));
            if (docs != null && docs.size() > 0) {
                if (upddocs != null) {
                    int j = 0;
                    while (j < docs.size()) {
                        String type = TypeDomImpl.getTypeName((Document)typedoc);
                        Element te = DataDomImpl.getDataOfType((Document)((Document)docs.get(j)), (String)type);
                        if (te == null) {
                            DataDomImpl.addDataOfType((Document)((Document)docs.get(j)), (Document)typedoc);
                            upddocs.add((Document)docs.get(j));
                        }
                        ++j;
                    }
                }
            } else {
                Document ndoc = DataDomImpl.createDocument((Document)typedoc);
                DataDomImpl.setFilePath((Document)ndoc, (String)files.get(i));
                adddocs.add(ndoc);
            }
            ++i;
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Registerer.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.fileviewer.getControl());
        this.fileviewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.fileviewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.editAction);
        manager.add((IAction)this.removeAction);
        manager.add((IAction)this.editedAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.addAction);
        manager.add((IAction)this.editAction);
        manager.add((IAction)this.removeAction);
        manager.add((IAction)this.editedAction);
        manager.add((IAction)this.monitorAction);
    }

    private void makeActions() {
        this.addAction = new Action(){

            public void run() {
                FileDialog fd = new FileDialog(Registerer.this.getViewSite().getShell(), 4096);
                String path = fd.open();
                if (path == null) {
                    return;
                }
                ArrayList docs = FrameworkPlugin.getDocumentsByOriginalPath((String)path);
                if (docs != null && docs.size() > 0) {
                    if (!MessageDialog.openConfirm((Shell)Registerer.this.getViewSite().getShell(), (String)"Already registered", (String)"The specified file is already registered. \nShow this item to the view?")) {
                        return;
                    }
                    Document doc = Registerer.this.getByDocument((Document)docs.get(0));
                    if (doc == null) {
                        Registerer.this.addDocuments(docs);
                    } else {
                        Registerer.this.fileviewer.setSelection((ISelection)new StructuredSelection((Object)doc));
                    }
                    return;
                }
                TypeSelectionDialog tsd = new TypeSelectionDialog(Registerer.this.getViewSite().getShell());
                if (tsd.open() == 1) {
                    return;
                }
                path = SystemUtil.convert((String)path);
                String type = tsd.getType();
                ArrayList<Document> newdocs = new ArrayList<Document>();
                if (type.equals("    [Use preference configuration]") && (type = RegistererPreferencePage.getManualType(path)) == null) {
                    if (!MessageDialog.openConfirm((Shell)Registerer.this.getViewSite().getShell(), (String)"No match", (String)"The file does not match any regex in the preference.\n Register as Unclassified?")) {
                        return;
                    }
                    type = "Unclassified";
                }
                Document mdoc = null;
                if (type.equals("Unclassified")) {
                    mdoc = DataDomImpl.createDocument();
                } else {
                    Document tdoc = TypeManager.getTypeDocument((String)type);
                    mdoc = DataDomImpl.createDocument((Document)tdoc);
                }
                DataDomImpl.setDefaultType((Document)mdoc, (String)type);
                DataDomImpl.setFilePath((Document)mdoc, (String)path);
                newdocs.add(mdoc);
                Request r = new Request(1, newdocs, "data");
                ArrayList<Request> reqs = new ArrayList<Request>();
                reqs.add(r);
                FrameworkPlugin.updateDocuments(reqs, (Object)RegistererPlugin.getDefault().getBundle().getSymbolicName());
            }
        };
        this.addAction.setToolTipText("Add item.");
        this.addAction.setText("Add");
        this.addAction.setImageDescriptor(addicon);
        this.editAction = new Action(){

            public void run() {
                IStructuredSelection sels = (IStructuredSelection)Registerer.this.fileviewer.getSelection();
                Iterator it = sels.iterator();
                ArrayList<DataDialogInput> ddilist = new ArrayList<DataDialogInput>();
                while (it.hasNext()) {
                    Document doc = (Document)it.next();
                    DataDialogInput ddi = new DataDialogInput(doc, DataDomImpl.getDefaultType((Document)doc), false);
                    ddilist.add(ddi);
                }
                DataDialog dd = new DataDialog(Registerer.this.getViewSite().getShell(), 0);
                dd.setDocuments(ddilist, (Object)"jp.sourceforge.concierge.plugin.registerer");
                dd.open();
            }
        };
        this.editAction.setToolTipText("Edit item.");
        this.editAction.setText("Edit");
        this.editAction.setImageDescriptor(editicon);
        this.editedAction = new Action(){

            public void run() {
                if (!MessageDialog.openConfirm((Shell)Registerer.this.fileviewer.getControl().getShell(), (String)"Confirm", (String)"Remove edited items from the list. OK?")) {
                    return;
                }
                ArrayList edocs = (ArrayList)Registerer.this.fileviewer.getInput();
                ArrayList<Document> ndocs = new ArrayList<Document>();
                int i = 0;
                while (i < edocs.size()) {
                    Document doc = (Document)edocs.get(i);
                    if (!Registerer.this.isEdited(doc)) {
                        ndocs.add(doc);
                    }
                    ++i;
                }
                Registerer.this.fileviewer.setInput(ndocs);
            }
        };
        this.editedAction.setToolTipText("Remove edited items.");
        this.editedAction.setText("Remove edited items");
        this.editedAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_CUT"));
        this.removeAction = new Action(){

            public void run() {
                IStructuredSelection sel = (IStructuredSelection)Registerer.this.fileviewer.getSelection();
                if (sel == null || sel.size() == 0) {
                    return;
                }
                if (!MessageDialog.openConfirm((Shell)Registerer.this.fileviewer.getTable().getShell(), (String)"Registerer", (String)"Delete?")) {
                    return;
                }
                ArrayList<Request> reqs = new ArrayList<Request>();
                ArrayList<Document> ddocs = new ArrayList<Document>();
                Iterator en = sel.iterator();
                while (en.hasNext()) {
                    ddocs.add((Document)en.next());
                }
                reqs.add(new Request(2, ddocs, "data"));
                Registerer.this.fileviewer.refresh();
                FrameworkPlugin.updateDocuments(reqs, (Object)RegistererPlugin.getDefault().getBundle().getSymbolicName());
            }
        };
        this.removeAction.setToolTipText("Delete item.");
        this.removeAction.setText("Delete");
        this.removeAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.monitorAction = new Action(){

            public void run() {
                if (Registerer.this.monitorAction.getImageDescriptor().equals(openeye)) {
                    Registerer.this.monitorAction.setImageDescriptor(closeeye);
                    RegistererPlugin.getDefault().unmonitoringDirectory();
                } else {
                    Registerer.this.monitorAction.setImageDescriptor(openeye);
                    RegistererPlugin.getDefault().monitoringDirectory();
                }
            }
        };
        this.monitorAction.setToolTipText("File monitor On/Off.");
        this.monitorAction.setImageDescriptor(openeye);
        RegistererPlugin.getDefault().monitoringDirectory();
    }

    public void dispose() {
        ArrayList docs = (ArrayList)this.fileviewer.getInput();
        Configure.saveDocuments(docs, false);
        super.dispose();
    }

    public void addDocuments(ArrayList<Document> newdocs) {
        ArrayList docs = (ArrayList)this.fileviewer.getInput();
        ArrayList<Document> seldocs = new ArrayList<Document>();
        int i = 0;
        while (i < newdocs.size()) {
            if (!this.contains(newdocs.get(i))) {
                docs.add(newdocs.get(i));
                seldocs.add(newdocs.get(i));
            }
            ++i;
        }
        this.fileviewer.refresh();
        this.fileviewer.setSelection((ISelection)new StructuredSelection(seldocs));
    }

    public void setFocus() {
        this.typeviewer.getControl().setFocus();
    }

    private class FileContentProvider
    implements IStructuredContentProvider {
        private FileContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((ArrayList)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class FileLabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        private FileLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            TableColumn tc = Registerer.this.fileviewer.getTable().getColumn(columnIndex);
            String title = tc.getText();
            Document doc = (Document)element;
            if (title == "File") {
                return DataDomImpl.getFilePath((Document)doc);
            }
            if (title == "Type") {
                return DataDomImpl.getAllTypes((Document)doc);
            }
            if (title == "ID") {
                return String.valueOf(DomImpl.getID((Document)doc));
            }
            if (title == "File information") {
                return DataDomImpl.getFileInformationText((Document)doc);
            }
            if (title == "Content") {
                return DataDomImpl.getAllText((Document)doc);
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            return Registerer.this.isEdited((Document)element) ? BLACKCOLOR : GREENCOLOR;
        }
    }

    private class FileTableDropListener
    extends DropTargetAdapter {
        private FileTableDropListener() {
        }

        public void drop(DropTargetEvent e) {
            if (FileTransfer.getInstance().isSupportedType(e.currentDataType)) {
                String[] files = (String[])e.data;
                if (files == null) {
                    return;
                }
                int i = 0;
                while (i < files.length) {
                    files[i] = SystemUtil.convert((String)files[i]);
                    ++i;
                }
                ArrayList newdocs = new ArrayList();
                ArrayList upddocs = null;
                boolean registered = false;
                int i2 = 0;
                while (i2 < files.length) {
                    if (FrameworkPlugin.isDocumentedByOriginalPath((String)files[i2])) {
                        registered = true;
                    } else {
                        TypeSelectionDialog tsd = new TypeSelectionDialog(Registerer.this.getViewSite().getShell());
                        tsd.setFile(FilenameUtils.getName((String)files[i2]));
                        if (tsd.open() != 1) {
                            String type = tsd.getType();
                            if (type.equals("    [Use preference configuration]") && (type = RegistererPreferencePage.getManualType(FilenameUtils.getName((String)files[i2]))) == null) {
                                if (!MessageDialog.openConfirm((Shell)Registerer.this.getViewSite().getShell(), (String)"No match", (String)"The file does not match any regex in the preference.\n Register as Unclassified?")) {
                                    return;
                                }
                                type = "Unclassified";
                            }
                            Document tdoc = TypeManager.getTypeDocument((String)type);
                            File ff = new File(files[i2]);
                            if (ff.isDirectory()) {
                                FileListDialog fld = new FileListDialog(Registerer.this.fileviewer.getControl().getShell());
                                fld.setCheckExtension(RegistererPreferencePage.getExtensions());
                                fld.setFiles(Registerer.this.getAllFiles(files[i2]));
                                if (fld.open() == 1) {
                                    return;
                                }
                                ArrayList<String> sfiles = fld.getFilesToBeRegistered();
                                if (TypeDomImpl.getFolderType((Document)tdoc)) {
                                    sfiles.add(files[i2]);
                                }
                                upddocs = new ArrayList();
                                Registerer.this.getUpdateDocuments(newdocs, upddocs, sfiles, tdoc);
                            } else {
                                ArrayList<String> sfiles = new ArrayList<String>();
                                sfiles.add(files[i2]);
                                Registerer.this.getUpdateDocuments(newdocs, upddocs, sfiles, tdoc);
                            }
                            int j = 0;
                            while (j < newdocs.size()) {
                                DataDomImpl.setDefaultType((Document)((Document)newdocs.get(j)), (String)type);
                                ++j;
                            }
                        }
                    }
                    ++i2;
                }
                if (registered) {
                    MessageDialog.openInformation((Shell)Registerer.this.getViewSite().getShell(), (String)"Already registered", (String)"Some files are already registered.");
                }
                Request r = new Request(1, newdocs, "data");
                ArrayList<Request> reqs = new ArrayList<Request>();
                reqs.add(r);
                if (upddocs != null && upddocs.size() > 0) {
                    r = new Request(3, (Object)upddocs, "data");
                    reqs.add(r);
                }
                FrameworkPlugin.updateDocuments(reqs, (Object)RegistererPlugin.getDefault().getBundle().getSymbolicName());
            }
        }
    }

    private class TableDropListener
    extends DropTargetAdapter {
        private TableDropListener() {
        }

        public void drop(DropTargetEvent e) {
            if (FileTransfer.getInstance().isSupportedType(e.currentDataType)) {
                Request r;
                String[] files = (String[])e.data;
                if (files == null) {
                    return;
                }
                int i = 0;
                while (i < files.length) {
                    files[i] = SystemUtil.convert((String)files[i]);
                    ++i;
                }
                Document tdoc = (Document)e.item.getData();
                ArrayList newdocs = new ArrayList();
                ArrayList upddocs = null;
                boolean registered = false;
                int i2 = 0;
                while (i2 < files.length) {
                    if (FrameworkPlugin.isDocumentedByOriginalPath((String)files[i2])) {
                        registered = true;
                    } else {
                        File ff = new File(files[i2]);
                        if (ff.isDirectory()) {
                            FileListDialog fld = new FileListDialog(Registerer.this.fileviewer.getControl().getShell());
                            fld.setCheckExtension(RegistererPreferencePage.getExtensions());
                            fld.setFiles(Registerer.this.getAllFiles(files[i2]));
                            if (fld.open() == 1) {
                                return;
                            }
                            ArrayList<String> sfiles = fld.getFilesToBeRegistered();
                            if (TypeDomImpl.getFolderType((Document)tdoc)) {
                                sfiles.add(files[i2]);
                            }
                            upddocs = new ArrayList();
                            Registerer.this.getUpdateDocuments(newdocs, upddocs, sfiles, tdoc);
                        } else {
                            ArrayList<String> sfiles = new ArrayList<String>();
                            sfiles.add(files[i2]);
                            Registerer.this.getUpdateDocuments(newdocs, upddocs, sfiles, tdoc);
                        }
                    }
                    ++i2;
                }
                if (registered) {
                    MessageDialog.openInformation((Shell)Registerer.this.getViewSite().getShell(), (String)"Already registered", (String)"Some files are already registered.");
                }
                String type = TypeDomImpl.getTypeName((Document)tdoc);
                int i3 = 0;
                while (i3 < newdocs.size()) {
                    DataDomImpl.setDefaultType((Document)((Document)newdocs.get(i3)), (String)type);
                    ++i3;
                }
                ArrayList<Request> reqs = new ArrayList<Request>();
                if (newdocs.size() > 0) {
                    r = new Request(1, newdocs, "data");
                    reqs.add(r);
                }
                if (upddocs != null && upddocs.size() > 0) {
                    r = new Request(3, (Object)upddocs, "data");
                    reqs.add(r);
                }
                if (reqs.size() > 0) {
                    FrameworkPlugin.updateDocuments(reqs, (Object)RegistererPlugin.getDefault().getBundle().getSymbolicName());
                }
            }
        }
    }

    private class TypeContentProvider
    implements IStructuredContentProvider {
        private TypeContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object dataset) {
            return ((ArrayList)dataset).toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class TypeLabelProvider
    implements ITableLabelProvider {
        private TypeLabelProvider() {
        }

        public boolean isLabelProperty(Object object, String property) {
            return false;
        }

        public void dispose() {
        }

        public Image getColumnImage(Object object, int index) {
            return TypeDomImpl.getImage((Document)((Document)object), (Device)Registerer.this.typeviewer.getTable().getDisplay());
        }

        public String getColumnText(Object object, int index) {
            return Registerer.this.getLabelFromType(TypeDomImpl.getTypeName((Document)((Document)object)));
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            return null;
        }
    }
}

