/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.labnote.styledtexteditor;

import java.util.ArrayList;
import java.util.Stack;
import java.util.regex.PatternSyntaxException;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.plugin.labnote.styledtexteditor.EmbeddedObject;
import jp.sourceforge.concierge.plugin.labnote.styledtexteditor.Messages;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.custom.Bullet;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class HTMLReader {
    StyledText styledtext;
    private ColorRegistry colorReg = null;
    private ArrayList<EmbeddedObject> eobjects = null;

    public HTMLReader(StyledText textview, ArrayList<EmbeddedObject> eobjects) {
        this.styledtext = textview;
        this.eobjects = eobjects;
    }

    private static String[] getKeyValue(String item) {
        String[] param = item.split(":");
        if (param.length < 2) {
            return null;
        }
        int i = 0;
        while (i < 2) {
            param[i] = param[i].trim();
            ++i;
        }
        return param;
    }

    private Color getColor(String cstr) {
        if (cstr.startsWith("rgb(")) {
            try {
                String value = cstr.replaceAll("[rgb()]", "");
                String[] rgb = value.split(",");
                if (rgb.length == 3) {
                    Color color;
                    Color newColor = new Color((Device)this.styledtext.getDisplay(), Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
                    if (this.colorReg == null) {
                        this.colorReg = new ColorRegistry();
                    }
                    if ((color = this.colorReg.get(newColor.toString())) == null) {
                        this.colorReg.put(newColor.toString(), newColor.getRGB());
                    } else {
                        newColor.dispose();
                        newColor = null;
                        newColor = color;
                    }
                    return newColor;
                }
            }
            catch (PatternSyntaxException e) {
                System.err.println(e.getMessage());
            }
        }
        return null;
    }

    private int getFontStyle(String cstr) {
        String[] st = cstr.split(" ");
        int stval = 0;
        int i = 0;
        while (i < st.length) {
            if (st[i].compareTo("bold") == 0) {
                stval |= 1;
            } else if (st[i].compareTo("italic") == 0) {
                stval |= 2;
            }
            ++i;
        }
        return stval;
    }

    private int getFontSize(String cstr) {
        cstr = cstr.replaceFirst("pt", "");
        return Integer.parseInt(cstr);
    }

    private String convertAttrToMark(String attr) {
        if (attr.equals("circle")) {
            return Messages.getString("HTMLReader.11");
        }
        if (attr.equals("disc")) {
            return Messages.getString("HTMLReader.13");
        }
        if (attr.equals("square")) {
            return Messages.getString("HTMLReader.15");
        }
        return "";
    }

    private boolean includeVal(String cstr, String val) {
        String[] st = cstr.split(" ");
        int i = 0;
        while (i < st.length) {
            if (st[i].compareTo(val) == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isBold(String cstr) {
        return this.includeVal(cstr, "bold");
    }

    private boolean isUnderline(String cstr) {
        return this.includeVal(cstr, "underline");
    }

    private boolean isStrikeout(String cstr) {
        return this.includeVal(cstr, "line-through");
    }

    private StyleRange getStyleRange(String style) {
        if (style.length() == 0) {
            return null;
        }
        StyleRange sr = new StyleRange();
        String[] item = style.split(";");
        String tfont = null;
        int tstyle = 0;
        int tsize = 10;
        boolean isbold = false;
        int i = 0;
        while (i < item.length) {
            String[] keyval = HTMLReader.getKeyValue(item[i]);
            if (keyval != null) {
                String key = keyval[0];
                String val = keyval[1];
                if (key.compareTo("color") == 0) {
                    sr.foreground = this.getColor(val);
                } else if (key.compareTo("background") == 0) {
                    sr.background = this.getColor(val);
                } else if (key.compareTo("font-style") == 0) {
                    tstyle = this.getFontStyle(val);
                } else if (key.compareTo("font-weight") == 0) {
                    isbold = this.isBold(val);
                } else if (key.compareTo("font-size") == 0) {
                    tsize = this.getFontSize(val);
                } else if (key.compareTo("font-family") == 0) {
                    tfont = val;
                    if (tfont.length() > 0 && tfont.startsWith("'")) {
                        tfont = tfont.substring(1);
                    }
                    if (tfont.length() > 1 && tfont.endsWith("'")) {
                        tfont = tfont.substring(0, tfont.length() - 1);
                    }
                } else if (key.compareTo("text-decoration") == 0) {
                    sr.underline = this.isUnderline(val);
                    sr.strikeout = this.isStrikeout(val);
                }
            }
            ++i;
        }
        if (isbold) {
            tstyle |= 1;
        }
        if (tfont != null) {
            sr.font = new Font((Device)this.styledtext.getDisplay(), tfont, tsize, tstyle);
        } else {
            sr.font = null;
            sr.fontStyle = tstyle;
        }
        return sr;
    }

    private int getIndentSize(String style) {
        if (style.length() == 0) {
            return 0;
        }
        String[] item = style.split(";");
        int i = 0;
        while (i < item.length) {
            String[] keyval = HTMLReader.getKeyValue(item[i]);
            if (keyval != null && keyval[0].equals("margin-left")) {
                String kv1 = keyval[1].replace("px", "");
                return Integer.parseInt(kv1);
            }
            ++i;
        }
        return 0;
    }

    private String getListStyle(String style) {
        if (style.length() == 0) {
            return "";
        }
        String[] item = style.split(";");
        int i = 0;
        while (i < item.length) {
            String[] keyval = HTMLReader.getKeyValue(item[i]);
            if (keyval != null && keyval[0].equals("list-style-type")) {
                return keyval[1];
            }
            ++i;
        }
        return "";
    }

    private void parseUL(Element elemul, LineInformation li) {
        String style = DomImpl.getAttribute((Element)elemul, (String)"style");
        String mk = this.convertAttrToMark(this.getListStyle(style));
        li.counter = 0;
        li.mark = mk;
        this.parseElements(elemul.getChildNodes(), li);
    }

    private void parseOL(Element elemul, LineInformation li) {
        li.counter = 1;
        li.mark = null;
        this.parseElements(elemul.getChildNodes(), li);
    }

    private void parseLI(Element elemli, LineInformation li) {
        int pos = this.styledtext.getLineCount() - 1;
        String style = DomImpl.getAttribute((Element)elemli, (String)"style");
        StyleRange sr = this.getStyleRange(style);
        if (sr != null) {
            li.styles.add(sr);
        }
        int indent = this.getIndentSize(style);
        StyleRange nsr = new StyleRange();
        nsr.metrics = new GlyphMetrics(0, 0, indent);
        Bullet blt = new Bullet(16, nsr);
        if (li.mark != null) {
            blt.text = li.mark;
        } else if (li.counter > 0) {
            blt.text = String.valueOf(li.counter);
            ++li.counter;
        }
        this.parseElements(elemli.getChildNodes(), li);
        if (pos >= 0) {
            this.styledtext.setLineBullet(pos, 1, blt);
        }
        this.styledtext.append(this.styledtext.getLineDelimiter());
        if (sr != null) {
            li.styles.remove(sr);
        }
    }

    private void parseBR(Element elembr, LineInformation li) {
        this.styledtext.append(this.styledtext.getLineDelimiter());
    }

    private void parseText(Text elemtxt, LineInformation li) {
        String text = elemtxt.getNodeValue();
        if (text.equals("\n") || text.equals("\r")) {
            return;
        }
        if (li.styles.size() > 0) {
            StyleRange sr = li.styles.peek();
            sr.start = this.styledtext.getCharCount();
            sr.length = text.length();
            this.styledtext.replaceTextRange(sr.start, 0, text);
            this.styledtext.setStyleRange(sr);
        } else {
            this.styledtext.append(text);
        }
    }

    private void setStyleRange(EmbeddedObject e, Point sz) {
        if (this.styledtext.getCharCount() == e.getOffset()) {
            this.styledtext.append("\ufffc");
        } else {
            this.styledtext.replaceTextRange(e.getOffset(), 0, "\ufffc");
        }
        StyleRange style = new StyleRange();
        style.start = e.getOffset();
        style.length = 1;
        style.foreground = this.styledtext.getBackground();
        if (sz != null) {
            style.metrics = new GlyphMetrics(sz.y, 0, sz.x);
        } else {
            Rectangle rect = e.getImage().getBounds();
            style.metrics = new GlyphMetrics(rect.height, 0, rect.width);
        }
        this.styledtext.setStyleRange(style);
    }

    private void parseA(Element elema, LineInformation li) {
        EmbeddedObject e = EmbeddedObject.createInstance(elema);
        if (e != null) {
            e.setOffset(this.styledtext.getCharCount());
            this.setStyleRange(e, e.getSize());
            this.eobjects.add(e);
        }
    }

    private void parseSpan(Element elemspan, LineInformation li) {
        String id = elemspan.getAttribute("id");
        if (id.equals("li")) {
            this.parseSpanLI(elemspan, li);
        } else if (!id.equals("li-title")) {
            StyleRange sr = this.getStyleRange(elemspan.getAttribute("style"));
            if (sr != null) {
                li.styles.add(sr);
            }
            this.parseElements(elemspan.getChildNodes(), li);
            if (sr != null) {
                li.styles.remove(sr);
            }
        }
    }

    private void parseSpanLI(Element elemspan, LineInformation li) {
        int pos = this.styledtext.getLineCount() - 1;
        String style = elemspan.getAttribute("style");
        StyleRange sr = this.getStyleRange(style);
        if (sr != null) {
            li.styles.add(sr);
        }
        int indent = this.getIndentSize(style);
        String title = elemspan.getAttribute("title");
        StyleRange nsr = new StyleRange();
        nsr.metrics = new GlyphMetrics(0, 0, indent);
        Bullet blt = new Bullet(16, nsr);
        blt.text = title;
        this.parseElements(elemspan.getChildNodes(), li);
        if (pos >= 0) {
            this.styledtext.setLineBullet(pos, 1, blt);
        }
        if (sr != null) {
            li.styles.remove(sr);
        }
    }

    private void parseH1(Element elem, LineInformation li) {
        StyleRange sr = this.getStyleRange(elem.getAttribute("style"));
        int pos = this.styledtext.getLineCount() - 1;
        StyleRange nsr = new StyleRange();
        nsr.metrics = new GlyphMetrics(1, 0, 0);
        Bullet blt = new Bullet(16, nsr);
        blt.text = "";
        this.parseElements(elem.getChildNodes(), li);
        if (pos >= 0) {
            if (sr != null) {
                this.styledtext.setLineBackground(pos, 1, sr.background);
            }
            this.styledtext.setLineBullet(pos, 1, blt);
        }
        this.styledtext.append(this.styledtext.getLineDelimiter());
    }

    private void parseDiv(Element elem, LineInformation li) {
        String name = DomImpl.getAttribute((Element)elem, (String)"name");
        if (!name.equals("line")) {
            this.parseElements(elem.getChildNodes(), li);
        } else {
            int indent;
            int pos = this.styledtext.getLineCount() - 1;
            li.indent = indent = this.getIndentSize(DomImpl.getAttribute((Element)elem, (String)"style"));
            this.parseElements(elem.getChildNodes(), li);
            if (pos >= 0 && indent > 0) {
                StyleRange nsr = new StyleRange();
                nsr.metrics = new GlyphMetrics(0, 0, indent);
                Bullet nblt = new Bullet(16, nsr);
                nblt.text = "";
                this.styledtext.setLineBullet(pos, 1, nblt);
            }
        }
    }

    private void parseElements(NodeList tags, LineInformation linfo) {
        int i = 0;
        while (i < tags.getLength()) {
            Node tag = tags.item(i);
            short type = tag.getNodeType();
            if (type == 3) {
                this.parseText((Text)tag, linfo);
            } else if (type == 1) {
                if (tag.getNodeName().compareTo("li") == 0) {
                    this.parseLI((Element)tag, linfo);
                } else if (tag.getNodeName().compareTo("ul") == 0) {
                    this.parseUL((Element)tag, linfo);
                } else if (tag.getNodeName().compareTo("ol") == 0) {
                    this.parseOL((Element)tag, linfo);
                } else if (tag.getNodeName().compareTo("br") == 0) {
                    this.parseBR((Element)tag, linfo);
                } else if (tag.getNodeName().compareTo("a") == 0) {
                    this.parseA((Element)tag, linfo);
                } else if (tag.getNodeName().compareTo("span") == 0) {
                    this.parseSpan((Element)tag, linfo);
                } else if (tag.getNodeName().compareTo("h1") == 0) {
                    this.parseH1((Element)tag, linfo);
                } else if (tag.getNodeName().compareTo("div") == 0) {
                    this.parseDiv((Element)tag, linfo);
                } else {
                    this.parseElements(tag.getChildNodes(), linfo);
                }
            }
            ++i;
        }
    }

    public void importFromDocument(Document doc) {
        StyleRange bodyStyleRange;
        ArrayList bs = DomImpl.getElements((Document)doc, (String)"body");
        if (bs.size() == 0) {
            return;
        }
        this.styledtext.setText("");
        this.eobjects.clear();
        Element body = (Element)bs.get(0);
        String bodyStyle = body.getAttribute("style");
        StyleRange styleRange = bodyStyleRange = bodyStyle.length() > 0 ? this.getStyleRange(bodyStyle) : null;
        if (bodyStyleRange != null) {
            if (bodyStyleRange.foreground != null) {
                this.styledtext.setForeground(bodyStyleRange.foreground);
            }
            if (bodyStyleRange.background != null) {
                this.styledtext.setBackground(bodyStyleRange.background);
            }
            if (bodyStyleRange.font != null) {
                this.styledtext.setFont(bodyStyleRange.font);
            }
        }
        this.parseElements(body.getChildNodes(), new LineInformation());
    }

    private class LineInformation {
        int indent = 0;
        int counter = 0;
        String mark = null;
        Stack<StyleRange> styles = new Stack();

        private LineInformation() {
        }
    }
}

