/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.ipapers.download;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.plugin.IPapersPlugin;
import jp.sourceforge.concierge.plugin.ipapers.download.JournalPDFSite;
import jp.sourceforge.concierge.plugin.ipapers.download.JournalSite;
import jp.sourceforge.concierge.plugin.ipapers.download.PDFDownloadException;
import jp.sourceforge.concierge.plugin.ipapers.download.downloadPDF;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;

public class Nature
extends JournalSite
implements JournalPDFSite {
    private HttpClient client;

    public Nature(String host) {
        this.hostname = host;
        this.client = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        String proxyHost = FrameworkPlugin.getDefault().GetHttpProxyHost();
        if (proxyHost != null && proxyHost.length() != 0) {
            int proxyPort = Integer.valueOf(FrameworkPlugin.getDefault().GetHttpProxyPort());
            this.client.getHostConfiguration().setProxy(proxyHost, proxyPort);
        }
    }

    @Override
    public String PDFlinkOfFile(InputStream is) {
        String link = null;
        BufferedReader br = null;
        try {
            InputStreamReader in = new InputStreamReader(is, "ISO-8859-1");
            br = new BufferedReader(in);
            String line = null;
            Pattern pattern = Pattern.compile("/\\w+/journal/v\\d+/n\\d+/pdf/\\S+\\.pdf");
            Pattern framelink = Pattern.compile("/\\w+/journal/v\\d+/n\\d+/abs/\\S+_l\\.html");
            while ((line = br.readLine()) != null) {
                Matcher matcher = pattern.matcher(line);
                Matcher matcherFramelink = framelink.matcher(line);
                if (matcher.find(0)) {
                    link = "http://" + this.hostname + line.substring(matcher.start(), matcher.end());
                    break;
                }
                Pattern pattern2 = Pattern.compile("/\\w+/journal/vaop/ncurrent/pdf/\\w+\\d+\\.pdf");
                Matcher matcher2 = pattern2.matcher(line);
                if (matcher2.find(0)) {
                    link = "http://" + this.hostname + line.substring(matcher2.start(), matcher2.end());
                    continue;
                }
                if (!matcherFramelink.find(0)) continue;
                String frameLinkURL = "http://" + this.hostname + line.substring(matcherFramelink.start(), matcherFramelink.end());
                downloadPDF dl = new downloadPDF(frameLinkURL);
                GetMethod method = new GetMethod(frameLinkURL);
                int iGetResultCode = this.client.executeMethod((HttpMethod)method);
                if (IPapersPlugin.log.isDebugEnabled()) {
                    IPapersPlugin.log.debug((Object)("result code:" + iGetResultCode));
                }
                link = dl.PDFLocation();
                break;
            }
            br.close();
            in.close();
        }
        catch (PDFDownloadException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return link;
    }
}

