/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.ipapers;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import jp.sourceforge.concierge.editor.EditorEvent;
import jp.sourceforge.concierge.editor.IConciergeDialogArea;
import jp.sourceforge.concierge.editor.IEditorEventListener;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.TypeDomImpl;
import jp.sourceforge.concierge.mdocument.TypeManager;
import jp.sourceforge.concierge.parser.ITypeParser;
import jp.sourceforge.concierge.plugin.ipapers.CannotGetPaperInfoException;
import jp.sourceforge.concierge.plugin.ipapers.CannotGuessIdtypeException;
import jp.sourceforge.concierge.plugin.ipapers.Paper;
import jp.sourceforge.concierge.plugin.ipapers.PaperFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PaperDialogArea
implements IConciergeDialogArea {
    private static final int VMARGIN = 5;
    private static final int HMARGIN = 2;
    private static final int HEIGHT = 15;
    private static final int FIRSTWIDTH = 55;
    private Document schema = TypeManager.getTypeDocument((String)"Paper");
    private Document metadata = null;
    private Hashtable<String, Text> texthash = new Hashtable();
    private Group group1 = null;
    private IEditorEventListener elistener = null;

    public Control createDialogArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.group1 = new Group(parent, 64);
        this.group1.setText("Reference Info");
        this.group1.setLayoutData((Object)new GridData(768));
        this.group1.setLayout((Layout)new FormLayout());
        Label lblAuthor = new Label((Composite)this.group1, 0);
        lblAuthor.setText("Author");
        lblAuthor.setAlignment(131072);
        FormData fdr = new FormData();
        fdr.top = new FormAttachment(0, 5);
        fdr.left = new FormAttachment(0, 0);
        fdr.right = new FormAttachment(0, 55);
        fdr.height = 15;
        lblAuthor.setLayoutData((Object)fdr);
        Text txtAuthor = new Text((Composite)this.group1, 2052);
        FormData fdl = new FormData();
        fdl.top = new FormAttachment(0, 5);
        fdl.left = new FormAttachment((Control)lblAuthor, 2);
        fdl.right = new FormAttachment(100, -5);
        fdl.height = 15;
        txtAuthor.setLayoutData((Object)fdl);
        this.texthash.put("Author", txtAuthor);
        Label lblTitle = new Label((Composite)this.group1, 0);
        lblTitle.setText("Title");
        lblTitle.setAlignment(131072);
        fdr = new FormData();
        fdr.top = new FormAttachment((Control)txtAuthor, 5);
        fdr.left = new FormAttachment(0, 0);
        fdr.right = new FormAttachment(0, 55);
        fdr.height = 15;
        lblTitle.setLayoutData((Object)fdr);
        Text txtTitle = new Text((Composite)this.group1, 2052);
        fdl = new FormData();
        fdl.top = new FormAttachment((Control)txtAuthor, 5);
        fdl.left = new FormAttachment((Control)lblTitle, 2);
        fdl.right = new FormAttachment(100, -5);
        fdl.height = 15;
        txtTitle.setLayoutData((Object)fdl);
        this.texthash.put("Title", txtTitle);
        Label lblJournal = new Label((Composite)this.group1, 0);
        lblJournal.setText("Journal");
        lblJournal.setAlignment(131072);
        fdr = new FormData();
        fdr.top = new FormAttachment((Control)txtTitle, 5);
        fdr.left = new FormAttachment(0, 0);
        fdr.right = new FormAttachment(0, 55);
        fdr.height = 15;
        lblJournal.setLayoutData((Object)fdr);
        Text txtJournal = new Text((Composite)this.group1, 2052);
        fdl = new FormData();
        fdl.top = new FormAttachment((Control)txtTitle, 5);
        fdl.left = new FormAttachment((Control)lblJournal, 2);
        fdl.right = new FormAttachment(66, -5);
        fdl.height = 15;
        txtJournal.setLayoutData((Object)fdl);
        this.texthash.put("Journal", txtJournal);
        Label lblYear = new Label((Composite)this.group1, 0);
        lblYear.setText("Year");
        lblYear.setAlignment(131072);
        fdr = new FormData();
        fdr.top = new FormAttachment((Control)txtTitle, 5);
        fdr.left = new FormAttachment((Control)txtJournal, 5);
        fdr.height = 15;
        lblYear.setLayoutData((Object)fdr);
        Text txtYear = new Text((Composite)this.group1, 2052);
        fdl = new FormData();
        fdl.top = new FormAttachment((Control)txtTitle, 5);
        fdl.left = new FormAttachment((Control)lblYear, 2);
        fdl.right = new FormAttachment(100, -5);
        fdl.height = 15;
        txtYear.setLayoutData((Object)fdl);
        this.texthash.put("Year", txtYear);
        Label lblVolume = new Label((Composite)this.group1, 0);
        lblVolume.setText("Vol");
        lblVolume.setAlignment(131072);
        fdr = new FormData();
        fdr.top = new FormAttachment((Control)txtJournal, 5);
        fdr.left = new FormAttachment(0, 5);
        fdr.right = new FormAttachment(0, 55);
        fdr.height = 15;
        lblVolume.setLayoutData((Object)fdr);
        Text txtVolume = new Text((Composite)this.group1, 2052);
        fdl = new FormData();
        fdl.top = new FormAttachment((Control)txtJournal, 5);
        fdl.left = new FormAttachment((Control)lblVolume, 2);
        fdl.right = new FormAttachment(33, -5);
        fdl.height = 15;
        txtVolume.setLayoutData((Object)fdl);
        this.texthash.put("Volume", txtVolume);
        Label lblNumber = new Label((Composite)this.group1, 0);
        lblNumber.setText("No");
        lblNumber.setAlignment(131072);
        fdr = new FormData();
        fdr.top = new FormAttachment((Control)txtJournal, 5);
        fdr.left = new FormAttachment((Control)txtVolume, 5);
        fdr.height = 15;
        lblNumber.setLayoutData((Object)fdr);
        Text txtNumber = new Text((Composite)this.group1, 2052);
        fdl = new FormData();
        fdl.top = new FormAttachment((Control)txtJournal, 5);
        fdl.left = new FormAttachment((Control)lblNumber, 2);
        fdl.right = new FormAttachment(66, -5);
        fdl.height = 15;
        txtNumber.setLayoutData((Object)fdl);
        this.texthash.put("Number", txtNumber);
        Label lblPages = new Label((Composite)this.group1, 0);
        lblPages.setText("Pages");
        lblPages.setAlignment(131072);
        fdr = new FormData();
        fdr.top = new FormAttachment((Control)txtJournal, 5);
        fdr.left = new FormAttachment((Control)txtNumber, 5);
        fdr.height = 15;
        lblPages.setLayoutData((Object)fdr);
        Text txtPages = new Text((Composite)this.group1, 2052);
        fdl = new FormData();
        fdl.top = new FormAttachment((Control)txtJournal, 5);
        fdl.left = new FormAttachment((Control)lblPages, 2);
        fdl.right = new FormAttachment(100, -5);
        fdl.height = 15;
        txtPages.setLayoutData((Object)fdl);
        this.texthash.put("Pages", txtPages);
        Label lblIDs = new Label((Composite)this.group1, 0);
        lblIDs.setText("IDs");
        lblIDs.setAlignment(131072);
        fdr = new FormData();
        fdr.top = new FormAttachment((Control)txtVolume, 5);
        fdr.left = new FormAttachment(0, 5);
        fdr.right = new FormAttachment(0, 55);
        fdr.height = 15;
        lblIDs.setLayoutData((Object)fdr);
        Text txtIDs = new Text((Composite)this.group1, 2052);
        fdl = new FormData();
        fdl.top = new FormAttachment((Control)txtVolume, 5);
        fdl.left = new FormAttachment((Control)lblIDs, 2);
        fdl.right = new FormAttachment(100, -5);
        fdl.height = 15;
        txtIDs.setLayoutData((Object)fdl);
        this.texthash.put("IDs", txtIDs);
        Label lblAbstract = new Label((Composite)this.group1, 0);
        lblAbstract.setText("Abstract");
        lblAbstract.setAlignment(131072);
        fdr = new FormData();
        fdr.top = new FormAttachment((Control)txtIDs, 5);
        fdr.left = new FormAttachment(0, 0);
        fdr.right = new FormAttachment(0, 55);
        fdr.height = 15;
        lblAbstract.setLayoutData((Object)fdr);
        Text txtAbstract = new Text((Composite)this.group1, 578);
        fdl = new FormData();
        fdl.top = new FormAttachment((Control)txtIDs, 5);
        fdl.left = new FormAttachment((Control)lblAbstract, 5);
        fdl.right = new FormAttachment(100, -5);
        fdl.height = 90;
        txtAbstract.setLayoutData((Object)fdl);
        this.texthash.put("Abstract", txtAbstract);
        this.refresh();
        Enumeration<Text> et = this.texthash.elements();
        while (et.hasMoreElements()) {
            et.nextElement().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (PaperDialogArea.this.elistener != null) {
                        PaperDialogArea.this.elistener.run(new EditorEvent(1, e.widget, (Object)PaperDialogArea.this.metadata));
                    }
                }
            });
        }
        return parent;
    }

    public void setDocument(Document metadata) {
        this.metadata = metadata;
    }

    public Document saveDocument() {
        Element data = DataDomImpl.getDataOfType((Document)this.metadata, (String)"Paper");
        if (data == null) {
            data = DataDomImpl.addDataOfType((Document)this.metadata, (Document)this.schema);
        }
        ArrayList metas = DataDomImpl.getAllParsersElements((Element)data);
        int i = 0;
        while (i < metas.size()) {
            Element meta = (Element)metas.get(i);
            String tname = DataDomImpl.getTagName((Element)meta);
            Text text = this.texthash.get(tname);
            if (text != null) {
                Element schm = TypeDomImpl.getElement((Document)this.schema, (String)tname);
                String pname = TypeDomImpl.getParser((Element)schm);
                try {
                    ITypeParser parser = FrameworkPlugin.getParser((String)pname);
                    if (parser != null) {
                        parser.putToElement(meta, text.getText());
                    }
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
            ++i;
        }
        return this.metadata;
    }

    public void refresh() {
        ArrayList metas = DataDomImpl.getAllParsersElements((Document)this.metadata, (String)"Paper");
        int i = 0;
        while (i < metas.size()) {
            Element meta = (Element)metas.get(i);
            String tname = DataDomImpl.getTagName((Element)meta);
            Element schm = TypeDomImpl.getElement((Document)this.schema, (String)tname);
            String pname = TypeDomImpl.getParser((Element)schm);
            Text txt = this.texthash.get(tname);
            if (txt != null) {
                try {
                    ITypeParser parser = FrameworkPlugin.getParser((String)pname);
                    if (parser != null) {
                        String cntnt = parser.getSingleText(meta);
                        txt.setText(cntnt);
                    }
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
            ++i;
        }
    }

    private void searchIDandCreatePaper(String filepath, Document metadata) {
        try {
            Paper paper = PaperFactory.getInstance().create(filepath);
            System.err.println(paper.getPaperInfo().getTitle());
            Hashtable<String, String> items = paper.toHashtable();
            Element data = DataDomImpl.getDataOfType((Document)metadata, (String)"Paper");
            if (data == null) {
                data = DataDomImpl.addDataOfType((Document)metadata, (Document)this.schema);
            }
            ArrayList metas = DataDomImpl.getAllParsersElements((Element)data);
            int i = 0;
            while (i < metas.size()) {
                String value;
                Element meta = (Element)metas.get(i);
                String tname = DataDomImpl.getTagName((Element)meta);
                Element schm = TypeDomImpl.getElement((Document)this.schema, (String)tname);
                String pname = TypeDomImpl.getParser((Element)schm);
                ITypeParser parser = FrameworkPlugin.getParser((String)pname);
                if (parser != null && (value = items.get(tname)) != null && value.length() > 0) {
                    parser.putToElement(meta, value);
                }
                ++i;
            }
        }
        catch (CannotGuessIdtypeException cannotGuessIdtypeException) {
            return;
        }
        catch (CannotGetPaperInfoException cannotGetPaperInfoException) {
            return;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return;
        }
    }

    public void setDocumentChangeListener(IEditorEventListener listener) {
        this.elistener = listener;
    }

    public String getType() {
        return "Paper";
    }

    public void setEnabled(boolean enabled) {
        Color lc = null;
        if (enabled) {
            lc = this.group1.getDisplay().getSystemColor(2);
        } else {
            lc = this.group1.getDisplay().getSystemColor(15);
            Enumeration<Text> en = this.texthash.elements();
            while (en.hasMoreElements()) {
                Text t = en.nextElement();
                if (t.getText().length() <= 0) continue;
                t.setText("");
            }
        }
        Control[] ctrls1 = this.group1.getChildren();
        int i = 0;
        while (i < ctrls1.length) {
            if (ctrls1[i] instanceof Label) {
                ctrls1[i].setForeground(lc);
            }
            ctrls1[i].setEnabled(enabled);
            ++i;
        }
        this.group1.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.group1.isEnabled();
    }

    public void fillout() {
        String filepath = DataDomImpl.getFilePath((Document)this.metadata);
        if (filepath != null && filepath.length() > 0) {
            try {
                this.searchIDandCreatePaper(filepath, this.metadata);
                this.refresh();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
    }

    public void dispose() {
    }

    public boolean isDisposed() {
        return this.group1.isDisposed();
    }
}

