/*
 * Decompiled with CFR 0.152.
 */
package org.xmldb.xupdate.lexus;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.ParserAdapter;
import org.xmldb.common.xml.queries.XUpdateQuery;
import org.xmldb.xupdate.lexus.XUpdateQueryParser;
import org.xmldb.xupdate.lexus.commands.CommandConstants;
import org.xmldb.xupdate.lexus.commands.CommandObject;
import org.xmldb.xupdate.lexus.commands.DefaultCommand;

public class XUpdateQueryImpl
implements XUpdateQuery {
    public static final String NAMESPACE_URI = "http://www.xmldb.org/xupdate";
    protected Vector[] query = null;
    protected CommandConstants commandConstants = new CommandConstants();
    protected Node namespace = null;
    protected HashMap namespaces = null;

    public void setQString(String string) throws SAXException {
        XUpdateQueryParser xUpdateQueryParser = new XUpdateQueryParser(this.commandConstants);
        try {
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            ParserAdapter parserAdapter = new ParserAdapter(sAXParser.getParser());
            parserAdapter.setContentHandler(xUpdateQueryParser);
            parserAdapter.parse(new InputSource(new StringReader(string)));
        }
        catch (Exception exception) {
            throw new SAXException(exception.getMessage());
        }
        this.namespaces = xUpdateQueryParser.getNamespaceMappings();
        this.query = xUpdateQueryParser.getCachedQuery();
        if (this.query[0].size() == 0) {
            throw new SAXException("query contains no XUpdateOperation !");
        }
    }

    public void setNamespace(Node node) {
        this.namespace = node;
    }

    public void setNodeFilter(NodeFilter nodeFilter) {
    }

    public void execute(Node node) throws Exception {
        CommandObject commandObject = new DefaultCommand(node);
        Enumeration enumeration = this.query[0].elements();
        Enumeration enumeration2 = this.query[1].elements();
        Enumeration enumeration3 = this.query[2].elements();
        block4: while (enumeration.hasMoreElements()) {
            int n = (Integer)enumeration.nextElement();
            if (n > 0) {
                switch (n) {
                    case 200: {
                        commandObject.submitAttributes((Hashtable)enumeration2.nextElement());
                        break;
                    }
                    case 300: {
                        commandObject.submitCharacters((String)enumeration3.nextElement());
                        break;
                    }
                    default: {
                        if (commandObject.submitInstruction(n)) continue block4;
                        this.commandConstants.setContextNode(node);
                        commandObject = this.commandConstants.commandForID(n);
                        if (commandObject == null) {
                            throw new Exception("operation can not have any XUpdate-instruction !");
                        }
                        commandObject.reset();
                        break;
                    }
                }
                continue;
            }
            if (commandObject.executeInstruction()) continue;
            node = commandObject.execute();
            commandObject = new DefaultCommand(node);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.err.println("usage: java org.xmldb.xupdate.lexus.XUpdateQueryImpl update document");
            System.err.println("       update   - filename of the file which contains XUpdate operations");
            System.err.println("       document - filename of the file which contains the content to update");
            System.exit(0);
        }
        File file = new File(stringArray[0]);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        char[] cArray = new char[new Long(file.length()).intValue()];
        bufferedReader.read(cArray, 0, new Long(file.length()).intValue());
        String string = new String(cArray);
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        document = documentBuilder.parse(stringArray[1]);
        System.setProperty("org.xmldb.common.xml.queries.XPathQueryFactory", "org.xmldb.common.xml.queries.xalan2.XPathQueryFactoryImpl");
        XUpdateQueryImpl xUpdateQueryImpl = new XUpdateQueryImpl();
        System.err.println("Starting updates...");
        long l = System.currentTimeMillis();
        xUpdateQueryImpl.setQString(string);
        xUpdateQueryImpl.execute(document);
        long l2 = System.currentTimeMillis();
        System.err.println("Updates done in " + (l2 - l) + " ms ...");
    }
}

