/*
 * Decompiled with CFR 0.152.
 */
package org.xmldb.common.xml.queries.test;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xmldb.common.xml.queries.XObject;
import org.xmldb.common.xml.queries.XPathQuery;
import org.xmldb.common.xml.queries.XPathQueryFactory;

public class XPathTest {
    public static void main(String[] stringArray) throws Exception {
        XPathQueryFactory xPathQueryFactory = XPathQueryFactory.newInstance();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(stringArray[0]);
        long l = System.currentTimeMillis();
        XPathQuery xPathQuery = xPathQueryFactory.newXPathQuery();
        System.out.println(xPathQuery.getClass().getName());
        xPathQuery.setQString("/*");
        System.out.println("init: " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        XObject xObject = xPathQuery.execute(document);
        System.out.println("execute: " + (System.currentTimeMillis() - l));
        XPathTest.printResult(xObject);
        xObject = xPathQuery.execute(document);
        XPathTest.printResult(xObject);
    }

    protected static void printResult(XObject xObject) throws Exception {
        if (xObject == null) {
            System.out.println("XPath query: result: null");
        } else {
            System.out.print("XPATH query: result: ");
            switch (xObject.getType()) {
                case 1: {
                    System.out.println("(Boolean): " + xObject.bool());
                    break;
                }
                case 2: {
                    System.out.println("(Number): " + xObject.num());
                    break;
                }
                case 3: {
                    System.out.println("(String): " + xObject.str());
                    break;
                }
                case 5: {
                    System.out.println("(DocumentFragment): -");
                    break;
                }
                case 4: {
                    NodeList nodeList = xObject.nodeset();
                    System.out.println("(NodeList): " + nodeList.getLength() + " Entries");
                    int n = 0;
                    while (n < nodeList.getLength()) {
                        System.out.print(n + 1 + " Entry: ");
                        System.out.println("        value=" + nodeList.item(n).getNodeName());
                        ++n;
                    }
                    break;
                }
                default: {
                    System.out.println("(Unknown): -");
                }
            }
        }
    }
}

