/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.footprint.text;

import java.util.ArrayList;
import jp.sourceforge.concierge.framework.ConciergeDialog;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.IConciergeDialog;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.plugin.FootprintPlugin;
import jp.sourceforge.concierge.plugin.footprint.text.ConciergeEditorDropListener;
import jp.sourceforge.concierge.plugin.footprint.text.ConciergeEditorPreference;
import jp.sourceforge.concierge.plugin.footprint.text.EmbeddedDocument;
import jp.sourceforge.concierge.plugin.footprint.text.EmbeddedFile;
import jp.sourceforge.concierge.plugin.footprint.text.EmbeddedObject;
import jp.sourceforge.concierge.plugin.footprint.text.FormatDialog;
import jp.sourceforge.concierge.plugin.footprint.text.FormatParameter;
import jp.sourceforge.concierge.plugin.footprint.text.HTMLConverter;
import jp.sourceforge.concierge.plugin.footprint.text.IndentParameter;
import jp.sourceforge.concierge.plugin.footprint.text.LineUtils;
import jp.sourceforge.concierge.plugin.footprint.text.SizeDialog;
import jp.sourceforge.concierge.util.DataDomImpl;
import jp.sourceforge.concierge.util.DataDomTransfer;
import jp.sourceforge.concierge.util.DomImpl;
import jp.sourceforge.concierge.util.GraphicUtil;
import jp.sourceforge.concierge.util.TypeDomImpl;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.PaintObjectEvent;
import org.eclipse.swt.custom.PaintObjectListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.w3c.dom.Document;

public class ConciergeEditor
extends Composite {
    private static final int DEFAULTIMAGEWIDTH = 240;
    private boolean verifyindent = true;
    private Color linkcolor = new Color(null, 0, 0, 255);
    private FontRegistry fregistry = new FontRegistry();
    public static final String IMAGECHAR = "\ufffc";
    public static final String INDENTCHAR = "\u30fb ";
    private FormatParameter[] fontparams;
    private IndentParameter indparam;
    private StyledText textview;
    private ConciergeEditorPreference preference;
    private Font defaultFont;
    private Color defaultBackground;
    private Color defaultForeground;
    private ArrayList emclipboard = new ArrayList();

    private EmbeddedObject getEmbeddedObjectAtLocation(Point l) {
        ArrayList al = (ArrayList)this.textview.getData();
        int i = 0;
        while (i < al.size()) {
            EmbeddedObject o = (EmbeddedObject)al.get(i);
            Point sz = o.getSize();
            if (sz == null) {
                Rectangle r = o.getObjectImage().getBounds();
                sz = new Point(r.width, r.height);
            }
            Point p = this.textview.getLocationAtOffset(o.getOffset());
            if (p.x <= l.x && l.x < p.x + sz.x && p.y <= l.y && l.y <= p.y + sz.y) {
                return o;
            }
            ++i;
        }
        return null;
    }

    private boolean isApplyed(Point range, StyleRange style, int update) {
        int i = range.x;
        while (i < range.y) {
            StyleRange sr = this.textview.getStyleRangeAtOffset(i);
            if (sr != null) {
                switch (update) {
                    case 1: 
                    case 2: 
                    case 16: {
                        return false;
                    }
                    case 8: {
                        if (sr.font != null && sr.font.equals((Object)style.font)) {
                            return true;
                        }
                    }
                    case 64: {
                        if (!sr.strikeout) break;
                        return true;
                    }
                    case 32: {
                        if (!sr.underline) break;
                        return true;
                    }
                    case 4: {
                        if (!(sr.font == null ? (sr.fontStyle & style.fontStyle) != 0 : (sr.font.getFontData()[0].getStyle() & style.fontStyle) != 0)) break;
                        return true;
                    }
                }
            }
            ++i;
        }
        return false;
    }

    private void applyStyle(StyleRange newsr, StyleRange style, int update) {
        if ((update & 2) != 0) {
            newsr.background = style.background;
        }
        if ((update & 1) != 0) {
            newsr.foreground = style.foreground;
        }
        if ((update & 8) != 0) {
            newsr.font = style.font;
        }
        if ((update & 0x10) != 0) {
            newsr.rise = style.rise;
        }
        if ((update & 0x20) != 0) {
            newsr.underline = style.underline;
        }
        if ((update & 0x40) != 0) {
            newsr.strikeout = style.strikeout;
        }
        if ((update & 0x80) != 0) {
            newsr.metrics = style.metrics;
        }
        if ((update & 4) != 0) {
            if (newsr.font == null) {
                switch (style.fontStyle) {
                    case 1: 
                    case 2: {
                        if (newsr.fontStyle == 0) {
                            newsr.fontStyle = style.fontStyle;
                            break;
                        }
                        newsr.fontStyle |= style.fontStyle;
                        break;
                    }
                    case -3: 
                    case -2: {
                        newsr.fontStyle &= style.fontStyle;
                    }
                }
            } else {
                FontData fd = newsr.font.getFontData()[0];
                int fdstyle = fd.getStyle();
                switch (style.fontStyle) {
                    case 1: 
                    case 2: {
                        if (fdstyle == 0) {
                            fdstyle = style.fontStyle;
                            break;
                        }
                        fdstyle |= style.fontStyle;
                        break;
                    }
                    case -3: 
                    case -2: {
                        fdstyle &= style.fontStyle;
                    }
                }
                fd.setStyle(fdstyle);
                if (this.fregistry.hasValueFor(fd.toString())) {
                    newsr.font = this.fregistry.get(fd.toString());
                } else {
                    newsr.font = new Font((Device)this.textview.getDisplay(), fd);
                    this.fregistry.put(fd.toString(), newsr.font.getFontData());
                }
            }
        }
    }

    private StyleRange getStyleRangeAtOffset(StyleRange[] srs, int offset) {
        int i = 0;
        while (i < srs.length) {
            if (srs[i].start <= offset && offset < srs[i].start + srs[i].length) {
                return srs[i];
            }
            ++i;
        }
        return null;
    }

    private void setNewStyleAtRange(Point range, StyleRange style, int update) {
        int start = range.x;
        int length = 0;
        StyleRange[] srs = this.textview.getStyleRanges(range.x, range.y - range.x, true);
        ArrayList<StyleRange> newsrs = new ArrayList<StyleRange>();
        int i = range.x;
        while (i < range.y) {
            StyleRange sr = this.getStyleRangeAtOffset(srs, i);
            if (sr != null) {
                if (length > 0) {
                    StyleRange nsr = new StyleRange(start, length, null, null, 0);
                    this.applyStyle(nsr, style, update);
                    newsrs.add(nsr);
                    start += length;
                }
                String s = this.textview.getText(i, i);
                length = sr.start + sr.length - start;
                if (s.compareTo(IMAGECHAR) == 0) {
                    this.textview.setStyleRange((StyleRange)sr.clone());
                } else {
                    StyleRange nsr = (StyleRange)sr.clone();
                    nsr.start = start;
                    nsr.length = length;
                    this.applyStyle(nsr, style, update);
                    newsrs.add(nsr);
                }
                start = i + length;
                i = start - 1;
                length = 0;
            } else {
                ++length;
            }
            ++i;
        }
        if (length > 0) {
            StyleRange nsr = new StyleRange(start, length, null, null, 0);
            this.applyStyle(nsr, style, update);
            newsrs.add(nsr);
        }
        StyleRange[] srsarr = new StyleRange[newsrs.size()];
        int i2 = 0;
        while (i2 < srsarr.length) {
            srsarr[i2] = (StyleRange)newsrs.get(i2);
            ++i2;
        }
        this.textview.replaceStyleRanges(range.x, range.y - range.x, new StyleRange[]{new StyleRange()});
        this.textview.replaceStyleRanges(range.x, range.y - range.x, srsarr);
    }

    private void hookContextMenu() {
        this.textview.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                switch (event.button) {
                    case 1: {
                        if ((event.stateMask & 0x40000) != 0) break;
                        return;
                    }
                }
                Menu menu = new Menu((Decorations)ConciergeEditor.this.textview.getShell(), 8);
                MenuItem item = new MenuItem(menu, 8);
                item.setText("Cut");
                item.addListener(13, new Listener(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void handleEvent(Event e) {
                        ConciergeEditor.access$0(1.access$0(this.this$1)).cut();
                    }
                });
                item = new MenuItem(menu, 8);
                item.setText("Copy");
                item.addListener(13, new Listener(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void handleEvent(Event e) {
                        ConciergeEditor.access$0(1.access$0(this.this$1)).copy();
                    }
                });
                item = new MenuItem(menu, 8);
                item.setText("Paste");
                item.addListener(13, new Listener(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void handleEvent(Event e) {
                        ConciergeEditor.access$0(1.access$0(this.this$1)).paste();
                    }
                });
                EmbeddedObject o = ConciergeEditor.this.getEmbeddedObjectAtLocation(new Point(event.x, event.y));
                if (o != null && o.editable()) {
                    item = new MenuItem(menu, 2);
                    item = new MenuItem(menu, 8);
                    item.setText("Edit Metadata");
                    item.addListener(13, new Listener(this, o){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ EmbeddedObject val$o;
                        {
                            this.this$1 = var1_1;
                            this.val$o = embeddedObject;
                        }

                        public void handleEvent(Event e) {
                            String typename = DataDomImpl.getType((Document)this.val$o.getDocument());
                            Request req = new Request(4, (Object)("/type[@name='" + typename + "']"), "type");
                            ArrayList list = FrameworkPlugin.getDefault().getDocumentsOfQuery(req);
                            if (list == null || list.size() == 0) {
                                return;
                            }
                            Document tdoc = (Document)list.get(0);
                            String pluginid = TypeDomImpl.getPluginID((Document)tdoc);
                            if (pluginid != null && pluginid.length() > 0) {
                                IConciergeDialog plugin = FrameworkPlugin.getDialogPlugin((String)pluginid);
                                if (plugin == null) {
                                    return;
                                }
                                ConciergeDialog dlg = plugin.getDialog(ConciergeEditor.access$0(1.access$0(this.this$1)).getShell(), 0);
                                dlg.setDocument(this.val$o.getDocument(), (Object)FootprintPlugin.getDefault().getBundle().getSymbolicName());
                                dlg.open();
                                this.val$o.refresh();
                                Point p = this.val$o.getSize();
                                StyleRange sr = ConciergeEditor.access$0(1.access$0(this.this$1)).getStyleRangeAtOffset(this.val$o.getOffset());
                                sr.start = this.val$o.getOffset();
                                sr.length = 1;
                                sr.metrics = new GlyphMetrics(p.y, 0, p.x);
                                ConciergeEditor.access$0(1.access$0(this.this$1)).setStyleRange(sr);
                                ConciergeEditor.access$0(1.access$0(this.this$1)).redraw();
                                ConciergeEditor.access$0(1.access$0(this.this$1)).update();
                            }
                        }
                    });
                }
                if (o != null && o.resizable()) {
                    item = new MenuItem(menu, 8);
                    item.setText("Resize image");
                    item.addListener(13, new Listener(this, o){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ EmbeddedObject val$o;
                        {
                            this.this$1 = var1_1;
                            this.val$o = embeddedObject;
                        }

                        public void handleEvent(Event e) {
                            Point sz = this.val$o.getSize();
                            if (sz == null) {
                                Rectangle rect = this.val$o.getObjectImage().getBounds();
                                sz = new Point(rect.width, rect.height);
                            }
                            SizeDialog szdlg = new SizeDialog(ConciergeEditor.access$0(1.access$0(this.this$1)).getShell(), 0, ConciergeEditor.access$0(1.access$0(this.this$1)), this.val$o);
                            szdlg.open();
                        }
                    });
                }
                Point tp = ConciergeEditor.this.textview.getLocation();
                Point dp = ConciergeEditor.this.textview.toDisplay(tp.x, tp.y);
                menu.setLocation(event.x + dp.x, event.y + dp.y);
                menu.setVisible(true);
                Display display = ConciergeEditor.this.textview.getDisplay();
                while (!menu.isDisposed() && menu.isVisible()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
                menu.dispose();
            }

            static /* synthetic */ ConciergeEditor access$0(1 var0) {
                return var0.ConciergeEditor.this;
            }
        });
        this.textview.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                EmbeddedObject o = ConciergeEditor.this.getEmbeddedObjectAtLocation(new Point(e.x, e.y));
                if (o != null) {
                    ConciergeEditor.this.textview.setCursor(new Cursor(null, 0));
                    Document doc = o.getDocument();
                    String str = "ID:" + String.valueOf(DomImpl.getID((Document)doc));
                    String txt = DomImpl.getAllText((Document)doc);
                    if (txt.length() != 0) {
                        str = String.valueOf(str) + "\n" + txt;
                    }
                    ConciergeEditor.this.textview.setToolTipText(str);
                } else {
                    ConciergeEditor.this.textview.setCursor(new Cursor(null, 19));
                    ConciergeEditor.this.textview.setToolTipText("");
                }
            }
        });
    }

    public ConciergeEditor(Composite parent) {
        super(parent, 0);
        this.preference = new ConciergeEditorPreference();
        GridLayout gl = new GridLayout(2, true);
        gl.marginWidth = 1;
        gl.marginHeight = 1;
        gl.horizontalSpacing = 1;
        gl.verticalSpacing = 1;
        this.setLayout((Layout)gl);
        GraphicUtil.setBackground((Control)this, (int)1);
        Label label = new Label((Composite)this, 0);
        label.setText("Comment");
        label.setLayoutData((Object)new GridData(0));
        GraphicUtil.setBackground((Control)label, (int)1);
        ToolBar tb = new ToolBar((Composite)this, 131072);
        tb.setLayoutData((Object)new GridData(768));
        GraphicUtil.setBackground((Control)tb, (int)1);
        ToolItem ti = new ToolItem(tb, 2056);
        ti.setImage(FootprintPlugin.getImageDescriptor("icons/bold.bmp").createImage());
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Point p = ConciergeEditor.this.textview.getSelection();
                if (p.x == p.y) {
                    return;
                }
                StyleRange newstyle = new StyleRange(0, 0, null, null, 1);
                int n = ConciergeEditor.this.isApplyed(p, newstyle, 4) ? -2 : 1;
                newstyle.fontStyle = n;
                ConciergeEditor.this.setNewStyleAtRange(p, newstyle, 4);
            }
        });
        ti = new ToolItem(tb, 2056);
        ti.setImage(FootprintPlugin.getImageDescriptor("icons/italic.bmp").createImage());
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Point p = ConciergeEditor.this.textview.getSelection();
                if (p.x == p.y) {
                    return;
                }
                StyleRange newstyle = new StyleRange(0, 0, null, null, 2);
                int n = ConciergeEditor.this.isApplyed(p, newstyle, 4) ? -3 : 2;
                newstyle.fontStyle = n;
                ConciergeEditor.this.setNewStyleAtRange(p, newstyle, 4);
            }
        });
        ti = new ToolItem(tb, 2056);
        ti.setImage(FootprintPlugin.getImageDescriptor("icons/underline.bmp").createImage());
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Point p = ConciergeEditor.this.textview.getSelection();
                if (p.x == p.y) {
                    return;
                }
                StyleRange newstyle = new StyleRange(0, 0, null, null, -1);
                newstyle.underline = true;
                newstyle.underline = !ConciergeEditor.this.isApplyed(p, newstyle, 32);
                ConciergeEditor.this.setNewStyleAtRange(p, newstyle, 32);
            }
        });
        ti = new ToolItem(tb, 2056);
        ti.setImage(FootprintPlugin.getImageDescriptor("icons/strikeout.bmp").createImage());
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Point p = ConciergeEditor.this.textview.getSelection();
                if (p.x == p.y) {
                    return;
                }
                StyleRange newstyle = new StyleRange(0, 0, null, null, -1);
                newstyle.strikeout = true;
                newstyle.strikeout = !ConciergeEditor.this.isApplyed(p, newstyle, 64);
                ConciergeEditor.this.setNewStyleAtRange(p, newstyle, 64);
            }
        });
        ti = new ToolItem(tb, 2);
        ti = new ToolItem(tb, 2056);
        ti.setImage(FootprintPlugin.getImageDescriptor("icons/indent.gif").createImage());
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Point p = ConciergeEditor.this.textview.getSelection();
                int sl = ConciergeEditor.this.textview.getLineAtOffset(p.x);
                int el = ConciergeEditor.this.textview.getLineAtOffset(p.y);
                int i = sl;
                while (i <= el) {
                    int top;
                    int indent = ConciergeEditor.this.textview.getLineIndent(i);
                    if (indent == 0) {
                        top = ConciergeEditor.this.textview.getOffsetAtLine(i);
                        ConciergeEditor.this.verifyindent = false;
                        ConciergeEditor.this.textview.replaceTextRange(top, 0, ConciergeEditor.INDENTCHAR);
                        ConciergeEditor.this.textview.setLineIndent(i, 1, ((ConciergeEditor)ConciergeEditor.this).indparam.indent);
                        ConciergeEditor.this.textview.setCaretOffset(ConciergeEditor.this.textview.getCaretOffset() + ConciergeEditor.INDENTCHAR.length());
                    } else {
                        top = ConciergeEditor.this.textview.getOffsetAtLine(i);
                        if (ConciergeEditor.this.textview.getTextRange(top, ConciergeEditor.INDENTCHAR.length()).compareTo(ConciergeEditor.INDENTCHAR) == 0) {
                            ConciergeEditor.this.verifyindent = false;
                            ConciergeEditor.this.textview.replaceTextRange(top, ConciergeEditor.INDENTCHAR.length(), "");
                        }
                        ConciergeEditor.this.textview.setLineIndent(i, 1, 0);
                    }
                    ++i;
                }
            }
        });
        ti = new ToolItem(tb, 2056);
        ti.setImage(FootprintPlugin.getImageDescriptor("icons/heading.gif").createImage());
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            private void setHeading(String fontname, int fontsize, int style, boolean ul) {
                Point p = ConciergeEditor.this.textview.getSelection();
                int sl = ConciergeEditor.this.textview.getLineAtOffset(p.x);
                int el = ConciergeEditor.this.textview.getLineAtOffset(p.y);
                StyleRange newstyle = new StyleRange();
                newstyle.font = fontname.length() == 0 ? null : new Font((Device)ConciergeEditor.this.textview.getDisplay(), fontname, fontsize, style);
                newstyle.underline = ul;
                if (newstyle.font != null) {
                    FontData fd = newstyle.font.getFontData()[0];
                    if (ConciergeEditor.this.fregistry.hasValueFor(fd.toString())) {
                        newstyle.font.dispose();
                        newstyle.font = ConciergeEditor.this.fregistry.get(fd.toString());
                    } else {
                        ConciergeEditor.this.fregistry.put(fd.toString(), newstyle.font.getFontData());
                    }
                }
                int i = sl;
                while (i <= el) {
                    Point pt = new Point(0, 0);
                    pt.x = ConciergeEditor.this.textview.getOffsetAtLine(i);
                    pt.y = LineUtils.getLastOffsetAtLine(ConciergeEditor.this.textview, i) + 1;
                    ConciergeEditor.this.setNewStyleAtRange(pt, newstyle, 40);
                    ++i;
                }
            }

            public void widgetSelected(SelectionEvent e) {
                Menu menu = new Menu((Decorations)ConciergeEditor.this.textview.getShell(), 8);
                MenuItem item = new MenuItem(menu, 8);
                item.setText("Heading 1");
                item.addListener(13, new Listener(this){
                    final /* synthetic */ 13 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void handleEvent(Event e) {
                        13.access$0(this.this$1, ConciergeEditor.access$7((ConciergeEditor)13.access$1(this.this$1))[0].name, ConciergeEditor.access$7((ConciergeEditor)13.access$1(this.this$1))[0].size, ConciergeEditor.access$7((ConciergeEditor)13.access$1(this.this$1))[0].style, ConciergeEditor.access$7((ConciergeEditor)13.access$1(this.this$1))[0].underline);
                    }
                });
                item = new MenuItem(menu, 8);
                item.setText("Heading 2");
                item.addListener(13, new Listener(this){
                    final /* synthetic */ 13 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void handleEvent(Event e) {
                        13.access$0(this.this$1, ConciergeEditor.access$7((ConciergeEditor)13.access$1(this.this$1))[1].name, ConciergeEditor.access$7((ConciergeEditor)13.access$1(this.this$1))[1].size, ConciergeEditor.access$7((ConciergeEditor)13.access$1(this.this$1))[1].style, ConciergeEditor.access$7((ConciergeEditor)13.access$1(this.this$1))[1].underline);
                    }
                });
                item = new MenuItem(menu, 8);
                item.setText("Heading 3");
                item.addListener(13, new Listener(this){
                    final /* synthetic */ 13 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void handleEvent(Event e) {
                        13.access$0(this.this$1, ConciergeEditor.access$7((ConciergeEditor)13.access$1(this.this$1))[2].name, ConciergeEditor.access$7((ConciergeEditor)13.access$1(this.this$1))[2].size, ConciergeEditor.access$7((ConciergeEditor)13.access$1(this.this$1))[2].style, ConciergeEditor.access$7((ConciergeEditor)13.access$1(this.this$1))[2].underline);
                    }
                });
                item = new MenuItem(menu, 8);
                item.setText("Normal");
                item.addListener(13, new Listener(this){
                    final /* synthetic */ 13 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void handleEvent(Event e) {
                        13.access$0(this.this$1, "", 0, 0, false);
                    }
                });
                ToolItem ti = (ToolItem)e.widget;
                Point cp = ti.getDisplay().getCursorLocation();
                menu.setLocation(cp.x, cp.y);
                menu.setVisible(true);
                Display display = ConciergeEditor.this.textview.getDisplay();
                while (!menu.isDisposed() && menu.isVisible()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
                menu.dispose();
            }

            static /* synthetic */ void access$0(13 var0, String string, int n, int n2, boolean bl) {
                var0.setHeading(string, n, n2, bl);
            }

            static /* synthetic */ ConciergeEditor access$1(13 var0) {
                return var0.ConciergeEditor.this;
            }
        });
        ti = new ToolItem(tb, 2);
        ti = new ToolItem(tb, 2056);
        ti.setText("fg");
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Point p = ConciergeEditor.this.textview.getSelection();
                if (p.x == p.y) {
                    return;
                }
                ColorDialog cd = new ColorDialog(ConciergeEditor.this.textview.getShell());
                RGB rgb = cd.open();
                if (rgb == null) {
                    return;
                }
                StyleRange newstyle = new StyleRange(0, 0, null, null, -1);
                newstyle.foreground = new Color(null, rgb.red, rgb.green, rgb.blue);
                ConciergeEditor.this.setNewStyleAtRange(p, newstyle, 1);
            }
        });
        ti = new ToolItem(tb, 2056);
        ti.setText("bg");
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Point p = ConciergeEditor.this.textview.getSelection();
                if (p.x == p.y) {
                    return;
                }
                ColorDialog cd = new ColorDialog(ConciergeEditor.this.textview.getShell());
                RGB rgb = cd.open();
                if (rgb == null) {
                    return;
                }
                StyleRange newstyle = new StyleRange(0, 0, null, null, -1);
                newstyle.background = new Color(null, rgb.red, rgb.green, rgb.blue);
                ConciergeEditor.this.setNewStyleAtRange(p, newstyle, 2);
            }
        });
        ti = new ToolItem(tb, 2);
        ti = new ToolItem(tb, 2056);
        ti.setImage(FootprintPlugin.getImageDescriptor("icons/configure.gif").createImage());
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatDialog fd = new FormatDialog(ConciergeEditor.this.textview.getShell(), 0, ConciergeEditor.this.fontparams, ConciergeEditor.this.indparam);
                fd.open();
                String key = "";
                int i = 0;
                while (i < 3) {
                    key = "fontname" + i;
                    ConciergeEditor.this.preference.setValue(key, ((ConciergeEditor)ConciergeEditor.this).fontparams[i].name);
                    key = "fontsize" + i;
                    ConciergeEditor.this.preference.setValue(key, String.valueOf(((ConciergeEditor)ConciergeEditor.this).fontparams[i].size));
                    key = "fontstyle" + i;
                    ConciergeEditor.this.preference.setValue(key, String.valueOf(((ConciergeEditor)ConciergeEditor.this).fontparams[i].style));
                    key = "underline" + i;
                    ConciergeEditor.this.preference.setValue(key, String.valueOf(((ConciergeEditor)ConciergeEditor.this).fontparams[i].underline));
                    ++i;
                }
                ConciergeEditor.this.preference.setValue("indent", String.valueOf(((ConciergeEditor)ConciergeEditor.this).indparam.indent));
            }
        });
        Composite vcmp = new Composite((Composite)this, 2048);
        GridData vcgd = new GridData(1808);
        vcgd.horizontalSpan = 2;
        vcmp.setLayoutData((Object)vcgd);
        GridLayout vcgl = new GridLayout(1, false);
        vcgl.marginWidth = 0;
        vcgl.marginHeight = 0;
        vcmp.setLayout((Layout)vcgl);
        this.textview = new StyledText(vcmp, 768);
        this.textview.setLayoutData((Object)new GridData(1808));
        this.textview.setData(new ArrayList());
        this.textview.setWordWrap(true);
        this.defaultFont = this.textview.getFont();
        this.defaultForeground = this.textview.getForeground();
        this.defaultBackground = this.textview.getBackground();
        this.textview.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode != 0x400000) {
                    int cfr_ignored_0 = e.keyCode;
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.textview.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                int i;
                int start = e.start;
                int replaceCharCount = e.end - e.start;
                int newCharCount = e.text.length();
                if (ConciergeEditor.this.verifyindent) {
                    int sl = ConciergeEditor.this.textview.getLineAtOffset(e.start);
                    int el = ConciergeEditor.this.textview.getLineAtOffset(e.end);
                    i = sl;
                    while (i <= el) {
                        int indent = ConciergeEditor.this.textview.getLineIndent(i);
                        int top = ConciergeEditor.this.textview.getOffsetAtLine(i);
                        int icharlast = top + ConciergeEditor.INDENTCHAR.length() - 1;
                        if (LineUtils.isLineInRange(ConciergeEditor.this.textview, e.start, e.end, i) && e.start <= top && top <= e.end && e.start <= icharlast && icharlast <= e.end) {
                            ConciergeEditor.this.textview.setLineIndent(i, 1, 0);
                        } else if (indent > 0 && (e.start <= top && top <= e.end || e.start <= icharlast && icharlast <= e.end)) {
                            e.doit = false;
                            return;
                        }
                        ++i;
                    }
                } else {
                    ConciergeEditor.this.verifyindent = true;
                }
                ArrayList emimages = (ArrayList)ConciergeEditor.this.textview.getData();
                int cnt = emimages.size();
                i = 0;
                while (i < cnt) {
                    EmbeddedObject ei = (EmbeddedObject)emimages.get(i);
                    int offset = ei.getOffset();
                    if (start <= offset && offset < start + replaceCharCount) {
                        emimages.remove(ei);
                        ei.setOffset(offset - start);
                        ConciergeEditor.this.emclipboard.add(ei);
                        --cnt;
                        --i;
                    } else if (offset >= start) {
                        ei.setOffset(offset += newCharCount - replaceCharCount);
                    }
                    ++i;
                }
            }
        });
        this.textview.addExtendedModifyListener(new ExtendedModifyListener(){

            public void modifyText(ExtendedModifyEvent e) {
                if (e.length == 0) {
                    return;
                }
                int i = 0;
                while (i < ConciergeEditor.this.emclipboard.size()) {
                    EmbeddedObject ei = (EmbeddedObject)ConciergeEditor.this.emclipboard.get(i);
                    int offset = ei.getOffset();
                    if (ConciergeEditor.this.textview.getTextRange(e.start + offset, 1).equals(ConciergeEditor.IMAGECHAR)) {
                        ei.setOffset(e.start + offset);
                        ConciergeEditor.this.addEmbeddedObject(ei, false);
                        ConciergeEditor.this.emclipboard.remove(ei);
                        --i;
                    }
                    ++i;
                }
            }
        });
        this.textview.addPaintObjectListener(new PaintObjectListener(){

            public void paintObject(PaintObjectEvent event) {
                GC gc = event.gc;
                StyleRange style = event.style;
                int start = style.start;
                ArrayList emimages = (ArrayList)ConciergeEditor.this.textview.getData();
                int i = 0;
                while (i < emimages.size()) {
                    EmbeddedObject ei = (EmbeddedObject)emimages.get(i);
                    int offset = ei.getOffset();
                    if (start == offset) {
                        int x = event.x;
                        int y = event.y + event.ascent - style.metrics.ascent;
                        Image img = ei.getObjectImage();
                        Point sz = ei.getSize();
                        if (sz != null) {
                            img = new Image((Device)ConciergeEditor.this.textview.getDisplay(), img.getImageData().scaledTo(sz.x, sz.y));
                            gc.drawImage(img, x, y);
                            img.dispose();
                            break;
                        }
                        gc.drawImage(img, x, y);
                        break;
                    }
                    ++i;
                }
            }
        });
        this.fontparams = new FormatParameter[3];
        String key = "";
        String val = "";
        int i = 0;
        while (i < 3) {
            key = "fontname" + i;
            val = this.preference.getValue(key);
            String fname = val == null || val.length() == 0 ? "Arial" : val;
            key = "fontsize" + i;
            val = this.preference.getValue(key);
            int fsize = val == null || val.length() == 0 ? 16 - i * 2 : Integer.parseInt(val);
            key = "fontstyle" + i;
            val = this.preference.getValue(key);
            int fstyle = val == null || val.length() == 0 ? 0 : Integer.parseInt(val);
            key = "underline" + i;
            val = this.preference.getValue(key);
            boolean funderline = val == null || val.length() == 0 ? false : Boolean.parseBoolean(val);
            this.fontparams[i] = new FormatParameter(fname, fsize, fstyle, funderline);
            ++i;
        }
        val = this.preference.getValue("indent");
        int indent = val == null || val.length() == 0 ? 4 : Integer.parseInt(val);
        this.indparam = new IndentParameter(indent);
        DropTarget target = new DropTarget((Control)this.textview, 17);
        DataDomTransfer transfer = DataDomTransfer.getInstance();
        Transfer[] types = new Transfer[]{transfer, FileTransfer.getInstance()};
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)new ConciergeEditorDropListener(this));
        this.hookContextMenu();
    }

    private EmbeddedObject createEmbededObject(String file, int offset) {
        EmbeddedFile e = new EmbeddedFile();
        ((EmbeddedObject)e).setFileName(file);
        e.setOffset(offset);
        ((EmbeddedObject)e).setOrgName(file);
        Document doc = FootprintPlugin.createMiscFileDocument(file);
        if (doc != null) {
            e.setDocument(doc);
        }
        e.setUpdate(true);
        return e;
    }

    private EmbeddedObject createEmbeddedObject(Document doc, int offset) {
        EmbeddedObject e;
        if (DataDomImpl.getType((Document)doc).equals("Misc")) {
            e = new EmbeddedFile();
            String path = FrameworkPlugin.getPathFromID((long)DomImpl.getID((Document)doc));
            e.setFileName(path);
        } else {
            e = new EmbeddedDocument();
            e.setFileName(null);
        }
        e.setOffset(offset);
        e.setOrgName(null);
        e.setDocument(doc);
        e.setUpdate(true);
        return e;
    }

    private void addEmbeddedObject(EmbeddedObject em, boolean marker) {
        Image img = em.getObjectImage();
        if (marker) {
            this.textview.replaceTextRange(em.getOffset(), 0, IMAGECHAR);
        }
        StyleRange style = new StyleRange();
        style.start = em.getOffset();
        style.length = 1;
        Rectangle rect = img.getBounds();
        if (rect.width > 240) {
            double ratio = 240.0 / (double)rect.width;
            rect.width = (int)((double)rect.width * ratio);
            rect.height = (int)((double)rect.height * ratio);
            em.setSize(new Point(rect.width, rect.height));
        }
        style.metrics = new GlyphMetrics(rect.height, 0, rect.width);
        this.textview.setStyleRange(style);
        ArrayList emimages = (ArrayList)this.textview.getData();
        emimages.add(em);
    }

    public void addEmbeddedObject(String file, int offset, boolean marker) {
        this.addEmbeddedObject(this.createEmbededObject(file, offset), marker);
    }

    public void addEmbeddedObject(String file) {
        this.addEmbeddedObject(file, this.textview.getCaretOffset(), true);
    }

    public void addEmbeddedObject(Document doc) {
        this.addEmbeddedObject(this.createEmbeddedObject(doc, this.textview.getCaretOffset()), true);
    }

    public void setDocument(Document doc) {
        this.reset();
        HTMLConverter htconv = new HTMLConverter(this.textview);
        htconv.importFromDocument(doc);
    }

    public Document getDocument() {
        HTMLConverter htconv = new HTMLConverter(this.textview);
        return htconv.exportToDocument();
    }

    public StyledText getTextWidget() {
        return this.textview;
    }

    public void reset() {
        int cnt = this.textview.getCharCount();
        this.textview.replaceStyleRanges(0, cnt, new StyleRange[]{new StyleRange()});
        this.textview.replaceTextRange(0, cnt, "");
        this.textview.setFont(this.defaultFont);
        this.textview.setForeground(this.defaultForeground);
        this.textview.setBackground(this.defaultBackground);
    }

    public ArrayList getEmbeddedObject() {
        return (ArrayList)this.textview.getData();
    }

    public void exportToHtml() {
        String[] ext = new String[]{"html", "htm"};
        FileDialog fd = new FileDialog(this.textview.getShell(), 8192);
        fd.setFilterExtensions(ext);
        String path = fd.open();
        if (path == null) {
            return;
        }
        String ex = FilenameUtils.getExtension((String)path);
        if (ex.compareTo("html") != 0 && ex.compareTo("htm") != 0) {
            path = String.valueOf(path) + ".html";
        }
        HTMLConverter hexp = new HTMLConverter(this.textview);
        hexp.exportToFile(path);
    }

    protected void finalize() throws Throwable {
        this.linkcolor.dispose();
        super.finalize();
    }
}

