/*
 * Decompiled with CFR 0.152.
 */
package org.xmldb.api.tests;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.BinaryResource;
import org.xmldb.api.modules.XMLResource;
import org.xmldb.api.modules.XPathQueryService;
import org.xmldb.api.tests.XMLDBTestCase;

public class CollectionTest
extends XMLDBTestCase {
    static /* synthetic */ Class class$org$xmldb$api$tests$CollectionTest;

    public CollectionTest(String string) {
        super(string);
    }

    public static Test suite() {
        return new TestSuite(class$org$xmldb$api$tests$CollectionTest == null ? (class$org$xmldb$api$tests$CollectionTest = CollectionTest.class$("org.xmldb.api.tests.CollectionTest")) : class$org$xmldb$api$tests$CollectionTest);
    }

    public void testGetName() {
        try {
            Assert.assertTrue((boolean)this.col.getName().equals("child1"));
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getMessage());
        }
    }

    public void testGetParentCollection() {
        try {
            if (this.supportsNested) {
                Collection collection = this.col.getChildCollection("subchild1");
                Collection collection2 = collection.getParentCollection();
                Assert.assertTrue((boolean)collection2.getName().equals("child1"));
                Assert.assertTrue((collection2.getParentCollection().getParentCollection() == null ? 1 : 0) != 0);
            }
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getMessage());
        }
    }

    public void testGetChildCollectionCount() {
        try {
            if (this.supportsNested) {
                Assert.assertTrue((this.col.getChildCollectionCount() == 2 ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((this.col.getChildCollectionCount() == 0 ? 1 : 0) != 0);
            }
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getMessage());
        }
    }

    public void testListChildCollections() {
        try {
            String[] stringArray = this.col.listChildCollections();
            if (this.supportsNested) {
                boolean bl = false;
                boolean bl2 = false;
                int n = 0;
                while (n < stringArray.length) {
                    String string = stringArray[n];
                    if (string.equals("subchild1")) {
                        bl = true;
                    }
                    if (string.equals("subchild2")) {
                        bl2 = true;
                    }
                    ++n;
                }
                Assert.assertTrue((bl && bl2 ? 1 : 0) != 0);
                try {
                    Assert.assertTrue((stringArray[2] == null ? 1 : 0) != 0);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            } else {
                Assert.assertTrue((stringArray.length == 0 ? 1 : 0) != 0);
            }
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getMessage());
        }
    }

    public void testGetChildCollection() {
        try {
            if (this.supportsNested) {
                Collection collection = this.col.getChildCollection("subchild1");
                Assert.assertTrue((boolean)collection.getName().equals("subchild1"));
            } else {
                Assert.assertTrue((this.col.getChildCollection("subchild1") == null ? 1 : 0) != 0);
            }
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getMessage());
        }
    }

    public void testGetResourceCount() {
        try {
            if (this.supportsBinary) {
                Assert.assertTrue((this.col.getResourceCount() == 4 ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((this.col.getResourceCount() == 3 ? 1 : 0) != 0);
            }
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getMessage());
        }
    }

    public void testListResources() {
        try {
            String[] stringArray = this.col.listResources();
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                if (string.equals("test1.xml")) {
                    bl = true;
                }
                if (string.equals("test2.xml")) {
                    bl2 = true;
                }
                if (string.equals("test3.xml")) {
                    bl3 = true;
                }
                ++n;
            }
            Assert.assertTrue((bl && bl2 && bl3 ? 1 : 0) != 0);
            try {
                Assert.assertTrue((stringArray[4] == null ? 1 : 0) != 0);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getMessage());
        }
    }

    public void testCreateResource() {
        try {
            BinaryResource binaryResource;
            XMLResource xMLResource = (XMLResource)this.col.createResource("test4.xml", "XMLResource");
            Assert.assertTrue((boolean)xMLResource.getResourceType().equals("XMLResource"));
            Assert.assertTrue((boolean)xMLResource.getId().equals("test4.xml"));
            if (this.supportsBinary) {
                binaryResource = (BinaryResource)this.col.createResource("", "BinaryResource");
                Assert.assertTrue((boolean)binaryResource.getResourceType().equals("BinaryResource"));
                Assert.assertTrue((!binaryResource.getId().equals("") ? 1 : 0) != 0);
            }
            try {
                binaryResource = this.col.createResource("", "GoogleResource");
                Assert.assertTrue((boolean)false);
            }
            catch (XMLDBException xMLDBException) {
                Assert.assertTrue((xMLDBException.errorCode == 302 ? 1 : 0) != 0);
            }
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getMessage());
        }
    }

    public void testStoreResource() {
        String string = "<?xml version=\"1.0\"?><tag1><tag2>value</tag2></tag1>";
        try {
            XMLResource xMLResource = (XMLResource)this.col.createResource("", "XMLResource");
            xMLResource.setContent((Object)string);
            this.col.storeResource((Resource)xMLResource);
            XMLResource xMLResource2 = (XMLResource)this.col.getResource(xMLResource.getId());
            Assert.assertTrue((xMLResource2 != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)xMLResource2.getId().equals(xMLResource.getId()));
            Assert.assertTrue((xMLResource2.getContent() != null ? 1 : 0) != 0);
            this.col.removeResource((Resource)xMLResource);
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getMessage());
        }
    }

    public void testRemoveResource() {
        String string = "<?xml version=\"1.0\"?><tag1><tag2>value</tag2></tag1>";
        try {
            XMLResource xMLResource = (XMLResource)this.col.createResource("", "XMLResource");
            xMLResource.setContent((Object)string);
            this.col.storeResource((Resource)xMLResource);
            XMLResource xMLResource2 = (XMLResource)this.col.getResource(xMLResource.getId());
            Assert.assertTrue((xMLResource2 != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)xMLResource2.getId().equals(xMLResource.getId()));
            Assert.assertTrue((xMLResource2.getContent() != null ? 1 : 0) != 0);
            this.col.removeResource((Resource)xMLResource2);
            Resource resource = this.col.getResource(xMLResource.getId());
            Assert.assertTrue((resource == null ? 1 : 0) != 0);
            try {
                this.col.removeResource((Resource)xMLResource);
            }
            catch (XMLDBException xMLDBException) {
                Assert.assertTrue((xMLDBException.errorCode == 300 ? 1 : 0) != 0);
            }
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getMessage());
        }
    }

    public void testGetResource() {
        try {
            Resource resource = this.col.getResource("test1.xml");
            Assert.assertTrue((resource != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)resource.getResourceType().equals("XMLResource"));
            Assert.assertTrue((resource.getContent() != null ? 1 : 0) != 0);
            if (this.supportsBinary) {
                resource = this.col.getResource("image.gif");
                Assert.assertTrue((resource != null ? 1 : 0) != 0);
                Assert.assertTrue((boolean)resource.getResourceType().equals("BinaryResource"));
                Assert.assertTrue((resource.getContent() != null ? 1 : 0) != 0);
            }
            Assert.assertTrue(((resource = this.col.getResource("missing.xml")) == null ? 1 : 0) != 0);
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getMessage());
        }
    }

    public void testXPathQueryService() {
        try {
            if (this.supportsXPath) {
                XPathQueryService xPathQueryService = (XPathQueryService)this.col.getService("XPathQueryService", "1.0");
                Assert.assertTrue((xPathQueryService != null ? 1 : 0) != 0);
                ResourceSet resourceSet = xPathQueryService.query("/data");
                ResourceIterator resourceIterator = resourceSet.getIterator();
                int n = 0;
                while (resourceIterator.hasMoreResources()) {
                    resourceIterator.nextResource();
                    ++n;
                }
                Assert.assertTrue((n == 3 ? 1 : 0) != 0);
                resourceSet = xPathQueryService.query("/data/child/subchild[@name='subchild1']");
                resourceIterator = resourceSet.getIterator();
                n = 0;
                while (resourceIterator.hasMoreResources()) {
                    resourceIterator.nextResource();
                    ++n;
                }
                Assert.assertTrue((n == 6 ? 1 : 0) != 0);
                resourceSet = xPathQueryService.query("/data/child/subchild/subsubchild[@name='subsubchild1']");
                resourceIterator = resourceSet.getIterator();
                n = 0;
                while (resourceIterator.hasMoreResources()) {
                    resourceIterator.nextResource();
                    ++n;
                }
                Assert.assertTrue((n == 1 ? 1 : 0) != 0);
            }
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getMessage());
        }
    }

    public void testStub() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

