/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.xml.dom;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.core.data.Value;
import org.apache.xindice.util.ObjectStack;
import org.apache.xindice.util.XindiceException;
import org.apache.xindice.xml.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public final class DOMParser
extends DefaultHandler
implements DeclHandler,
LexicalHandler,
Serializable {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xindice$xml$dom$DOMParser == null ? (class$org$apache$xindice$xml$dom$DOMParser = DOMParser.class$("org.apache.xindice.xml.dom.DOMParser")) : class$org$apache$xindice$xml$dom$DOMParser));
    private static final SAXParserFactory factory = SAXParserFactory.newInstance();
    private SAXParser sp;
    private ErrorHandler errors = null;
    private EntityResolver entities = null;
    private Document doc;
    private Node context;
    private int state = -1;
    private StringBuffer buf;
    private final ObjectStack states = new ObjectStack();
    static /* synthetic */ Class class$org$apache$xindice$xml$dom$DOMParser;

    public DOMParser() throws XindiceException {
        try {
            this.sp = this.getSAXParser();
        }
        catch (Exception e) {
            log.warn((Object)"Failed to create SAXParser", (Throwable)e);
            throw new XindiceException("Error creating parser", e);
        }
    }

    public void setErrorHandler(ErrorHandler errors) throws SAXException {
        this.errors = errors;
        if (this.sp != null) {
            XMLReader xr = this.sp.getXMLReader();
            xr.setErrorHandler(errors);
        }
    }

    public void setEntityResolver(EntityResolver entities) throws SAXException {
        this.entities = entities;
        if (this.sp != null) {
            XMLReader xr = this.sp.getXMLReader();
            xr.setEntityResolver(entities);
        }
    }

    public void parse(String xml) throws SAXException, IOException {
        this.parse(new StringReader(xml));
    }

    public void parse(Reader input) throws SAXException, IOException {
        this.parse(new InputSource(input));
    }

    public void parse(byte[] xml) throws SAXException, IOException {
        this.parse(new ByteArrayInputStream(xml));
    }

    public void parse(Value value) throws SAXException, IOException {
        this.parse(value.getData());
    }

    public void parse(InputSource source) throws SAXException, IOException {
        this.sp.parse(source, (DefaultHandler)this);
    }

    public void parse(InputStream input) throws SAXException, IOException {
        this.sp.parse(input, (DefaultHandler)this);
    }

    public static Document toDocument(Reader input) throws XindiceException {
        try {
            DOMParser dp = new DOMParser();
            dp.parse(input);
            return dp.getDocument();
        }
        catch (Exception e) {
            throw new XindiceException("Error parsing Document", e);
        }
    }

    public static Document toDocument(byte[] xml) throws XindiceException {
        try {
            DOMParser dp = new DOMParser();
            dp.parse(xml);
            return dp.getDocument();
        }
        catch (Exception e) {
            throw new XindiceException("Error parsing Document", e);
        }
    }

    public static Document toDocument(Value value) throws XindiceException {
        try {
            DOMParser dp = new DOMParser();
            dp.parse(value);
            return dp.getDocument();
        }
        catch (Exception e) {
            throw new XindiceException("Error parsing Document", e);
        }
    }

    public static Document toDocument(InputSource source) throws XindiceException {
        try {
            DOMParser dp = new DOMParser();
            dp.parse(source);
            return dp.getDocument();
        }
        catch (Exception e) {
            throw new XindiceException("Error parsing Document", e);
        }
    }

    public static Document toDocument(InputStream input) throws XindiceException {
        try {
            DOMParser dp = new DOMParser();
            dp.parse(input);
            return dp.getDocument();
        }
        catch (Exception e) {
            throw new XindiceException("Error parsing Document", e);
        }
    }

    public static Document toDocument(String xml) throws XindiceException {
        try {
            DOMParser dp = new DOMParser();
            dp.parse(xml);
            return dp.getDocument();
        }
        catch (Exception e) {
            throw new XindiceException("Error parsing Document", e);
        }
    }

    public Document getDocument() {
        return this.doc;
    }

    private SAXParser getSAXParser() throws Exception {
        SAXParser sp = factory.newSAXParser();
        XMLReader xr = sp.getXMLReader();
        xr.setFeature("http://xml.org/sax/features/namespaces", true);
        xr.setFeature("http://xml.org/sax/features/validation", false);
        xr.setFeature("http://xml.org/sax/features/external-general-entities", false);
        xr.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        xr.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        xr.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        xr.setProperty("http://xml.org/sax/properties/declaration-handler", this);
        if (this.errors != null) {
            xr.setErrorHandler(this.errors);
        }
        if (this.entities != null) {
            xr.setEntityResolver(this.entities);
        }
        return sp;
    }

    private void pushState(int newState) {
        Integer i = new Integer(this.state);
        this.states.push(i);
        this.state = newState;
    }

    private void popState() {
        Integer i = (Integer)this.states.pop();
        this.state = i != null ? i : -1;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        return null;
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
        this.doc = new DocumentImpl();
        this.context = this.doc;
        this.pushState(9);
    }

    public void endDocument() throws SAXException {
        this.context = null;
        this.popState();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Element e = uri != null && uri.length() > 0 ? this.doc.createElementNS(uri, qName) : this.doc.createElement(localName);
        for (int i = 0; i < attributes.getLength(); ++i) {
            boolean isNsDef;
            String attrURI = attributes.getURI(i);
            String attrQName = attributes.getQName(i);
            String attrValue = attributes.getValue(i);
            boolean bl = isNsDef = attrQName != null && attrQName.startsWith("xmlns") && (attrQName.length() == 5 || attrQName.charAt(5) == ':');
            if (isNsDef || attrURI != null && attrURI.length() > 0) {
                e.setAttributeNS(attrURI, attrQName, attrValue);
                continue;
            }
            e.setAttribute(attributes.getLocalName(i), attrValue);
        }
        this.context.appendChild(e);
        this.pushState(1);
        this.context = e;
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.context = this.context.getParentNode();
        this.popState();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        switch (this.state) {
            case 4: {
                this.buf.append(ch, start, length);
                break;
            }
            default: {
                String s = new String(ch, start, length);
                this.context.appendChild(this.doc.createTextNode(s));
            }
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        switch (this.state) {
            case 4: {
                this.buf.append(ch, start, length);
                break;
            }
            default: {
                String s = new String(ch, start, length);
                this.context.appendChild(this.doc.createTextNode(s));
            }
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.context.appendChild(this.doc.createProcessingInstruction(target, data));
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void warning(SAXParseException e) throws SAXException {
        log.info((Object)"Parsing warning (ignored)", (Throwable)e);
    }

    public void error(SAXParseException e) throws SAXException {
        log.info((Object)"Parsing error (ignored)", (Throwable)e);
    }

    public void fatalError(SAXParseException e) throws SAXException {
        log.warn((Object)"Parsing fatal error", (Throwable)e);
        throw e;
    }

    public void elementDecl(String name, String model) throws SAXException {
    }

    public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) throws SAXException {
    }

    public void internalEntityDecl(String name, String value) throws SAXException {
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        this.pushState(4);
        this.buf = new StringBuffer();
    }

    public void endCDATA() throws SAXException {
        this.context.appendChild(this.doc.createCDATASection(this.buf.toString()));
        this.buf = null;
        this.popState();
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        String s = new String(ch, start, length);
        this.context.appendChild(this.doc.createComment(s));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

