/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.xml.dom;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.util.ByteArrayInput;
import org.apache.xindice.xml.SymbolTable;
import org.apache.xindice.xml.XMLCompressedInput;
import org.apache.xindice.xml.dom.DocumentImpl;
import org.apache.xindice.xml.dom.NodeImpl;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;

public abstract class CharacterDataImpl
extends NodeImpl
implements CharacterData,
Serializable {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xindice$xml$dom$CharacterDataImpl == null ? (class$org$apache$xindice$xml$dom$CharacterDataImpl = CharacterDataImpl.class$("org.apache.xindice.xml.dom.CharacterDataImpl")) : class$org$apache$xindice$xml$dom$CharacterDataImpl));
    static /* synthetic */ Class class$org$apache$xindice$xml$dom$CharacterDataImpl;

    public CharacterDataImpl() {
    }

    public CharacterDataImpl(NodeImpl parentNode, byte[] data, int pos, int len) {
        super(parentNode, data, pos, len);
    }

    public CharacterDataImpl(NodeImpl parentNode, boolean dirty) {
        super(parentNode, dirty);
    }

    public CharacterDataImpl(NodeImpl parentNode, String nodeValue) {
        super(parentNode, true);
        if (nodeValue == null) {
            nodeValue = "";
        }
        this.nodeValue = nodeValue;
    }

    protected final void checkLoaded() {
        block6: {
            if (this.loaded) {
                return;
            }
            this.loaded = true;
            try {
                if (this.data != null) {
                    DocumentImpl doc = (DocumentImpl)this.getOwnerDocument();
                    SymbolTable st = doc.getSymbols();
                    ByteArrayInput bis = new ByteArrayInput(this.data, this.pos, this.len);
                    XMLCompressedInput xci = new XMLCompressedInput(bis, st);
                    xci.readSignature();
                    if (this.getNodeType() == 3) {
                        xci.readContentSize();
                    } else {
                        xci.readInt();
                    }
                    byte[] buf = new byte[bis.available()];
                    xci.read(buf);
                    this.nodeValue = new String(buf, "UTF-8");
                }
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block6;
                log.warn((Object)"ignored exception", (Throwable)e);
            }
        }
    }

    public final void setNodeValue(String nodeValue) throws DOMException {
        this.checkLoaded();
        this.checkReadOnly();
        if (nodeValue == null) {
            nodeValue = "";
        }
        this.nodeValue = nodeValue;
        this.setDirty();
    }

    public final String substringData(int offset, int count) throws DOMException {
        try {
            return this.nodeValue.substring(offset, offset + count);
        }
        catch (Exception e) {
            throw EX_INDEX_SIZE;
        }
    }

    public final String getData() throws DOMException {
        return this.getNodeValue();
    }

    public final void setData(String data) throws DOMException {
        this.setNodeValue(data);
    }

    public final void insertData(int offset, String arg) throws DOMException {
        String value = this.getNodeValue();
        this.checkReadOnly();
        try {
            this.setNodeValue(value.substring(0, offset) + arg + value.substring(offset + 1));
        }
        catch (Exception e) {
            throw EX_INDEX_SIZE;
        }
    }

    public final int getLength() {
        return this.getNodeValue().length();
    }

    public final void replaceData(int offset, int count, String arg) throws DOMException {
        String value = this.getNodeValue();
        this.checkReadOnly();
        try {
            this.setNodeValue(value.substring(0, offset) + arg + value.substring(offset + count));
        }
        catch (Exception e) {
            throw EX_INDEX_SIZE;
        }
    }

    public final void appendData(String arg) throws DOMException {
        String value = this.getNodeValue();
        this.checkReadOnly();
        this.setNodeValue(value + arg);
    }

    public final void deleteData(int offset, int count) throws DOMException {
        String value = this.getNodeValue();
        this.checkReadOnly();
        try {
            this.setNodeValue(value.substring(0, offset) + value.substring(offset + count));
        }
        catch (Exception e) {
            throw EX_INDEX_SIZE;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

