/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;

public class FileCache {
    private final Map cache = new WeakHashMap();

    public final boolean isInCache(File file) {
        return this.cache.get(file) != null;
    }

    public final boolean isInCache(String name) {
        return this.cache.get(new File(name)) != null;
    }

    public final boolean isModified(String name) {
        return this.isModified(new File(name));
    }

    public final boolean isModified(File file) {
        FileCacheInfo finfo = (FileCacheInfo)this.cache.get(file);
        return !file.exists() || finfo == null || file.lastModified() != finfo.lastModified;
    }

    public final byte[] getFile(String name) throws IOException {
        return this.getFile(new File(name));
    }

    public final byte[] getFile(File file) throws IOException {
        if (!file.exists()) {
            return null;
        }
        FileCacheInfo finfo = (FileCacheInfo)this.cache.get(file);
        long lastmod = file.lastModified();
        if (finfo == null || finfo.lastModified != lastmod) {
            FileInputStream fis = new FileInputStream(file);
            byte[] content = new byte[fis.available()];
            fis.read(content);
            fis.close();
            finfo = new FileCacheInfo(file, lastmod, content);
            this.cache.put(file, finfo);
            return content;
        }
        return finfo.content;
    }

    private class FileCacheInfo {
        public File file;
        public long lastModified = 0L;
        public byte[] content;

        public FileCacheInfo(File file, long lastModified, byte[] content) {
            this.file = file;
            this.lastModified = lastModified;
            this.content = content;
        }
    }
}

