/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.core.data;

import org.apache.xindice.xml.TextWriter;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class Variant {
    private Object value = null;
    private int type = -1;

    public Variant() {
    }

    public Variant(Variant value) {
        this.value = value.value;
        this.type = value.type;
    }

    public Variant(String value) {
        this.value = value;
        this.type = 11;
    }

    public Variant(boolean value) {
        this.value = new Boolean(value);
        this.type = 1;
    }

    public Variant(byte value) {
        this.value = new Byte(value);
        this.type = 2;
    }

    public Variant(char value) {
        this.value = new Character(value);
        this.type = 3;
    }

    public Variant(short value) {
        this.value = new Short(value);
        this.type = 4;
    }

    public Variant(int value) {
        this.value = new Integer(value);
        this.type = 5;
    }

    public Variant(long value) {
        this.value = new Long(value);
        this.type = 6;
    }

    public Variant(float value) {
        this.value = new Float(value);
        this.type = 7;
    }

    public Variant(double value) {
        this.value = new Double(value);
        this.type = 8;
    }

    public Variant(Element value) {
        this.value = value;
        this.type = 12;
    }

    public Variant(Document value) {
        this.value = value;
        this.type = 13;
    }

    public Variant(DocumentFragment value) {
        this.value = value;
        this.type = 14;
    }

    public Variant(Object value) {
        this.value = value;
        this.type = 10;
    }

    public int getType() {
        return this.type;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public void set(String value) {
        this.value = value;
        this.type = 11;
    }

    public void set(boolean value) {
        this.value = new Boolean(value);
        this.type = 1;
    }

    public void set(byte value) {
        this.value = new Byte(value);
        this.type = 2;
    }

    public void set(char value) {
        this.value = new Character(value);
        this.type = 3;
    }

    public void set(short value) {
        this.value = new Short(value);
        this.type = 4;
    }

    public void set(int value) {
        this.value = new Integer(value);
        this.type = 5;
    }

    public void set(long value) {
        this.value = new Long(value);
        this.type = 6;
    }

    public void set(float value) {
        this.value = new Float(value);
        this.type = 7;
    }

    public void set(double value) {
        this.value = new Double(value);
        this.type = 8;
    }

    public void set(Element value) {
        this.value = value;
        this.type = 12;
    }

    public void set(Document value) {
        this.value = value;
        this.type = 13;
    }

    public void set(DocumentFragment value) {
        this.value = value;
        this.type = 14;
    }

    public void set(Object value) {
        this.value = value;
        this.type = this.value != null ? 10 : -1;
    }

    public String getString() {
        if (this.type == 11) {
            return (String)this.value;
        }
        return this.value.toString();
    }

    public boolean getBoolean() {
        if (this.type == 1) {
            return (Boolean)this.value;
        }
        return "[true][yes][1][y][on]".indexOf("[" + this.value.toString().toLowerCase() + "]") != -1;
    }

    public byte getByte() {
        if (this.type == 2) {
            return (Byte)this.value;
        }
        return Byte.parseByte(this.value.toString());
    }

    public char getChar() {
        if (this.type == 3) {
            return ((Character)this.value).charValue();
        }
        return this.value.toString().charAt(0);
    }

    public short getShort() {
        if (this.type == 4) {
            return (Short)this.value;
        }
        return Short.parseShort(this.value.toString());
    }

    public int getInt() {
        if (this.type == 5) {
            return (Integer)this.value;
        }
        return Integer.parseInt(this.value.toString());
    }

    public long getLong() {
        if (this.type == 6) {
            return (Long)this.value;
        }
        return Long.parseLong(this.value.toString());
    }

    public float getFloat() {
        if (this.type == 7) {
            return ((Float)this.value).floatValue();
        }
        return Float.parseFloat(this.value.toString());
    }

    public double getDouble() {
        if (this.type == 8) {
            return (Double)this.value;
        }
        return Double.parseDouble(this.value.toString());
    }

    public Element getElement() {
        if (this.type == 12) {
            return (Element)this.value;
        }
        return null;
    }

    public Document getDocument() {
        if (this.type == 13) {
            return (Document)this.value;
        }
        return null;
    }

    public DocumentFragment getDocumentFragment() {
        if (this.type == 14) {
            return (DocumentFragment)this.value;
        }
        return null;
    }

    public Object getObject() {
        return this.value;
    }

    public String toString() {
        switch (this.type) {
            case 12: 
            case 13: 
            case 14: {
                return TextWriter.toString((Node)this.value);
            }
        }
        return this.value.toString();
    }
}

