#!/bin/tcsh

echo "Thank you for downloading BayesianBand ver.0.10."
echo "This program uses Apache Xerces, Xalan and Commons Math, distributed "
echo "under Apache License 2.0."
echo "For details, read separate text files."
echo ""

set java = `which java`
set java_home = `dirname $java`/../
if ( -e $java_home/jre/lib/ext/ ) then
  set lib_dir = $java_home/jre/lib/ext/
else if ( -e $java_home/lib/ext/) then
  set lib_dir = $java_home/lib/ext/
else
  echo [ERROR] No Java JRE or JDK found.
  exit 1
endif

echo "Now I'll be starting to install the libraries. "
echo "The following files are copying to ${lib_dir}."
echo ./lib/*.jar
echo "In general, it is not necessary to copy these files "
echo "if the same files have already been copied."
echo "Be carefully if you overwrite existing files."
echo "It may unable other software to run."

cp -i ./lib/*.jar $lib_dir

echo "Finished."

