/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.misc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import jp.crestmuse.cmx.misc.QueueReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueWrapper<E> {
    private Queue<E> queue;
    private ArrayList<PacketWithReadCount> list;
    private byte nReaders = 0;
    int removedNum;

    public QueueWrapper(Queue<E> queue) {
        this.queue = queue;
        this.list = new ArrayList();
        this.removedNum = 0;
    }

    @Deprecated
    public QueueWrapper(Queue<E> queue, int n) {
        this.queue = queue;
        this.list = new ArrayList();
        this.removedNum = 0;
    }

    public QueueReader<E> createReader() {
        this.nReaders = (byte)(this.nReaders + 1);
        return new QueueReaderImpl();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueueReaderImpl
    implements QueueReader<E> {
        private int next = 0;

        private QueueReaderImpl() {
        }

        @Override
        public E take() throws InterruptedException {
            PacketWithReadCount packetWithReadCount;
            if (this.next < QueueWrapper.this.list.size() + QueueWrapper.this.removedNum) {
                packetWithReadCount = (PacketWithReadCount)QueueWrapper.this.list.get(this.next - QueueWrapper.this.removedNum);
            } else {
                Object e = QueueWrapper.this.queue instanceof BlockingQueue ? ((BlockingQueue)QueueWrapper.this.queue).take() : QueueWrapper.this.queue.poll();
                packetWithReadCount = new PacketWithReadCount(e);
                QueueWrapper.this.list.add(packetWithReadCount);
            }
            ++packetWithReadCount.readedCount;
            if (packetWithReadCount.readedCount >= QueueWrapper.this.nReaders) {
                QueueWrapper.this.list.remove(0);
                ++QueueWrapper.this.removedNum;
            }
            ++this.next;
            return packetWithReadCount.packet;
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){

                @Override
                public boolean hasNext() {
                    return QueueReaderImpl.this.next < QueueWrapper.this.list.size() + QueueWrapper.this.removedNum;
                }

                @Override
                public E next() {
                    try {
                        return QueueReaderImpl.this.take();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new RuntimeException();
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PacketWithReadCount {
        E packet;
        int readedCount;

        public PacketWithReadCount(E e) {
            this.packet = e;
            this.readedCount = 0;
        }
    }
}

