/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.filewrappers;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.filewrappers.DeviationInstanceWrapper;
import jp.crestmuse.cmx.filewrappers.InvalidFileTypeException;
import jp.crestmuse.cmx.filewrappers.MIDIXMLWrapper;
import jp.crestmuse.cmx.filewrappers.MusicXMLWrapper;
import jp.crestmuse.cmx.filewrappers.NodeInterface;
import jp.crestmuse.cmx.handlers.CommonNoteHandler;
import jp.crestmuse.cmx.handlers.SCCHandler;
import jp.crestmuse.cmx.handlers.SCCHandlerAdapter;
import jp.crestmuse.cmx.misc.MIDIEventList;
import jp.crestmuse.cmx.misc.MutableNote;
import jp.crestmuse.cmx.misc.NoteCompatible;
import jp.crestmuse.cmx.misc.PianoRollCompatible;
import jp.crestmuse.cmx.misc.SimpleNoteList;
import jp.crestmuse.cmx.misc.XMLException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCCXMLWrapper
extends CMXFileWrapper
implements PianoRollCompatible {
    public static final String TOP_TAG = "scc";
    private int division = 0;
    private Part[] partlist = null;
    private HeaderElement[] headlist = null;
    private Annotation[] chords = null;
    private Annotation[] barlines = null;
    private boolean headerStarted = false;
    private boolean partStarted = false;
    private boolean annotationsStarted = false;
    private Map<NumberedNote, MusicXMLWrapper.Note> notemap = new HashMap<NumberedNote, MusicXMLWrapper.Note>();
    private Map<NumberedNote, Byte> nEqualNotes = new HashMap<NumberedNote, Byte>();
    private Map<MutableNote, Note> notemap2 = new HashMap<MutableNote, Note>();
    private int currentPart = 0;

    @Override
    protected void analyze() {
        try {
            final HeaderElement[] headerElementArray = this.getHeaderElementList();
            final int n = this.getDivision();
            this.processNotes(new SCCHandlerAdapter(){
                private double currentInSec;
                private int lastTempoChangeInTick;
                private double lastTempoChangeInSec;
                private double currentTempo;
                private int nextTempoChangeInTick;
                private double nextTempoChangeInSec;
                private double nextTempo;
                private int nextHeader;

                public void beginPart(Part part, SCCXMLWrapper sCCXMLWrapper) {
                    this.currentInSec = 0.0;
                    this.lastTempoChangeInTick = 0;
                    this.lastTempoChangeInSec = 0.0;
                    this.currentTempo = 120.0;
                    this.nextTempoChangeInTick = -1;
                    this.nextHeader = 0;
                    this.searchNextTempo();
                }

                public void processNote(Note note, SCCXMLWrapper sCCXMLWrapper) {
                    if (this.nextTempoChangeInTick >= 0 && this.nextTempoChangeInTick < note.onset()) {
                        this.lastTempoChangeInTick = this.nextTempoChangeInTick;
                        this.lastTempoChangeInSec = this.nextTempoChangeInSec;
                        this.currentTempo = this.nextTempo;
                        this.searchNextTempo();
                    }
                    note.onsetInMSec = (int)(1000.0 * this.calcSec(note.onset()));
                    if (this.nextTempoChangeInTick >= 0 && this.nextTempoChangeInTick < note.offset()) {
                        this.lastTempoChangeInTick = this.nextTempoChangeInTick;
                        this.lastTempoChangeInSec = this.nextTempoChangeInSec;
                        this.currentTempo = this.nextTempo;
                        this.searchNextTempo();
                    }
                    note.offsetInMSec = (int)(1000.0 * this.calcSec(note.offset()));
                }

                private void searchNextTempo() {
                    int n2;
                    for (n2 = this.nextHeader; n2 < headerElementArray.length; ++n2) {
                        if (!headerElementArray[n2].name().equals("TEMPO")) continue;
                        this.nextTempoChangeInTick = headerElementArray[n2].time();
                        this.nextTempoChangeInSec = this.calcSec(this.nextTempoChangeInTick);
                        this.nextTempo = Double.parseDouble(headerElementArray[n2].content());
                        break;
                    }
                    this.nextHeader = n2 + 1;
                }

                private double calcSec(int n2) {
                    return (double)((n2 - this.lastTempoChangeInTick) * 60) / ((double)n * this.currentTempo) + this.lastTempoChangeInSec;
                }
            });
        }
        catch (TransformerException transformerException) {
            throw new XMLException(transformerException);
        }
    }

    public int getDivision() {
        if (this.division == 0) {
            this.division = NodeInterface.getAttributeInt(this.getDocument().getDocumentElement(), "division");
        }
        return this.division;
    }

    public void setDivision(int n) {
        this.getDocument().getDocumentElement().setAttribute("division", String.valueOf(n));
        this.division = n;
    }

    public void beginHeader() {
        this.checkElementAddition(!this.headerStarted);
        this.addChild("header");
        this.headerStarted = true;
    }

    public void addHeaderElement(int n, String string, String string2) {
        this.checkElementAddition(this.headerStarted);
        this.addChild("meta");
        this.setAttribute("name", string);
        this.setAttribute("content", string2);
        this.setAttribute("time", n);
        this.returnToParent();
    }

    public void addHeaderElement(int n, String string, double d) {
        this.addHeaderElement(n, string, String.valueOf(d));
    }

    public void addHeaderElement(int n, String string, int n2) {
        this.addHeaderElement(n, string, String.valueOf(n2));
    }

    public void endHeader() {
        this.checkElementAddition(this.headerStarted);
        this.returnToParent();
        this.headerStarted = false;
    }

    public void newPart(int n, int n2, int n3, int n4) {
        this.checkElementAddition(!this.partStarted);
        this.addChild("part");
        this.setAttribute("serial", n);
        this.setAttribute("ch", n2);
        this.setAttribute("pn", n3);
        this.setAttribute("vol", n4);
        this.currentPart = n;
        this.partStarted = true;
    }

    public void endPart() {
        this.checkElementAddition(this.partStarted);
        this.returnToParent();
        this.partStarted = false;
    }

    public void addControlChange(int n, int n2, int n3, int n4) {
        this.checkElementAddition(this.partStarted);
        this.addChild("control");
        this.addText(n + " " + n2 + " " + n3 + " " + n4);
        this.returnToParent();
    }

    public void addNoteElement(int n, int n2, int n3, int n4) {
        this.addNoteElement(n, n2, n3, n4, null);
    }

    public void addNoteElement(int n, int n2, int n3, int n4, MusicXMLWrapper.Note note) {
        this.checkElementAddition(this.partStarted);
        this.addChild("note");
        this.addText(n + " " + n2 + " " + n3 + " " + n4);
        if (note != null) {
            this.putNoteMap(n, n2, n3, n4, n4, this.getDivision(), this.currentPart, note);
        }
        this.returnToParent();
    }

    public void addNoteElement(int n, int n2, int n3, int n4, int n5) {
        this.addNoteElement(n, n2, n3, n4, n5, null);
    }

    public void addNoteElement(int n, int n2, int n3, int n4, int n5, MusicXMLWrapper.Note note) {
        this.checkElementAddition(this.partStarted);
        this.addChild("note");
        this.addText(n + " " + n2 + " " + n3 + " " + n4 + " " + n5);
        if (note != null) {
            this.putNoteMap(n, n2, n3, n4, n5, this.getDivision(), this.currentPart, note);
        }
        this.returnToParent();
    }

    private void putNoteMap(int n, int n2, int n3, int n4, int n5, int n6, int n7, MusicXMLWrapper.Note note) {
        NumberedNote numberedNote = new NumberedNote(n, n2, n3, n4, n5, n6, n7);
        if (this.nEqualNotes.containsKey(numberedNote)) {
            byte by = this.nEqualNotes.get(numberedNote);
            NumberedNote numberedNote2 = new NumberedNote(numberedNote);
            by = (byte)(by + 1);
            numberedNote2.number = by;
            this.notemap.put(numberedNote2, note);
            this.nEqualNotes.put(numberedNote, by);
            this.setAttribute("number", by);
        } else {
            this.notemap.put(numberedNote, note);
            this.nEqualNotes.put(numberedNote, (byte)1);
        }
    }

    public void beginAnnotations() {
        this.addChild("annotations");
        this.annotationsStarted = true;
    }

    public void addAnnotation(String string, int n, int n2, String string2) {
        this.checkElementAddition(this.annotationsStarted);
        this.addChildAndText(string, n + " " + n2 + " " + string2);
    }

    public void addChord(int n, int n2, String string) {
        this.addAnnotation("chord", n, n2, string);
    }

    public void addBarline(int n, String string) {
        this.addAnnotation("barline", n, n, string);
    }

    public void endAnnotations() {
        this.checkElementAddition(this.annotationsStarted);
        this.returnToParent();
        this.annotationsStarted = false;
    }

    public Annotation[] getChordList() {
        if (this.chords != null) {
            return this.chords;
        }
        Node node = this.selectSingleNode("/scc/annotations");
        if (node == null) {
            return null;
        }
        NodeList nodeList = this.selectNodeList(node, "chord");
        int n = nodeList.getLength();
        this.chords = new Annotation[n];
        for (int i = 0; i < n; ++i) {
            this.chords[i] = new Annotation(nodeList.item(i));
        }
        return this.chords;
    }

    public Annotation[] getBarlineList() {
        if (this.barlines != null) {
            return this.barlines;
        }
        Node node = this.selectSingleNode("/scc/annotations");
        if (node == null) {
            return null;
        }
        NodeList nodeList = this.selectNodeList(node, "barline");
        int n = nodeList.getLength();
        this.barlines = new Annotation[n];
        for (int i = 0; i < n; ++i) {
            this.barlines[i] = new Annotation(nodeList.item(i));
        }
        return this.barlines;
    }

    public HeaderElement[] getHeaderElementList() {
        if (this.headlist == null) {
            Node node = this.selectSingleNode("/scc/header");
            if (node == null) {
                return null;
            }
            NodeList nodeList = this.selectNodeList(node, "meta");
            int n = nodeList.getLength();
            this.headlist = new HeaderElement[n];
            for (int i = 0; i < n; ++i) {
                this.headlist[i] = new HeaderElement(nodeList.item(i));
            }
        }
        return this.headlist;
    }

    @Override
    public void processNotes(CommonNoteHandler commonNoteHandler) throws TransformerException {
        Part[] partArray;
        for (Part part : partArray = this.getPartList()) {
            Note[] noteArray;
            String string = String.valueOf(part.serial());
            commonNoteHandler.beginPart(string, this);
            for (Note note : noteArray = part.getNoteOnlyList()) {
                commonNoteHandler.processNote(note, this);
            }
            commonNoteHandler.endPart(string, this);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void processNotes(SCCHandler sCCHandler) throws TransformerException {
        void var6_9;
        HeaderElement[] headerElementArray = this.getHeaderElementList();
        if (headerElementArray != null) {
            sCCHandler.beginHeader(this);
            for (NodeInterface nodeInterface : headerElementArray) {
                sCCHandler.processHeaderElement(((HeaderElement)nodeInterface).time(), ((HeaderElement)nodeInterface).name(), ((HeaderElement)nodeInterface).content(), this);
            }
            sCCHandler.endHeader(this);
        }
        NodeInterface[] nodeInterfaceArray = this.getPartList();
        Part[] partArray = nodeInterfaceArray;
        int n = partArray.length;
        boolean bl = false;
        while (var6_9 < n) {
            Note[] noteArray;
            Part part = partArray[var6_9];
            sCCHandler.beginPart(part, this);
            for (Note note : noteArray = part.getNoteList()) {
                sCCHandler.processNote(note, this);
            }
            sCCHandler.endPart(part, this);
            ++var6_9;
        }
    }

    public void processSortedNotes(SCCHandler sCCHandler) throws TransformerException {
        Object object;
        Object object2;
        Node node = this.selectSingleNode("/scc/header");
        if (node != null) {
            sCCHandler.beginHeader(this);
            object2 = this.selectNodeList(node, "meta");
            int n = object2.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = object2.item(i);
                Object object3 = NodeInterface.getAttribute(node2, "name");
                object = NodeInterface.getAttribute(node2, "content");
                int n2 = NodeInterface.getAttributeInt(node2, "time");
                sCCHandler.processHeaderElement(n2, (String)object3, (String)object, this);
            }
            sCCHandler.endHeader(this);
        }
        object2 = this.getPartList();
        for (Object object3 : object2) {
            sCCHandler.beginPart((Part)object3, this);
            for (Note note : object = ((Part)object3).getSortedNoteList()) {
                sCCHandler.processNote(note, this);
            }
            sCCHandler.endPart((Part)object3, this);
        }
    }

    public Part[] getPartList() throws TransformerException {
        if (this.partlist == null) {
            NodeList nodeList = this.selectNodeList("/scc/part");
            int n = nodeList.getLength();
            this.partlist = new Part[n];
            for (int i = 0; i < n; ++i) {
                this.partlist[i] = new Part(nodeList.item(i));
            }
        }
        return this.partlist;
    }

    @Override
    public List<SimpleNoteList> getPartwiseNoteList(final int n) throws TransformerException {
        final ArrayList<SimpleNoteList> arrayList = new ArrayList<SimpleNoteList>();
        this.processNotes(new SCCHandler(){
            private SimpleNoteList nl;

            public void beginHeader(SCCXMLWrapper sCCXMLWrapper) {
            }

            public void endHeader(SCCXMLWrapper sCCXMLWrapper) {
            }

            public void processHeaderElement(int n2, String string, String string2, SCCXMLWrapper sCCXMLWrapper) {
            }

            public void beginPart(Part part, SCCXMLWrapper sCCXMLWrapper) {
                this.nl = new SimpleNoteList(part.serial(), n);
            }

            public void endPart(Part part, SCCXMLWrapper sCCXMLWrapper) {
                arrayList.add(this.nl);
            }

            public void processNote(Note note, SCCXMLWrapper sCCXMLWrapper) {
                if (!(note instanceof ControlChange)) {
                    this.nl.add(note);
                }
            }
        });
        return arrayList;
    }

    @Override
    public InputStream getMIDIInputStream() throws IOException, TransformerException, ParserConfigurationException, SAXException {
        return this.toMIDIXML().getMIDIInputStream();
    }

    public MIDIXMLWrapper toMIDIXML() throws ParserConfigurationException, TransformerException, SAXException, IOException {
        MIDIXMLWrapper mIDIXMLWrapper = (MIDIXMLWrapper)CMXFileWrapper.createDocument("MIDIFile");
        this.toMIDIXML(mIDIXMLWrapper);
        return mIDIXMLWrapper;
    }

    public void toMIDIXML(final MIDIXMLWrapper mIDIXMLWrapper) throws ParserConfigurationException, TransformerException, SAXException, IOException {
        mIDIXMLWrapper.addElementsFirstForFormat1(this.getPartList().length + 1, this.getDivision());
        this.processNotes(new SCCHandler(){
            private int currentTrack = 1;
            private int currentTime = 0;

            public final void beginHeader(SCCXMLWrapper sCCXMLWrapper) {
                mIDIXMLWrapper.newTrack(this.currentTrack);
            }

            public final void endHeader(SCCXMLWrapper sCCXMLWrapper) {
                mIDIXMLWrapper.endTrack();
                ++this.currentTrack;
            }

            public final void processHeaderElement(int n, String string, String string2, SCCXMLWrapper sCCXMLWrapper) {
                if (string.equals("TEMPO")) {
                    mIDIXMLWrapper.addMetaEvent("SetTempo", n - this.currentTime, (int)(6.0E7 / Double.parseDouble(string2)));
                }
                this.currentTime = n;
            }

            public final void beginPart(Part part, SCCXMLWrapper sCCXMLWrapper) {
                mIDIXMLWrapper.newTrack(this.currentTrack);
                MIDIEventList mIDIEventList = part.toMIDIEventList();
                mIDIXMLWrapper.addMIDIChannelMessages(mIDIEventList);
            }

            public final void endPart(Part part, SCCXMLWrapper sCCXMLWrapper) {
                mIDIXMLWrapper.endTrack();
                ++this.currentTrack;
            }

            public final void processNote(Note note, SCCXMLWrapper sCCXMLWrapper) {
            }
        });
        mIDIXMLWrapper.finalizeDocument();
    }

    public SCCXMLWrapper replaceVelocity(List<List<Byte>> list, boolean bl) throws TransformerException, InvalidFileTypeException, ParserConfigurationException, SAXException, IOException {
        final SCCXMLWrapper sCCXMLWrapper = (SCCXMLWrapper)CMXFileWrapper.createDocument(TOP_TAG);
        sCCXMLWrapper.setDivision(this.getDivision());
        final Iterator<List<Byte>> iterator = list.iterator();
        SCCHandler sCCHandler = new SCCHandler(){
            Iterator<Byte> it2;

            public final void beginHeader(SCCXMLWrapper sCCXMLWrapper2) {
                sCCXMLWrapper.beginHeader();
            }

            public final void endHeader(SCCXMLWrapper sCCXMLWrapper2) {
                sCCXMLWrapper.endHeader();
            }

            public final void processHeaderElement(int n, String string, String string2, SCCXMLWrapper sCCXMLWrapper2) {
                sCCXMLWrapper.addHeaderElement(n, string, string2);
            }

            public final void beginPart(Part part, SCCXMLWrapper sCCXMLWrapper2) {
                sCCXMLWrapper.newPart(part.serial(), part.channel(), part.prognum(), part.volume());
                this.it2 = ((List)iterator.next()).iterator();
            }

            public final void endPart(Part part, SCCXMLWrapper sCCXMLWrapper2) {
                sCCXMLWrapper.endPart();
            }

            public final void processNote(Note note, SCCXMLWrapper sCCXMLWrapper2) {
                if (note instanceof ControlChange) {
                    ControlChange controlChange = (ControlChange)note;
                    sCCXMLWrapper.addControlChange(controlChange.onset(), controlChange.offset(), controlChange.ctrlnum(), controlChange.value());
                } else {
                    byte by = this.it2.next();
                    sCCXMLWrapper.addNoteElement(note.onset(), note.offset(), note.notenum(), (int)by, note.getMusicXMLWrapperNote());
                }
            }
        };
        if (bl) {
            this.processSortedNotes(sCCHandler);
        } else {
            this.processNotes(sCCHandler);
        }
        sCCXMLWrapper.finalizeDocument();
        return sCCXMLWrapper;
    }

    public SCCXMLWrapper changeVelocity(List<List<Byte>> list, boolean bl) throws TransformerException, InvalidFileTypeException, ParserConfigurationException, SAXException, IOException {
        final SCCXMLWrapper sCCXMLWrapper = (SCCXMLWrapper)CMXFileWrapper.createDocument(TOP_TAG);
        sCCXMLWrapper.setDivision(this.getDivision());
        final Iterator<List<Byte>> iterator = list.iterator();
        SCCHandler sCCHandler = new SCCHandler(){
            Iterator<Byte> it2;

            public final void beginHeader(SCCXMLWrapper sCCXMLWrapper2) {
                sCCXMLWrapper.beginHeader();
            }

            public final void endHeader(SCCXMLWrapper sCCXMLWrapper2) {
                sCCXMLWrapper.endHeader();
            }

            public final void processHeaderElement(int n, String string, String string2, SCCXMLWrapper sCCXMLWrapper2) {
                sCCXMLWrapper.addHeaderElement(n, string, string2);
            }

            public final void beginPart(Part part, SCCXMLWrapper sCCXMLWrapper2) {
                sCCXMLWrapper.newPart(part.serial(), part.channel(), part.prognum(), part.volume());
                this.it2 = ((List)iterator.next()).iterator();
            }

            public final void endPart(Part part, SCCXMLWrapper sCCXMLWrapper2) {
                sCCXMLWrapper.endPart();
            }

            public final void processNote(Note note, SCCXMLWrapper sCCXMLWrapper2) {
                if (note instanceof ControlChange) {
                    ControlChange controlChange = (ControlChange)note;
                    sCCXMLWrapper.addControlChange(controlChange.onset(), controlChange.offset(), controlChange.ctrlnum(), controlChange.value());
                } else {
                    byte by = this.it2.next();
                    int n = Math.max(Math.min(note.velocity + by, 127), 0);
                    sCCXMLWrapper.addNoteElement(note.onset(), note.offset(), note.notenum(), n, note.getMusicXMLWrapperNote());
                }
            }
        };
        if (bl) {
            this.processSortedNotes(sCCHandler);
        } else {
            this.processNotes(sCCHandler);
        }
        sCCXMLWrapper.finalizeDocument();
        return sCCXMLWrapper;
    }

    public static void main(String[] stringArray) {
        try {
            DeviationInstanceWrapper deviationInstanceWrapper = (DeviationInstanceWrapper)CMXFileWrapper.readfile("deviation.xml");
            SCCXMLWrapper sCCXMLWrapper = deviationInstanceWrapper.toSCCXML(480);
            sCCXMLWrapper.beginHeader();
            sCCXMLWrapper.addHeaderElement(10, "hoge", "foo");
            sCCXMLWrapper.endHeader();
            sCCXMLWrapper.write(System.out);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public class EasyChord {
        public int onset;
        public int offset;
        public String chord;

        public EasyChord(int n, int n2, String string) {
            this.onset = n;
            this.offset = n2;
            this.chord = string;
        }
    }

    private class NumberedNote
    extends MutableNote {
        private int partid;
        private byte number;

        private NumberedNote(int n, int n2, int n3, int n4, int n5, int n6) {
            this(n, n2, n3, n4, n4, n5, n6);
        }

        private NumberedNote(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            super(n, n2, n3, n4, n5, n6);
            this.number = 1;
            this.partid = n7;
        }

        private NumberedNote(NumberedNote numberedNote) {
            this(numberedNote.onset(), numberedNote.offset(), numberedNote.notenum(), numberedNote.velocity(), numberedNote.offVelocity(), numberedNote.ticksPerBeat(), numberedNote.partid);
            this.number = numberedNote.number;
        }

        public boolean equals(Object object) {
            if (object instanceof NumberedNote) {
                NumberedNote numberedNote = (NumberedNote)object;
                return super.equals(numberedNote) && this.number == numberedNote.number && this.partid == numberedNote.partid;
            }
            return false;
        }
    }

    public class ControlChange
    extends Note {
        private ControlChange(Node node, Part part) {
            super(node, part);
        }

        protected String getSuppotedNodeName() {
            return "control";
        }

        public final int ctrlnum() {
            return this.notenum();
        }

        public final int value() {
            return this.velocity();
        }
    }

    public class Note
    extends NodeInterface
    implements NoteCompatible {
        private Part part;
        private int onset;
        private int offset;
        private int notenum;
        private int velocity;
        private int offVelocity;
        private int onsetInMSec;
        private int offsetInMSec;

        private Note(Node node, Part part) {
            super(node);
            this.part = part;
            String[] stringArray = Note.getText(this.node()).split("\\s");
            this.onset = Integer.parseInt(stringArray[0]);
            this.offset = Integer.parseInt(stringArray[1]);
            this.notenum = Integer.parseInt(stringArray[2]);
            this.velocity = Integer.parseInt(stringArray[3]);
            this.offVelocity = stringArray.length >= 5 ? Integer.parseInt(stringArray[4]) : this.velocity;
        }

        protected String getSupportedNodeName() {
            return "note|control";
        }

        public final int onset() {
            return this.onset;
        }

        public final int onset(int n) {
            if (n == SCCXMLWrapper.this.getDivision()) {
                return this.onset;
            }
            return this.onset * n / SCCXMLWrapper.this.getDivision();
        }

        public final int offset() {
            return this.offset;
        }

        public final int offset(int n) {
            if (n == SCCXMLWrapper.this.getDivision()) {
                return this.offset;
            }
            return this.offset * n / SCCXMLWrapper.this.getDivision();
        }

        public final int duration(int n) {
            return this.offset(n) - this.onset(n);
        }

        public final int notenum() {
            return this.notenum;
        }

        public final int velocity() {
            return this.velocity;
        }

        public final int offVelocity() {
            return this.offVelocity;
        }

        public final Part part() {
            return this.part;
        }

        public final int onsetInMSec() {
            return this.onsetInMSec;
        }

        public final int offsetInMSec() {
            return this.offsetInMSec;
        }

        public MusicXMLWrapper.Note getMusicXMLWrapperNote() {
            NumberedNote numberedNote = new NumberedNote(this.onset, this.offset, this.notenum, this.velocity, this.offVelocity, SCCXMLWrapper.this.getDivision(), this.part.serial());
            if (this.hasAttribute("number")) {
                numberedNote.number = Byte.parseByte(this.getAttribute("number"));
            }
            return (MusicXMLWrapper.Note)SCCXMLWrapper.this.notemap.get(numberedNote);
        }

        public boolean isEqualNoteTo(Note note) {
            return this.onset == note.onset && this.offset == note.offset && this.notenum == note.notenum && this.velocity == note.velocity && this.offVelocity == note.offVelocity;
        }
    }

    public class Part
    extends NodeInterface {
        private Note[] notelist;
        private List<Note> noteonlylist;

        private Part(Node node) {
            super(node);
            this.notelist = null;
            this.noteonlylist = null;
        }

        protected final String getSupportedNodeName() {
            return "part";
        }

        public Note[] getNoteList() {
            if (this.notelist == null) {
                NodeList nodeList = this.getChildNodes();
                int n = nodeList.getLength();
                this.notelist = new Note[n];
                this.noteonlylist = new ArrayList<Note>();
                for (int i = 0; i < n; ++i) {
                    Node node = nodeList.item(i);
                    if (node.getNodeName().equals("note")) {
                        this.notelist[i] = new Note(node, this);
                        this.noteonlylist.add(this.notelist[i]);
                        continue;
                    }
                    if (!node.getNodeName().equals("control")) continue;
                    this.notelist[i] = new ControlChange(node, this);
                }
            }
            return this.notelist;
        }

        public Note[] getNoteOnlyList() {
            if (this.noteonlylist == null) {
                this.getNoteList();
            }
            return this.noteonlylist.toArray(new Note[this.noteonlylist.size()]);
        }

        public Note[] getSortedNoteList() {
            Note[] noteArray = (Note[])this.getNoteList().clone();
            Arrays.sort(noteArray, new Comparator<Note>(){

                @Override
                public int compare(Note note, Note note2) {
                    return note.onset() == note2.onset() ? (note.offset() == note2.offset() ? (note.notenum() == note2.notenum() ? note.velocity() - note2.velocity() : note.notenum() - note2.notenum()) : note.offset() - note2.offset()) : note.onset() - note2.onset();
                }
            });
            return noteArray;
        }

        public Note[] getSortedNoteOnlyList() {
            Note[] noteArray = (Note[])this.getNoteOnlyList().clone();
            Arrays.sort(noteArray, new Comparator<Note>(){

                @Override
                public int compare(Note note, Note note2) {
                    return note.onset() == note2.onset() ? (note.offset() == note2.offset() ? (note.notenum() == note2.notenum() ? note.velocity() - note2.velocity() : note.notenum() - note2.notenum()) : note.offset() - note2.offset()) : note.onset() - note2.onset();
                }
            });
            return noteArray;
        }

        public Note[] getSortedNoteList(final int n) {
            Note[] noteArray = (Note[])this.getNoteList().clone();
            Arrays.sort(noteArray, new Comparator<Note>(){

                @Override
                public int compare(Note note, Note note2) {
                    return Math.abs(note.onset() - note2.onset()) < n ? (note.notenum() == note2.notenum() ? note.velocity() - note2.velocity() : note.notenum() - note2.notenum()) : note.onset() - note2.onset();
                }
            });
            return noteArray;
        }

        public Note[] getSortedNoteOnlyList(final int n) {
            Note[] noteArray = (Note[])this.getNoteOnlyList().clone();
            Arrays.sort(noteArray, new Comparator<Note>(){

                @Override
                public int compare(Note note, Note note2) {
                    return Math.abs(note.onset() - note2.onset()) < n ? (note.notenum() == note2.notenum() ? note.velocity() - note2.velocity() : note.notenum() - note2.notenum()) : note.onset() - note2.onset();
                }
            });
            return noteArray;
        }

        public MIDIEventList toMIDIEventList() {
            Note[] noteArray;
            byte by = this.channel();
            MIDIEventList mIDIEventList = new MIDIEventList();
            for (Note note : noteArray = this.getNoteList()) {
                if (note instanceof ControlChange) {
                    mIDIEventList.addEvent(note.onset(), (short)176, by, ((ControlChange)note).ctrlnum(), ((ControlChange)note).value());
                    continue;
                }
                mIDIEventList.addEvent(note.onset(), (short)144, by, note.notenum(), note.velocity());
                mIDIEventList.addEvent(note.offset(), (short)128, by, note.notenum(), note.velocity());
            }
            return mIDIEventList;
        }

        public final int serial() {
            return Part.getAttributeInt(this.node(), "serial");
        }

        public final byte channel() {
            return Byte.parseByte(Part.getAttribute(this.node(), "ch"));
        }

        public final int prognum() {
            return Part.getAttributeInt(this.node(), "pn");
        }

        public final int volume() {
            return Part.getAttributeInt(this.node(), "vol");
        }
    }

    public class HeaderElement
    extends NodeInterface {
        private int timestamp;
        private String name;
        private String content;

        private HeaderElement(Node node) {
            super(node);
            this.timestamp = HeaderElement.getAttributeInt(node, "time");
            this.name = HeaderElement.getAttribute(node, "name");
            this.content = HeaderElement.getAttribute(node, "content");
        }

        protected String getSupportedNodeName() {
            return "meta";
        }

        public int time() {
            return this.timestamp;
        }

        public String name() {
            return this.name;
        }

        public String content() {
            return this.content;
        }
    }

    public class Annotation
    extends NodeInterface {
        private int onset;
        private int offset;
        private String content;

        private Annotation(Node node) {
            super(node);
            String[] stringArray = Annotation.getText(this.node()).split("\\s");
            this.onset = Integer.parseInt(stringArray[0]);
            this.offset = stringArray.length >= 2 ? Integer.parseInt(stringArray[1]) : this.onset;
            this.content = stringArray.length >= 3 ? stringArray[2] : null;
        }

        protected String getSupportedNodeName() {
            return "chord|barline";
        }

        public int onset() {
            return this.onset;
        }

        public int offset() {
            return this.offset;
        }

        public String content() {
            return this.content;
        }
    }
}

