/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.sound;

import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import jp.crestmuse.cmx.sound.LineSupportingMusicPlayer;
import jp.crestmuse.cmx.sound.MusicPlayer;
import jp.crestmuse.cmx.sound.WAVPlaySynchronized;

public class WAVPlaySynchronizer
implements Runnable,
LineListener {
    private MusicPlayer player;
    private Thread thPlay = null;
    private Thread thDraw;
    private List<WAVPlaySynchronized> synclist = new ArrayList<WAVPlaySynchronized>();
    private boolean thPlayStarted = false;
    private boolean stoppedByUser = false;
    private long sleeptime = 100L;

    public WAVPlaySynchronizer(MusicPlayer musicPlayer) {
        this.player = musicPlayer;
        if (musicPlayer instanceof LineSupportingMusicPlayer) {
            ((LineSupportingMusicPlayer)musicPlayer).addLineListener(this);
        }
        this.thPlay = new Thread(musicPlayer);
    }

    public void addSynchronizedComponent(WAVPlaySynchronized wAVPlaySynchronized) {
        this.synclist.add(wAVPlaySynchronized);
    }

    public void wavplay() {
        this.player.play();
        if (!this.thPlayStarted) {
            this.thPlay.start();
        }
        this.thPlayStarted = true;
        this.stoppedByUser = false;
    }

    public void wavstop() {
        this.stoppedByUser = true;
        if (this.player != null) {
            this.player.stop();
        }
    }

    public boolean isStoppedByUser() {
        return this.stoppedByUser;
    }

    public boolean isNowPlaying() {
        return this.player != null && this.player.isNowPlaying();
    }

    public void update(LineEvent lineEvent) {
        block3: {
            LineEvent.Type type;
            block2: {
                type = lineEvent.getType();
                if (!type.equals(LineEvent.Type.START)) break block2;
                this.thDraw = new Thread(this);
                this.thDraw.start();
                for (WAVPlaySynchronized wAVPlaySynchronized : this.synclist) {
                    wAVPlaySynchronized.start(this);
                }
                break block3;
            }
            if (!type.equals(LineEvent.Type.STOP)) break block3;
            this.thDraw.stop();
            this.thDraw = null;
            for (WAVPlaySynchronized wAVPlaySynchronized : this.synclist) {
                wAVPlaySynchronized.stop(this);
            }
        }
    }

    public void setSleepTime(long l) {
        this.sleeptime = l;
    }

    public void run() {
        while (true) {
            if (!this.isNowPlaying()) {
                continue;
            }
            long l = this.player.getMicrosecondPosition();
            double d = (double)l / 1000000.0;
            for (WAVPlaySynchronized wAVPlaySynchronized : this.synclist) {
                wAVPlaySynchronized.synchronize(d, this);
            }
            try {
                Thread.sleep(this.sleeptime);
                continue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                continue;
            }
            break;
        }
    }
}

