/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.misc;

import java.util.HashMap;
import java.util.Map;
import jp.crestmuse.cmx.misc.NodeSearchFilter;
import jp.crestmuse.cmx.misc.Ordered;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeView<E extends Ordered> {
    private boolean additionPermitted = true;
    private Map<E, Node> map;
    private BranchHolder trunk;
    private Map<Byte, BranchHolder> branches;
    private BranchHolder currentBranch;
    private byte currentBranchID = 0;
    private String id;

    public TreeView() {
        this("", null);
    }

    public TreeView(String string) {
        this(string, null);
    }

    private TreeView(Node node) {
        this("", node);
    }

    private TreeView(String string, Node node) {
        this.id = string;
        this.branches = new HashMap<Byte, BranchHolder>();
        this.trunk = new BranchHolder(0, node == null ? new NullNode(-1, -1, 0) : node);
        this.branches.put((byte)0, this.trunk);
        this.currentBranch = this.trunk;
        this.map = new HashMap<E, Node>();
    }

    public String getTreeID() {
        return this.id;
    }

    public void add(E e, byte by, String string) {
        if (this.additionPermitted) {
            if (this.branches.containsKey(by)) {
                this.insertToSortedRightPath(e, string, this.branches.get(by));
            } else {
                Node node = this.insertNewBranchToSortedRightPath(e, string);
                BranchHolder branchHolder = new BranchHolder(by, node);
                this.branches.put(by, branchHolder);
            }
        } else {
            throw new IllegalStateException("Addition is not permitted");
        }
    }

    public void add(E e, String string) {
        if (!this.additionPermitted) {
            throw new IllegalStateException("Addition is not permitted");
        }
        this.insertToSortedRightPath(e, string, this.trunk);
    }

    private Node insertNewBranchToSortedRightPath(E e, String string) {
        int n = e.ordinal();
        int n2 = e.subordinal();
        if (this.trunk.head.compare(n, n2) < 0) {
            throw new IllegalStateException();
        }
        int n3 = this.trunk.getFirstNodeAtSameTime().compare(n, n2);
        if (n3 < 0) {
            this.trunk.getFirstNodeAtPreviousTime();
            return this.insertNewBranchToSortedRightPath(e, string);
        }
        if (this.trunk.getFirstNodeAtSameTime().compareToChild(n, n2) >= 0) {
            this.trunk.getFirstNodeAtNextTime();
            return this.insertNewBranchToSortedRightPath(e, string);
        }
        if (n3 == 0) {
            this.trunk.appendToLeftLeaf(e, string);
            return this.trunk.current;
        }
        this.trunk.insertNullToChildR(n, n2, string);
        this.trunk.appendToLeftLeaf(e, string);
        return this.trunk.current;
    }

    private void insertToSortedRightPath(E e, String string, BranchHolder branchHolder) {
        int n = e.ordinal();
        int n2 = e.subordinal();
        if (branchHolder.head.compare(n, n2) < 0) {
            branchHolder.replaceBranchHeadTo(e, string);
        } else {
            int n3 = branchHolder.getFirstNodeAtSameTime().compare(n, n2);
            if (n3 < 0) {
                branchHolder.getFirstNodeAtPreviousTime();
                this.insertToSortedRightPath(e, string, branchHolder);
            } else if (branchHolder.getFirstNodeAtSameTime().compareToChild(n, n2) >= 0) {
                branchHolder.getFirstNodeAtNextTime();
                this.insertToSortedRightPath(e, string, branchHolder);
            } else if (n3 == 0) {
                branchHolder.appendToLeftLeaf(e, string);
            } else {
                branchHolder.insertToChildR(e, string);
            }
        }
    }

    private void insertNullToSortedRightPath(int n, int n2, String string, BranchHolder branchHolder) {
        if (branchHolder.head.compare(n, n2) < 0) {
            throw new IllegalStateException(n + " " + n2);
        }
        int n3 = branchHolder.getFirstNodeAtSameTime().compare(n, n2);
        if (n3 < 0) {
            branchHolder.getFirstNodeAtPreviousTime();
            this.insertNullToSortedRightPath(n, n2, string, branchHolder);
        } else if (branchHolder.getFirstNodeAtSameTime().compareToChild(n, n2) >= 0) {
            branchHolder.getFirstNodeAtNextTime();
            this.insertNullToSortedRightPath(n, n2, string, branchHolder);
        } else if (n3 == 0) {
            branchHolder.appendNullToLeftLeaf(n, n2, string);
        } else {
            branchHolder.insertNullToChildR(n, n2, string);
        }
    }

    public E getRoot() {
        this.currentBranch = this.trunk;
        this.currentBranchID = 0;
        return (E)this.trunk.getRoot().entry;
    }

    public E getBranchHead(byte by) {
        this.currentBranchID = by;
        this.currentBranch = this.branches.get(by);
        return (E)this.currentBranch.getRoot().entry;
    }

    public E nextL() {
        return (E)this.currentBranch.nextL().entry;
    }

    public boolean hasNextL() {
        return this.currentBranch.hasNextL();
    }

    public E nextR() {
        return (E)this.currentBranch.nextR().entry;
    }

    public boolean hasNextR() {
        return this.currentBranch.hasNextR();
    }

    public E parent() {
        return (E)this.currentBranch.parent().entry;
    }

    public E getFirstElementAtPreviousTime() {
        return (E)this.currentBranch.getFirstNodeAtPreviousTime().entry;
    }

    public E getFirstElementAtSameTime() {
        return (E)this.currentBranch.getFirstNodeAtSameTime().entry;
    }

    public E getNextElementAtSameTime() {
        return (E)this.currentBranch.nextL().entry;
    }

    public boolean hasMoreElementsAtSameTime() {
        return this.currentBranch.hasNextL();
    }

    public E getFirstElementAtNextTime() {
        return (E)this.currentBranch.getFirstNodeAtNextTime().entry;
    }

    public boolean hasElementsAtNextTime() {
        return this.currentBranch.hasNodesAtNextTime();
    }

    public E get(int n, int n2) {
        Node node = this.currentBranch.get(n, n2);
        return (E)(node == null ? null : node.entry);
    }

    public E lookAhead(NodeSearchFilter<E> nodeSearchFilter) {
        Node node = this.currentBranch.lookAhead(nodeSearchFilter);
        return (E)(node == null ? null : node.entry);
    }

    public void jumpTo(E e) {
        this.currentBranch = this.trunk;
        this.currentBranchID = 0;
        this.trunk.jumpTo(e);
    }

    public boolean isempty() {
        return this.trunk.head.childL == null && this.trunk.head.childR == null;
    }

    public String toString() {
        return this.trunk.head.toString("");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Node {
        private E entry;
        private Node childL;
        private Node childR;
        private Node parent;
        private String labelL;
        private String labelR;
        private byte branchID;
        final /* synthetic */ TreeView this$0;

        Node(TreeView treeView, byte by) {
            this.this$0 = treeView;
            this.entry = null;
            this.childL = null;
            this.childR = null;
            this.parent = null;
            this.labelL = "";
            this.labelR = "";
            this.branchID = by;
        }

        /*
         * WARNING - Possible parameter corruption
         */
        private Node(E e, byte by) {
            this.this$0 = (TreeView)n;
            this.entry = null;
            this.childL = null;
            this.childR = null;
            this.parent = null;
            this.labelL = "";
            this.labelR = "";
            this.entry = e;
            this.branchID = by;
            ((TreeView)n).map.put(e, this);
        }

        void setChildL(Node node, String string) {
            this.childL = node;
            node.parent = this;
            this.labelL = string;
        }

        void setChildR(Node node, String string) {
            this.childR = node;
            node.parent = this;
            this.labelR = string;
        }

        Node insertToChildR(E e, String string) {
            Node node = new Node(this.this$0, e, this.branchID);
            if (this.childR != null) {
                node.setChildR(this.childR, this.labelR);
            }
            this.setChildR(node, string);
            return node;
        }

        Node insertNullToChildR(int n, int n2, String string) {
            NullNode nullNode = this.this$0.new NullNode(n, n2, this.branchID);
            if (this.childR != null) {
                nullNode.setChildR(this.childR, this.labelR);
            }
            this.setChildR(nullNode, string);
            return nullNode;
        }

        Node appendToLeftLeaf(E e, String string) {
            if (this.childL != null) {
                return this.childL.appendToLeftLeaf(e, string);
            }
            Node node = new Node(this.this$0, e, this.branchID);
            this.setChildL(node, string);
            return node;
        }

        Node appendNullToLeftLeaf(int n, int n2, String string) {
            if (this.childL != null) {
                return this.childL.appendNullToLeftLeaf(n, n2, string);
            }
            NullNode nullNode = this.this$0.new NullNode(n, n2, this.branchID);
            this.setChildL(nullNode, string);
            return nullNode;
        }

        int compare(int n, int n2) {
            if (n == this.ordinal()) {
                return n2 - this.subordinal();
            }
            return n - this.ordinal();
        }

        int compareToChild(int n, int n2) {
            if (this.childR == null) {
                return -1;
            }
            if (n == this.childR.ordinal()) {
                return n2 - this.childR.subordinal();
            }
            return n - this.childR.ordinal();
        }

        Node get(int n, int n2) {
            if (this.compare(n, n2) < 0) {
                return this.parent.get(n, n2);
            }
            if (this.compareToChild(n, n2) >= 0) {
                return this.childR.get(n, n2);
            }
            return this.childR;
        }

        Node searchL(NodeSearchFilter<E> nodeSearchFilter) {
            if (nodeSearchFilter.accept(this.entry)) {
                return this;
            }
            if (this.childL != null) {
                return this.childL.searchL(nodeSearchFilter);
            }
            return null;
        }

        int ordinal() {
            return this.entry.ordinal();
        }

        int subordinal() {
            return this.entry.subordinal();
        }

        public String toString(String string) {
            return this.entry + "\n" + string + "+-" + (this.childL != null ? this.childL.toString(string + "  ") : "null") + "\n" + string + "+-" + (this.childR != null ? this.childR.toString(string + "  ") : "null");
        }
    }

    private class NullNode
    extends Node {
        private int ordinal;
        private int subordinal;

        private NullNode(int n, int n2, byte by) {
            super(TreeView.this, by);
            this.ordinal = n;
            this.subordinal = n2;
        }

        int ordinal() {
            return this.ordinal;
        }

        int subordinal() {
            return this.subordinal;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BranchHolder {
        private Node head;
        private Node timewisetop;
        private Node current;
        private byte branchID;

        private BranchHolder(byte by, Node node) {
            this.branchID = by;
            this.timewisetop = this.head = node;
            this.current = this.head;
        }

        private Node getRoot() {
            this.timewisetop = this.current = this.head;
            return this.current;
        }

        private Node nextL() {
            this.current = this.current.childL;
            return this.current;
        }

        private boolean hasNextL() {
            return this.current.childL != null;
        }

        private Node nextR() {
            this.timewisetop = null;
            this.current = this.current.childR;
            return this.current;
        }

        private boolean hasNextR() {
            return this.current.childR != null;
        }

        private Node getFirstNodeAtPreviousTime() {
            this.timewisetop = this.current = this.timewisetop().parent;
            return this.current;
        }

        private Node getFirstNodeAtSameTime() {
            this.current = this.timewisetop();
            return this.current;
        }

        private Node getFirstNodeAtNextTime() {
            this.current = this.timewisetop = this.timewisetop().childR;
            return this.timewisetop;
        }

        private boolean hasNodesAtNextTime() {
            return this.timewisetop().childR != null;
        }

        private Node timewisetop() {
            if (this.timewisetop == null) {
                this.timewisetop = this.timewisetop(this.current);
            }
            return this.timewisetop;
        }

        private Node timewisetop(Node node) {
            if (node.parent != null && node.parent.childL != null && node.parent.childL == node) {
                return this.timewisetop(node.parent);
            }
            return node;
        }

        private Node parent() {
            this.timewisetop = null;
            this.current = this.current.parent;
            return this.current;
        }

        private void appendToLeftLeaf(E e, String string) {
            this.current = this.current.appendToLeftLeaf(e, string);
        }

        private void appendNullToLeftLeaf(int n, int n2, String string) {
            this.current = this.current.appendNullToLeftLeaf(n, n2, string);
        }

        private void insertToChildR(E e, String string) {
            this.timewisetop = this.current = this.timewisetop().insertToChildR(e, string);
        }

        private void insertNullToChildR(int n, int n2, String string) {
            this.timewisetop = this.current = this.timewisetop().insertNullToChildR(n, n2, string);
        }

        private Node get(int n, int n2) {
            this.current = this.timewisetop().get(n, n2);
            this.timewisetop = null;
            return this.current;
        }

        private Node lookAhead(NodeSearchFilter<E> nodeSearchFilter) {
            Node node;
            if (this.current.childL != null && (node = this.current.childL.searchL(nodeSearchFilter)) != null) {
                return node;
            }
            node = this.timewisetop();
            while (node.childR != null) {
                Node node2 = (node = node.childR).searchL(nodeSearchFilter);
                if (node2 == null) continue;
                return node2;
            }
            return null;
        }

        private void jumpTo(E e) {
            Node node;
            this.current = node = (Node)TreeView.this.map.get(e);
            this.timewisetop = null;
        }

        private void replaceBranchHeadTo(E e, String string) {
            TreeView.this.insertNullToSortedRightPath(e.ordinal(), e.subordinal(), "", TreeView.this.trunk);
            Node node = ((TreeView)TreeView.this).trunk.current.appendToLeftLeaf(e, string);
            Node node2 = this.head.parent;
            node.setChildR(this.head, node2.labelL);
            if (this.head.childL != null) {
                node2.setChildL(this.head.childL, this.head.labelL);
            }
            this.head.childL = null;
            this.timewisetop = this.current = node;
            this.head = this.current;
        }
    }
}

