/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.filewrappers;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.sound.sampled.AudioFormat;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.amusaj.filewrappers.ByteArrayNodeInterface;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.filewrappers.InvalidElementException;
import jp.crestmuse.cmx.filewrappers.InvalidFileTypeException;
import jp.crestmuse.cmx.filewrappers.NodeInterface;
import jp.crestmuse.cmx.math.DoubleArray;
import jp.crestmuse.cmx.math.DoubleArrayFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WAVXMLWrapper
extends CMXFileWrapper {
    public static final String TOP_TAG = "riff-wave";
    private FmtChunk fmt;
    private DataChunk[] datalist;
    private static final DoubleArrayFactory factory = DoubleArrayFactory.getFactory();

    public FmtChunk getFmtChunk() {
        if (this.fmt == null) {
            this.fmt = new FmtChunk(this.selectSingleNode("/riff-wave/fmt-chunk"));
        }
        return this.fmt;
    }

    public DataChunk[] getDataChunkList() {
        if (this.datalist == null) {
            NodeList nodeList = this.selectNodeList("/riff-wave/data-chunk");
            int n = nodeList.getLength();
            this.datalist = new DataChunk[n];
            for (int i = 0; i < n; ++i) {
                this.datalist[i] = new DataChunk(nodeList.item(i));
            }
        }
        return this.datalist;
    }

    public void addFmtChunk(int n, int n2, int n3, int n4, int n5, int n6) {
        this.addChild("fmt-chunk");
        this.addChildAndText("format", n);
        this.addChildAndText("channels", n2);
        this.addChildAndText("sample-rate", n3);
        this.addChildAndText("byte-rate", n4);
        this.addChildAndText("block-align", n5);
        this.addChildAndText("bits-per-sample", n6);
        this.returnToParent();
    }

    public void addDataChunk(byte[] byArray) {
        this.addChild("data-chunk");
        ByteArrayNodeInterface.addByteArrayToWrapper(byArray, "audio-data", this);
        this.returnToParent();
        this.returnToParent();
    }

    public static WAVXMLWrapper readWAV(String string) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        WAVXMLWrapper wAVXMLWrapper = (WAVXMLWrapper)WAVXMLWrapper.createDocument(TOP_TAG);
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(string)));
        wAVXMLWrapper.readWAV(dataInputStream);
        wAVXMLWrapper.finalizeDocument();
        return wAVXMLWrapper;
    }

    private void readWAV(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = new byte[4];
        dataInputStream.read(byArray);
        if (!new String(byArray).equals("RIFF")) {
            throw new InvalidFileTypeException();
        }
        WAVXMLWrapper.readUnsignedInt(dataInputStream);
        dataInputStream.read(byArray);
        if (!new String(byArray).equals("WAVE")) {
            throw new InvalidFileTypeException();
        }
        while (dataInputStream.read(byArray) != -1) {
            String string = new String(byArray);
            int n = WAVXMLWrapper.readUnsignedInt(dataInputStream);
            byte[] byArray2 = new byte[n];
            dataInputStream.read(byArray2);
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            if (string.equals("fmt ")) {
                this.readFmtChunk(n, byteBuffer);
                continue;
            }
            if (!string.equals("data")) continue;
            this.readDataChunk(n, byteBuffer);
        }
    }

    private static int readUnsignedInt(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedByte();
        int n2 = dataInputStream.readUnsignedByte();
        int n3 = dataInputStream.readUnsignedByte();
        int n4 = dataInputStream.readUnsignedByte();
        return n + 256 * n2 + 65536 * n3 + 0x1000000 * n4;
    }

    private void readFmtChunk(int n, ByteBuffer byteBuffer) throws IOException {
        int n2 = this.readUnsignedShort(byteBuffer);
        int n3 = this.readUnsignedShort(byteBuffer);
        int n4 = this.readUnsignedInt(byteBuffer);
        int n5 = this.readUnsignedInt(byteBuffer);
        int n6 = this.readUnsignedShort(byteBuffer);
        int n7 = this.readUnsignedShort(byteBuffer);
        this.addFmtChunk(n2, n3, n4, n5, n6, n7);
    }

    private void readDataChunk(int n, ByteBuffer byteBuffer) throws IOException {
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        this.addDataChunk(byArray);
    }

    private int readUnsignedShort(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.getShort();
        return n < 0 ? n + 32768 : n;
    }

    private int readUnsignedInt(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.getInt();
        return n < 0 ? n + Integer.MIN_VALUE : n;
    }

    public void writefileAsWAV(String string) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
        this.write(dataOutputStream);
    }

    private void write(DataOutputStream dataOutputStream) throws IOException {
        DataChunk[] dataChunkArray;
        int n = 4;
        FmtChunk fmtChunk = this.getFmtChunk();
        n += fmtChunk.bytesize() + 8;
        for (DataChunk dataChunk : dataChunkArray = this.getDataChunkList()) {
            n += dataChunk.bytesize() + 8;
        }
        dataOutputStream.writeBytes("RIFF");
        WAVXMLWrapper.writeUnsignedInt(n, dataOutputStream);
        dataOutputStream.writeBytes("WAVE");
        fmtChunk.write(dataOutputStream);
        for (DataChunk dataChunk : dataChunkArray) {
            dataChunk.write(dataOutputStream);
        }
        dataOutputStream.close();
    }

    private static void writeUnsignedShort(int n, DataOutputStream dataOutputStream) throws IOException {
        byte by = (byte)(n / 256);
        byte by2 = (byte)(n % 256);
        dataOutputStream.writeByte(by2);
        dataOutputStream.writeByte(by);
    }

    private static void writeUnsignedInt(long l, DataOutputStream dataOutputStream) throws IOException {
        byte by = (byte)(l / 0x1000000L);
        byte by2 = (byte)(l % 0x1000000L / 65536L);
        byte by3 = (byte)(l % 65536L / 256L);
        byte by4 = (byte)(l % 256L);
        dataOutputStream.writeByte(by4);
        dataOutputStream.writeByte(by3);
        dataOutputStream.writeByte(by2);
        dataOutputStream.writeByte(by);
    }

    public class AudioData
    extends ByteArrayNodeInterface {
        private AudioData(Node node) {
            super(node);
            this.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        }

        protected String getSupportedNodeName() {
            return "audio-data";
        }

        public byte[] getByteArray() {
            return super.getByteArray();
        }

        public short[] getWaveform() {
            FmtChunk fmtChunk = WAVXMLWrapper.this.getFmtChunk();
            if (fmtChunk.bitsPerSample() == 8) {
                return this.getUnsignedByteArray();
            }
            if (fmtChunk.bitsPerSample() == 16) {
                return this.getShortArray();
            }
            throw new InvalidElementException("Unsupported bits/sample");
        }

        public int getZeroValue() {
            if (WAVXMLWrapper.this.fmt.bitsPerSample() == 8) {
                return 128;
            }
            if (WAVXMLWrapper.this.fmt.bitsPerSample() == 16) {
                return 0;
            }
            throw new InvalidElementException("Unsupported bits/sample");
        }

        private int bytesize() {
            return this.lengthInByte();
        }

        public DoubleArray[] getDoubleArrayWaveform() {
            int n;
            short[] sArray = this.getWaveform();
            FmtChunk fmtChunk = WAVXMLWrapper.this.getFmtChunk();
            int n2 = fmtChunk.channels();
            int n3 = sArray.length / n2;
            DoubleArray[] doubleArrayArray = new DoubleArray[n2];
            for (n = 0; n < n2; ++n) {
                doubleArrayArray[n] = factory.createArray(n3);
            }
            for (n = 0; n < n3; ++n) {
                for (int i = 0; i < n2; ++i) {
                    doubleArrayArray[i].set(n, (double)(sArray[n * n2 + i] - this.getZeroValue()) / Math.pow(2.0, fmtChunk.bitsPerSample()));
                }
            }
            return doubleArrayArray;
        }
    }

    public class DataChunk
    extends NodeInterface {
        private AudioData data;

        private DataChunk(Node node) {
            super(node);
            this.data = new AudioData(this.getChildByTagName("audio-data"));
        }

        protected String getSupportedNodeName() {
            return "data-chunk";
        }

        public AudioData getAudioData() {
            return this.data;
        }

        private int bytesize() {
            return this.data.bytesize();
        }

        private void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeBytes("data");
            byte[] byArray = this.data.getByteArray();
            dataOutputStream.write(byArray, 0, byArray.length);
        }
    }

    public class FmtChunk
    extends NodeInterface {
        private int format;
        private int channels;
        private int sampleRate;
        private int byteRate;
        private int blockAlign;
        private int bitsPerSample;

        private FmtChunk(Node node) {
            super(node);
            NodeList nodeList = this.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                String string = node2.getNodeName();
                String string2 = FmtChunk.getText(node2);
                if (string.equals("format")) {
                    this.format = Integer.parseInt(string2);
                    continue;
                }
                if (string.equals("channels")) {
                    this.channels = Integer.parseInt(string2);
                    continue;
                }
                if (string.equals("sample-rate")) {
                    this.sampleRate = Integer.parseInt(string2);
                    continue;
                }
                if (string.equals("byte-rate")) {
                    this.byteRate = Integer.parseInt(string2);
                    continue;
                }
                if (string.equals("block-align")) {
                    this.blockAlign = Integer.parseInt(string2);
                    continue;
                }
                if (!string.equals("bits-per-sample")) continue;
                this.bitsPerSample = Integer.parseInt(string2);
            }
        }

        protected String getSupportedNodeName() {
            return "fmt-chunk";
        }

        public final int format() {
            return this.format;
        }

        public final int channels() {
            return this.channels;
        }

        public final int sampleRate() {
            return this.sampleRate;
        }

        public final int byteRate() {
            return this.byteRate;
        }

        public final int blockAlign() {
            return this.blockAlign;
        }

        public final int bitsPerSample() {
            return this.bitsPerSample;
        }

        public AudioFormat getAudioFormat() {
            return new AudioFormat(this.sampleRate, this.bitsPerSample, this.channels, this.bitsPerSample != 8, false);
        }

        private int bytesize() {
            return 16;
        }

        private void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeBytes("fmt ");
            WAVXMLWrapper.writeUnsignedInt(this.bytesize(), dataOutputStream);
            WAVXMLWrapper.writeUnsignedShort(this.format, dataOutputStream);
            WAVXMLWrapper.writeUnsignedShort(this.channels, dataOutputStream);
            WAVXMLWrapper.writeUnsignedInt(this.sampleRate, dataOutputStream);
            WAVXMLWrapper.writeUnsignedInt(this.byteRate, dataOutputStream);
            WAVXMLWrapper.writeUnsignedShort(this.blockAlign, dataOutputStream);
            WAVXMLWrapper.writeUnsignedShort(this.bitsPerSample, dataOutputStream);
        }
    }
}

