/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.http;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import twitter4j.internal.http.HttpClient;
import twitter4j.internal.http.HttpClientConfiguration;
import twitter4j.internal.logging.Logger;

public final class HttpClientFactory {
    private static final Constructor HTTP_CLIENT_CONSTRUCTOR;
    private static final Logger logger;

    public static HttpClient getInstance(HttpClientConfiguration conf) {
        try {
            return (HttpClient)HTTP_CLIENT_CONSTRUCTOR.newInstance(conf);
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        logger = Logger.getLogger(HttpClientFactory.class);
        Class<?> clazz = null;
        try {
            clazz = Class.forName("twitter4j.internal.http.alternative.HttpClientImpl");
        }
        catch (ClassNotFoundException ignore) {
            // empty catch block
        }
        if (null == clazz) {
            try {
                clazz = Class.forName("twitter4j.internal.http.HttpClientImpl");
            }
            catch (ClassNotFoundException cnfe) {
                throw new AssertionError((Object)cnfe);
            }
        }
        logger.info("Use " + clazz.getName() + " as HttpClient implementation.");
        try {
            HTTP_CLIENT_CONSTRUCTOR = clazz.getConstructor(HttpClientConfiguration.class);
        }
        catch (NoSuchMethodException nsme) {
            throw new AssertionError((Object)nsme);
        }
    }
}

