/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import twitter4j.Twitter;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationContext;
import twitter4j.http.AccessToken;
import twitter4j.http.Authorization;
import twitter4j.http.AuthorizationFactory;
import twitter4j.http.BasicAuthorization;
import twitter4j.http.OAuthAuthorization;

public final class TwitterFactory
implements Serializable {
    private static final long serialVersionUID = 5193900138477709155L;
    private final Configuration conf;

    public TwitterFactory() {
        this(ConfigurationContext.getInstance());
    }

    public TwitterFactory(Configuration conf) {
        if (conf == null) {
            throw new NullPointerException("configuration cannot be null");
        }
        this.conf = conf;
    }

    public TwitterFactory(String configTreePath) {
        this(ConfigurationContext.getInstance(configTreePath));
    }

    public Twitter getInstance() {
        return this.getInstance(this.conf, AuthorizationFactory.getInstance(this.conf, true));
    }

    public Twitter getInstance(Authorization auth) {
        return this.getInstance(this.conf, auth);
    }

    public Twitter getInstance(String screenName, String password) {
        return this.getInstance(new BasicAuthorization(screenName, password));
    }

    public Twitter getOAuthAuthorizedInstance(String consumerKey, String consumerSecret) {
        if (null == consumerKey && null == consumerSecret) {
            throw new IllegalStateException("Consumer key and Consumer secret not supplied.");
        }
        OAuthAuthorization oauth = new OAuthAuthorization(this.conf, consumerKey, consumerSecret);
        return this.getInstance(oauth);
    }

    public Twitter getOAuthAuthorizedInstance(String consumerKey, String consumerSecret, AccessToken accessToken) {
        if (null == consumerKey && null == consumerSecret) {
            throw new IllegalStateException("Consumer key and Consumer secret not supplied.");
        }
        OAuthAuthorization oauth = new OAuthAuthorization(this.conf, consumerKey, consumerSecret);
        oauth.setOAuthAccessToken(accessToken);
        return this.getInstance(oauth);
    }

    public Twitter getOAuthAuthorizedInstance(AccessToken accessToken) {
        String consumerKey = this.conf.getOAuthConsumerKey();
        String consumerSecret = this.conf.getOAuthConsumerSecret();
        if (null == consumerKey && null == consumerSecret) {
            throw new IllegalStateException("Consumer key and Consumer secret not supplied.");
        }
        OAuthAuthorization oauth = new OAuthAuthorization(this.conf, consumerKey, consumerSecret, accessToken);
        return this.getInstance(oauth);
    }

    private Twitter getInstance(Configuration conf, Authorization auth) {
        return new Twitter(conf, auth);
    }
}

