/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.BasePreparedQuery;
import com.google.appengine.api.datastore.CompositeIndexManager;
import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.DatastoreNeedIndexException;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.DatastoreServiceImpl;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QueryResultIterator;
import com.google.appengine.api.datastore.QueryResultIteratorImpl;
import com.google.appengine.api.datastore.QueryResultList;
import com.google.appengine.api.datastore.QueryResultListImpl;
import com.google.appengine.api.datastore.QueryResultsSourceImpl;
import com.google.appengine.api.datastore.QueryTranslator;
import com.google.appengine.api.datastore.ReadPolicy;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionImpl;
import com.google.apphosting.api.ApiBasePb;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PreparedQueryImpl
extends BasePreparedQuery {
    private final DatastoreServiceConfig datastoreServiceConfig;
    private final ApiProxy.ApiConfig apiConfig;
    private final Query query;
    private final Transaction txn;

    public PreparedQueryImpl(ApiProxy.ApiConfig apiConfig, DatastoreServiceConfig datastoreServiceConfig, Query query, Transaction txn) {
        this.apiConfig = apiConfig;
        this.datastoreServiceConfig = datastoreServiceConfig;
        this.query = query;
        this.txn = txn;
        if (!(query.getKind() != null || query.getFilterPredicates().isEmpty() && query.getSortPredicates().isEmpty())) {
            throw new IllegalArgumentException("Kind is required for filters and sort orders.");
        }
        if (txn != null && query.getAncestor() == null) {
            throw new IllegalArgumentException("Only ancestor queries are allowed inside transactions.");
        }
        TransactionImpl.ensureTxnActive(txn);
    }

    private int makeAsListFetchOptions(FetchOptions override) {
        int maximumSize;
        int n = maximumSize = override.getLimit() != null ? override.getLimit() : Integer.MAX_VALUE;
        if (override.getPrefetchSize() == null) {
            override.prefetchSize(maximumSize);
        }
        return maximumSize;
    }

    @Override
    public List<Entity> asList(FetchOptions fetchOptions) {
        FetchOptions override = new FetchOptions(fetchOptions);
        int numRequested = this.makeAsListFetchOptions(override);
        return this.runQuery(this.query, override).nextList(numRequested);
    }

    @Override
    public QueryResultList<Entity> asQueryResultList(FetchOptions fetchOptions) {
        FetchOptions override = new FetchOptions(fetchOptions);
        int numRequested = this.makeAsListFetchOptions(override);
        if (override.getCompile() == null) {
            override.compile(true);
        }
        QueryResultIteratorImpl itr = this.runQuery(this.query, override.compile(true));
        return new QueryResultListImpl<Entity>(itr.nextList(numRequested), itr.getCursor());
    }

    @Override
    public Iterator<Entity> asIterator(FetchOptions fetchOptions) {
        return this.runQuery(this.query, fetchOptions);
    }

    @Override
    public QueryResultIterator<Entity> asQueryResultIterator(FetchOptions fetchOptions) {
        if (fetchOptions.getCompile() == null) {
            fetchOptions = new FetchOptions(fetchOptions).compile(true);
        }
        return this.runQuery(this.query, fetchOptions);
    }

    @Override
    public Entity asSingleEntity() throws PreparedQuery.TooManyResultsException {
        List<Entity> entities = this.asList(FetchOptions.Builder.withLimit(2));
        if (entities.isEmpty()) {
            return null;
        }
        if (entities.size() != 1) {
            throw new PreparedQuery.TooManyResultsException();
        }
        return entities.get(0);
    }

    @Override
    public int countEntities() {
        DatastorePb.Query queryProto = this.convertToPb(this.query, FetchOptions.Builder.withDefaults());
        ApiBasePb.Integer64Proto resp = new ApiBasePb.Integer64Proto();
        if (this.datastoreServiceConfig.getReadPolicy().getConsistency() == ReadPolicy.Consistency.EVENTUAL) {
            queryProto.setFailoverMs(-1L);
        }
        DatastoreApiHelper.makeSyncCall(this.apiConfig, "Count", queryProto, resp);
        return (int)resp.getValue();
    }

    private QueryResultIteratorImpl runQuery(Query q, FetchOptions fetchOptions) {
        DatastorePb.Query queryProto = this.convertToPb(q, fetchOptions);
        if (this.datastoreServiceConfig.getReadPolicy().getConsistency() == ReadPolicy.Consistency.EVENTUAL) {
            queryProto.setFailoverMs(-1L);
        }
        DatastorePb.QueryResult result = new DatastorePb.QueryResult();
        try {
            DatastoreApiHelper.makeSyncCall(this.apiConfig, "RunQuery", queryProto, result);
        }
        catch (DatastoreNeedIndexException e) {
            this.addMissingIndexData(queryProto, e);
            throw e;
        }
        QueryResultsSourceImpl src = new QueryResultsSourceImpl(this.apiConfig, fetchOptions, this.txn);
        List<Entity> prefetchedEntities = src.loadFromPb(result);
        return new QueryResultIteratorImpl(this, prefetchedEntities, src, fetchOptions, this.txn);
    }

    private void addMissingIndexData(DatastorePb.Query queryProto, DatastoreNeedIndexException e) {
        CompositeIndexManager mgr = new CompositeIndexManager();
        CompositeIndexManager.IndexComponentsOnlyQuery indexQuery = new CompositeIndexManager.IndexComponentsOnlyQuery(queryProto);
        OnestoreEntity.Index index = mgr.compositeIndexForQuery(indexQuery);
        if (index != null) {
            String xml = mgr.generateXmlForIndex(index, CompositeIndexManager.IndexSource.manual);
            e.setMissingIndexDefinitionXml(xml);
        }
    }

    private DatastorePb.Query convertToPb(Query q, FetchOptions fetchOptions) {
        DatastorePb.Query queryProto = QueryTranslator.convertToPb(q, fetchOptions);
        if (this.txn != null) {
            TransactionImpl.ensureTxnActive(this.txn);
            queryProto.setTransaction(DatastoreServiceImpl.localTxnToRemoteTxn(this.txn));
        }
        return queryProto;
    }

    public String toString() {
        return this.query.toString() + (this.txn != null ? " IN " + this.txn : "");
    }
}

