/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.javafx.application;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.CountDownLatch;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.util.Duration;

public class FxApplicationThread {
    public static boolean isFxApplicationThread() {
        return Platform.isFxApplicationThread();
    }

    public static void runLater(Runnable runnable) {
        Platform.runLater((Runnable)runnable);
    }

    public static void runLater(long delayMillis, Runnable runnable) {
        FxApplicationThread.runLater(Duration.millis((double)delayMillis), runnable);
    }

    public static void runLater(Duration delay, Runnable runnable) {
        if (delay.lessThanOrEqualTo(Duration.ZERO)) {
            delay = Duration.ONE;
        }
        new Timeline(new KeyFrame[]{new KeyFrame(delay, onFinished -> runnable.run(), new KeyValue[0])}).play();
    }

    public static void runAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        if (Platform.isFxApplicationThread()) {
            throw new Error("Cannot call runAndWait from the FX Application Thread");
        }
        Throwable[] throwable = new Throwable[1];
        CountDownLatch latch = new CountDownLatch(1);
        Platform.runLater(() -> {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                throwable[0] = t;
            }
            finally {
                latch.countDown();
            }
        });
        latch.await();
        if (throwable[0] != null) {
            throw new InvocationTargetException(throwable[0]);
        }
    }
}

