/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.json.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.text.ParseException;
import net.osdn.util.json.jackson.converter.AbstractConverter;

public class Deserializer<T>
extends JsonDeserializer<T> {
    private AbstractConverter<T> converter;

    public Deserializer(AbstractConverter<T> converter) {
        this.converter = converter;
    }

    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken token = p.getCurrentToken();
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        if (token != JsonToken.VALUE_STRING) {
            throw ctxt.wrongTokenException(p, token, "");
        }
        String str = p.getText().trim();
        try {
            return this.converter.fromString(str);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Failed to parse value '" + str + "': " + e.getMessage());
        }
    }
}

