/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.type.builtin;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import jp.bitmeister.asn1.annotation.ASN1BuiltIn;
import jp.bitmeister.asn1.annotation.ASN1Identifier;
import jp.bitmeister.asn1.annotation.ASN1NamedBit;
import jp.bitmeister.asn1.annotation.ASN1Tag;
import jp.bitmeister.asn1.exception.ASN1IllegalArgument;
import jp.bitmeister.asn1.exception.ASN1IllegalDefinition;
import jp.bitmeister.asn1.exception.ASN1RuntimeException;
import jp.bitmeister.asn1.processor.ASN1Visitor;
import jp.bitmeister.asn1.type.ASN1TagClass;
import jp.bitmeister.asn1.type.ASN1TagMode;
import jp.bitmeister.asn1.type.Concatenatable;
import jp.bitmeister.asn1.type.PrimitiveType;
import jp.bitmeister.asn1.type.SizeCountable;
import jp.bitmeister.asn1.value.StringItem;

@ASN1BuiltIn
@ASN1Identifier(value="BIT STRING")
@ASN1Tag(tagClass=ASN1TagClass.UNIVERSAL, value=3, tagMode=ASN1TagMode.IMPLICIT)
public class BIT_STRING
extends PrimitiveType<boolean[]>
implements Concatenatable<BIT_STRING>,
SizeCountable {
    private static final Map<Class<? extends BIT_STRING>, Map<Integer, String>> NAMED_BIT_MAP = new HashMap<Class<? extends BIT_STRING>, Map<Integer, String>>();

    static {
        NAMED_BIT_MAP.put(BIT_STRING.class, new HashMap());
    }

    private static Map<Integer, String> getNamedBitMap(Class<? extends BIT_STRING> type) {
        if (NAMED_BIT_MAP.containsKey(type)) {
            return NAMED_BIT_MAP.get(type);
        }
        HashMap<Integer, String> map = new HashMap();
        Field[] fieldArray = type.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (f.isAnnotationPresent(ASN1NamedBit.class)) {
                Integer value;
                String fieldId;
                int modifier = 25;
                ASN1Identifier id = f.getAnnotation(ASN1Identifier.class);
                String string = fieldId = id != null ? id.value() : f.getName();
                if ((f.getModifiers() & 0x19) != 25) {
                    ASN1IllegalDefinition ex = new ASN1IllegalDefinition();
                    ex.setMessage("A named bit must be a public static final field.", null, type, fieldId, null);
                    throw ex;
                }
                if (f.getType() == Integer.TYPE) {
                    try {
                        value = f.getInt(null);
                    }
                    catch (Exception e) {
                        ASN1RuntimeException ex = new ASN1RuntimeException();
                        ex.setMessage("Failed to retrieve the value from the field.", e, type, fieldId, null);
                        throw ex;
                    }
                    if (value < 0) {
                        ASN1IllegalDefinition ex = new ASN1IllegalDefinition();
                        ex.setMessage("A value of named bit must be a non-negative value.", null, type, fieldId, null);
                        throw ex;
                    }
                } else {
                    ASN1IllegalDefinition ex = new ASN1IllegalDefinition();
                    ex.setMessage("A named bit must be an 'int' field.", null, type, fieldId, null);
                    throw ex;
                }
                if (map.containsKey(value)) {
                    ASN1RuntimeException ex = new ASN1RuntimeException();
                    ex.setMessage("A value of named bit shall be distinct from all other named bits in the type.", null, type, fieldId, null);
                    throw ex;
                }
                map.put(value, fieldId);
            }
            ++n2;
        }
        Class<? extends BIT_STRING> parent = type.getSuperclass();
        if (parent != BIT_STRING.class) {
            if (!map.isEmpty()) {
                ASN1IllegalDefinition ex = new ASN1IllegalDefinition();
                ex.setMessage("A class that does not extend 'BIT_STRING' directly, can not have own named bits.", null, type, null, null);
                throw ex;
            }
            map = BIT_STRING.getNamedBitMap(parent);
        }
        NAMED_BIT_MAP.put(type, map);
        return map;
    }

    public BIT_STRING() {
        this.set(new boolean[0]);
    }

    public BIT_STRING(boolean ... array) {
        this.set(array);
    }

    public BIT_STRING(StringItem item) {
        this.set(item);
    }

    public BIT_STRING(int ... indexes) {
        int[] nArray = indexes;
        int n = indexes.length;
        int n2 = 0;
        while (n2 < n) {
            int e = nArray[n2];
            this.set(e);
            ++n2;
        }
    }

    @Override
    public void set(StringItem item) {
        this.set(item.toBinArray());
    }

    @Override
    public void set(int index) {
        this.expand(index);
        ((boolean[])this.value())[index] = true;
    }

    public void unset(int index) {
        this.expand(index);
        ((boolean[])this.value())[index] = false;
    }

    public void contract() {
        int index = this.size();
        --index;
        while (index >= 0) {
            if (((boolean[])this.value())[index]) break;
            --index;
        }
        if (index + 1 != this.size()) {
            boolean[] newValue = new boolean[index + 1];
            System.arraycopy(this.value(), 0, newValue, 0, newValue.length);
            this.set(newValue);
        }
    }

    public boolean bit(int index) {
        if (index < this.size()) {
            return ((boolean[])this.value())[index];
        }
        return false;
    }

    public boolean hasNamedBits() {
        return !BIT_STRING.getNamedBitMap(this.getClass()).isEmpty();
    }

    public String nameOfBit(int index) {
        return BIT_STRING.getNamedBitMap(this.getClass()).get(index);
    }

    private void expand(int index) {
        if (this.size() <= index) {
            boolean[] newValue = new boolean[index + 1];
            System.arraycopy(this.value(), 0, newValue, 0, this.size());
            this.set(newValue);
        }
    }

    @Override
    public void concatenate(BIT_STRING data) {
        if (data == null) {
            return;
        }
        if (!this.getClass().equals(data.getClass())) {
            ASN1IllegalArgument ex = new ASN1IllegalArgument();
            ex.setMessage("The type '" + data.specification().identifier() + "' of the data to be concatenated is not the same type of this data.", null, this.getClass(), null, null);
            throw ex;
        }
        if (data.hasValue()) {
            if (!this.hasValue()) {
                this.set((boolean[])data.value());
            } else {
                boolean[] newValue = new boolean[((boolean[])this.value()).length + ((boolean[])data.value()).length];
                System.arraycopy(this.value(), 0, newValue, 0, ((boolean[])this.value()).length);
                System.arraycopy(data.value(), 0, newValue, ((boolean[])this.value()).length, ((boolean[])data.value()).length);
                this.set(newValue);
            }
        }
    }

    @Override
    public int size() {
        return ((boolean[])this.value()).length;
    }

    @Override
    protected boolean[] cloneValue() {
        return (boolean[])((boolean[])this.value()).clone();
    }

    @Override
    public boolean valueEquals(Object other) {
        if (other instanceof BIT_STRING) {
            boolean[] otherValue = (boolean[])((BIT_STRING)other).value();
            if (this.value() != null) {
                return Arrays.equals((boolean[])this.value(), otherValue);
            }
            return otherValue == null;
        }
        return false;
    }

    @Override
    public <R, E extends Throwable> R accept(ASN1Visitor<R, E> visitor) throws E {
        return visitor.visit(this);
    }
}

