/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.type;

import java.util.HashMap;
import java.util.Map;
import jp.bitmeister.asn1.annotation.ASN1Anonymous;
import jp.bitmeister.asn1.annotation.ASN1BuiltIn;
import jp.bitmeister.asn1.annotation.ASN1Identifier;
import jp.bitmeister.asn1.annotation.ASN1ModuleRef;
import jp.bitmeister.asn1.annotation.ASN1Tag;
import jp.bitmeister.asn1.exception.ASN1IllegalDefinition;
import jp.bitmeister.asn1.type.ASN1Module;
import jp.bitmeister.asn1.type.ASN1TagClass;
import jp.bitmeister.asn1.type.ASN1TagDefault;
import jp.bitmeister.asn1.type.ASN1TagValue;
import jp.bitmeister.asn1.type.ASN1Type;
import jp.bitmeister.asn1.type.BuiltInModule;

public class TypeSpecification {
    private static final Map<Class<? extends ASN1Type>, TypeSpecification> TYPE_SPECIFICATIONS = new HashMap<Class<? extends ASN1Type>, TypeSpecification>();
    private Class<? extends ASN1Module> module;
    private String identifier;
    private ASN1TagValue tag;
    private TypeSpecification reference;

    static TypeSpecification getSpecification(Class<? extends ASN1Type> type) {
        if (TYPE_SPECIFICATIONS.containsKey(type)) {
            return TYPE_SPECIFICATIONS.get(type);
        }
        TypeSpecification specification = new TypeSpecification();
        if (type.isAnnotationPresent(ASN1BuiltIn.class)) {
            specification.module = BuiltInModule.class;
        } else if (type.isAnnotationPresent(ASN1ModuleRef.class)) {
            specification.module = type.getAnnotation(ASN1ModuleRef.class).value();
        } else if (type.isMemberClass()) {
            Class<?> enclosure = type.getDeclaringClass();
            if (ASN1Module.class.isAssignableFrom(enclosure)) {
                Class<?> module = enclosure;
                specification.module = module;
            }
            if (ASN1Type.class.isAssignableFrom(enclosure)) {
                Class<?> enclosingType = enclosure;
                specification.module = TypeSpecification.getSpecification(enclosingType).module;
            }
        }
        if (specification.module == null) {
            ASN1IllegalDefinition ex = new ASN1IllegalDefinition();
            ex.setMessage("No ASN.1 module reference found for this type.", null, type, null, null);
            throw ex;
        }
        if (!type.isAnnotationPresent(ASN1BuiltIn.class)) {
            try {
                Class<? extends ASN1Type> referenceType = type.getSuperclass();
                specification.reference = TypeSpecification.getSpecification(referenceType);
            }
            catch (ClassCastException e) {
                ASN1IllegalDefinition ex = new ASN1IllegalDefinition();
                ex.setMessage("Failed to cast the class to ASN1Type.", e, type, null, null);
                throw ex;
            }
        }
        if (!type.isAnnotationPresent(ASN1Anonymous.class)) {
            ASN1Identifier id = type.getAnnotation(ASN1Identifier.class);
            specification.identifier = id != null ? id.value() : type.getSimpleName();
        }
        if (type.isAnnotationPresent(ASN1Tag.class)) {
            specification.tag = new ASN1TagValue(type, specification.module);
        }
        TYPE_SPECIFICATIONS.put(type, specification);
        return specification;
    }

    private TypeSpecification() {
    }

    public ASN1TagDefault tagDefault() {
        return ASN1Module.tagDefault(this.module);
    }

    public boolean hasIdentifier() {
        return this.identifier != null;
    }

    public String identifier() {
        if (!this.hasIdentifier()) {
            return this.reference.identifier();
        }
        return this.identifier;
    }

    public String fullIdentifier() {
        if (this.module != BuiltInModule.class) {
            return String.valueOf(ASN1Module.identifier(this.module)) + "." + this.identifier();
        }
        return this.identifier();
    }

    public boolean tagged() {
        if (this.tag != null) {
            return true;
        }
        if (this.reference != null) {
            return this.reference.tagged();
        }
        return false;
    }

    public ASN1TagValue tag() {
        return this.tag;
    }

    public boolean matches(ASN1TagClass tagClass, int tagNumber) {
        if (this.tag == null) {
            return this.reference.matches(tagClass, tagNumber);
        }
        return this.tag.tagClass() == tagClass && this.tag.tagNumber() == tagNumber;
    }

    public TypeSpecification reference() {
        return this.reference;
    }
}

