/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.type;

import java.lang.reflect.Field;
import jp.bitmeister.asn1.annotation.ASN1Identifier;
import jp.bitmeister.asn1.annotation.ASN1Tag;
import jp.bitmeister.asn1.exception.ASN1IllegalArgument;
import jp.bitmeister.asn1.exception.ASN1IllegalDefinition;
import jp.bitmeister.asn1.type.ASN1TagClass;
import jp.bitmeister.asn1.type.ASN1TagValue;
import jp.bitmeister.asn1.type.ASN1Type;
import jp.bitmeister.asn1.type.StructuredType;
import jp.bitmeister.asn1.type.TypeSpecification;

public class NamedTypeSpecification
implements Comparable<NamedTypeSpecification> {
    private Field field;
    private String identifier;
    private ASN1TagValue tag;
    private int order;

    NamedTypeSpecification(int order, Field field) {
        this.identifier = field.isAnnotationPresent(ASN1Identifier.class) ? field.getAnnotation(ASN1Identifier.class).value() : field.getName();
        this.field = field;
        int modifier = 25;
        if (!ASN1Type.class.isAssignableFrom(field.getType())) {
            ASN1IllegalDefinition ex = new ASN1IllegalDefinition();
            ex.setMessage("An element of structured type must be a sub-class of ASN1Type.", null, this.enclosingType(), this.identifier, null);
            throw ex;
        }
        if ((field.getModifiers() & 0x19) != 1) {
            ASN1IllegalDefinition ex = new ASN1IllegalDefinition();
            ex.setMessage("An element of structured type must be a public mutable instance field.", null, this.enclosingType(), this.identifier, null);
            throw ex;
        }
        if (field.isAnnotationPresent(ASN1Tag.class)) {
            this.tag = new ASN1TagValue(this);
        }
        this.order = order;
    }

    public String identifier() {
        return this.identifier;
    }

    public ASN1TagValue tag() {
        return this.tag;
    }

    Field field() {
        return this.field;
    }

    public boolean isSameType(NamedTypeSpecification obj) {
        return this.field.getType().equals(obj.field.getType());
    }

    public boolean matches(ASN1TagClass tagClass, int tagNumber) {
        if (this.tag != null) {
            return tagClass == this.tag.tagClass() && tagNumber == this.tag.tagNumber();
        }
        TypeSpecification typeSpec = TypeSpecification.getSpecification(this.field.getType());
        if (typeSpec.tagged()) {
            return typeSpec.matches(tagClass, tagNumber);
        }
        return this.instantiate().matches(tagClass, tagNumber);
    }

    public ASN1Type instantiate() {
        return ASN1Type.instantiate(this.field.getType());
    }

    Class<? extends ASN1Type> type() {
        return this.field.getType();
    }

    Class<? extends ASN1Type> enclosingType() {
        return this.field.getDeclaringClass();
    }

    void generateAutomaticTag(int order) {
        this.tag = new ASN1TagValue(order, this.type());
    }

    ASN1Type retrieve(StructuredType enclosure) {
        try {
            return (ASN1Type)this.field.get(enclosure);
        }
        catch (IllegalAccessException e) {
            ASN1IllegalArgument ex = new ASN1IllegalArgument();
            ex.setMessage("Failed to retreave value from the field. The field might be inaccessible.", e, enclosure.getClass(), this.identifier, null);
            throw ex;
        }
    }

    void assign(StructuredType enclosure, ASN1Type data) {
        if (data != null && !this.field.getType().equals(data.getClass())) {
            ASN1IllegalArgument ex = new ASN1IllegalArgument();
            ex.setMessage("The type '" + data.specification().identifier() + "' of the data to be assigned is not the same type of this element.", null, enclosure.getClass(), this.identifier, null);
            throw ex;
        }
        try {
            this.field.set(enclosure, data);
        }
        catch (IllegalAccessException e) {
            ASN1IllegalArgument ex = new ASN1IllegalArgument();
            ex.setMessage("Failed to assign value to the field. The field might be inaccessible.", e, enclosure.getClass(), this.identifier, null);
            throw ex;
        }
    }

    @Override
    public int compareTo(NamedTypeSpecification compared) {
        return this.order - compared.order;
    }
}

