/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.type;

import java.util.Collection;
import jp.bitmeister.asn1.type.ASN1Type;
import jp.bitmeister.asn1.type.SizeCountable;
import jp.bitmeister.asn1.type.TypeSpecification;

public abstract class CollectionType<T extends ASN1Type>
extends ASN1Type
implements SizeCountable {
    private Class<T> componentType;
    private Collection<T> collection;

    protected CollectionType(Class<T> componentType) {
        this.componentType = componentType;
        this.collection = this.newCollection();
    }

    public Collection<T> collection() {
        return this.collection;
    }

    public Class<T> componentType() {
        return this.componentType;
    }

    public TypeSpecification componentSpecification() {
        return TypeSpecification.getSpecification(this.componentType);
    }

    protected abstract Collection<T> newCollection();

    @Override
    public int size() {
        return this.collection.size();
    }

    @Override
    public void clear() {
        this.collection = this.newCollection();
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean valueEquals(Object other) {
        if (other instanceof CollectionType) {
            return this.collection.equals(((CollectionType)other).collection);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.collection.hashCode();
    }

    @Override
    public Object clone() {
        CollectionType clone = (CollectionType)ASN1Type.instantiate(this.getClass());
        clone.collection.addAll(this.collection);
        return clone;
    }
}

