/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.type;

import java.util.HashMap;
import java.util.Map;
import jp.bitmeister.asn1.type.ASN1Module;
import jp.bitmeister.asn1.type.ASN1TagClass;
import jp.bitmeister.asn1.type.ASN1Type;
import jp.bitmeister.asn1.type.BuiltInModule;
import jp.bitmeister.asn1.type.UnknownType;

public class ASN1Modules {
    private static ASN1Modules instance = new ASN1Modules();
    private ASN1Module universalModule = new BuiltInModule();
    private Map<Class<? extends ASN1Module>, ASN1Module> definedModules = new HashMap<Class<? extends ASN1Module>, ASN1Module>();

    public static ASN1Type instantiate(ASN1TagClass tagClass, int tagNumber) {
        switch (tagClass) {
            case UNIVERSAL: {
                return ASN1Modules.instance.universalModule.instantiate(tagClass, tagNumber);
            }
            case APPLICATION: 
            case PRIVATE: {
                for (Map.Entry<Class<? extends ASN1Module>, ASN1Module> e : ASN1Modules.instance.definedModules.entrySet()) {
                    ASN1Type data = e.getValue().instantiate(tagClass, tagNumber);
                    if (data == null) continue;
                    return data;
                }
                break;
            }
        }
        return new UnknownType(tagClass, tagNumber);
    }

    public static ASN1Type instanciate(String typeIdentifier) {
        return ASN1Modules.instance.universalModule.instantiate(typeIdentifier);
    }

    public static ASN1Type instantiate(String moduleIdentifier, String typeIdentifier) {
        for (Map.Entry<Class<? extends ASN1Module>, ASN1Module> e : ASN1Modules.instance.definedModules.entrySet()) {
            if (!e.getValue().identifier().equals(moduleIdentifier)) continue;
            return e.getValue().instantiate(typeIdentifier);
        }
        return null;
    }

    public static void using(ASN1Module module) {
        ASN1Modules.instance.definedModules.put(module.getClass(), module);
    }

    private ASN1Modules() {
    }
}

