/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.type;

import java.util.HashMap;
import java.util.Map;
import jp.bitmeister.asn1.annotation.ASN1Identifier;
import jp.bitmeister.asn1.annotation.ASN1ModuleTags;
import jp.bitmeister.asn1.exception.ASN1IllegalDefinition;
import jp.bitmeister.asn1.type.ASN1TagClass;
import jp.bitmeister.asn1.type.ASN1TagDefault;
import jp.bitmeister.asn1.type.ASN1Type;
import jp.bitmeister.asn1.type.TypeSpecification;

public abstract class ASN1Module {
    private String identifier;
    private Map<String, Class<? extends ASN1Type>> identifierMap = new HashMap<String, Class<? extends ASN1Type>>();
    private Map<ASN1TagClass, Map<Integer, Class<? extends ASN1Type>>> tagMap = new HashMap<ASN1TagClass, Map<Integer, Class<? extends ASN1Type>>>();

    static ASN1TagDefault tagDefault(Class<? extends ASN1Module> moduleref) {
        if (moduleref.isAnnotationPresent(ASN1ModuleTags.class)) {
            return moduleref.getAnnotation(ASN1ModuleTags.class).value();
        }
        return ASN1TagDefault.EXPLICIT_TAGS;
    }

    static String identifier(Class<? extends ASN1Module> moduleref) {
        if (moduleref.isAnnotationPresent(ASN1Identifier.class)) {
            return moduleref.getAnnotation(ASN1Identifier.class).value();
        }
        return moduleref.getSimpleName();
    }

    ASN1Module(boolean isUniversal) {
        this.identifier = ASN1Module.identifier(this.getClass());
        if (isUniversal) {
            this.tagMap.put(ASN1TagClass.UNIVERSAL, new HashMap());
        } else {
            this.tagMap.put(ASN1TagClass.APPLICATION, new HashMap());
            this.tagMap.put(ASN1TagClass.PRIVATE, new HashMap());
        }
        Class<?>[] classArray = this.getClass().getDeclaredClasses();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> e = classArray[n2];
            if (ASN1Type.class.isAssignableFrom(e)) {
                Class<?> type = e;
                this.register(type);
            }
            ++n2;
        }
    }

    protected ASN1Module() {
        this(false);
    }

    public String identifier() {
        return this.identifier;
    }

    protected void register(Class<? extends ASN1Type> type) {
        if ((type.getModifiers() & 0x600) != 0) {
            ASN1IllegalDefinition ex = new ASN1IllegalDefinition();
            ex.setMessage("An ASN.1 type class must be instantiatable.", null, type, null, null);
            throw ex;
        }
        if ((type.getModifiers() & 1) == 0) {
            ASN1IllegalDefinition ex = new ASN1IllegalDefinition();
            ex.setMessage("An ASN.1 type class must be a public class", null, type, null, null);
            throw ex;
        }
        if (type.isMemberClass() && (type.getModifiers() & 8) == 0) {
            ASN1IllegalDefinition ex = new ASN1IllegalDefinition();
            ex.setMessage("If an ASN.1 type class is a member class, it must be static.", null, type, null, null);
            throw ex;
        }
        TypeSpecification typeSpec = TypeSpecification.getSpecification(type);
        if (typeSpec.tag() != null) {
            Map<Integer, Class<? extends ASN1Type>> map = this.tagMap.get((Object)typeSpec.tag().tagClass());
            if (map == null) {
                ASN1IllegalDefinition ex = new ASN1IllegalDefinition();
                ex.setMessage("Tag class '" + (Object)((Object)typeSpec.tag().tagClass()) + "'is not allowed to this module.", null, type, null, null);
                throw ex;
            }
            if (map.containsKey(typeSpec.tag().tagNumber())) {
                ASN1IllegalDefinition ex = new ASN1IllegalDefinition();
                ex.setMessage("Tag number '" + typeSpec.tag().tagNumber() + "' is dupulicated.", null, type, null, null);
                throw ex;
            }
            map.put(typeSpec.tag().tagNumber(), type);
        }
        this.identifierMap.put(typeSpec.identifier(), type);
    }

    public ASN1Type instantiate(ASN1TagClass tagClass, int tagNumber) {
        Class<? extends ASN1Type> type = this.tagMap.get((Object)tagClass).get(tagNumber);
        if (type != null) {
            return ASN1Type.instantiate(type);
        }
        return null;
    }

    public ASN1Type instantiate(String typeIdentifier) {
        Class<? extends ASN1Type> type = this.identifierMap.get(typeIdentifier);
        if (type != null) {
            return ASN1Type.instantiate(type);
        }
        return null;
    }
}

