/*
 * Decompiled with CFR 0.152.
 */
package jp.bitmeister.asn1.codec.ber;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import jp.bitmeister.asn1.codec.ASN1Encoder;
import jp.bitmeister.asn1.codec.ber.ConstructedOctets;
import jp.bitmeister.asn1.codec.ber.EncodedOctets;
import jp.bitmeister.asn1.exception.ASN1EncodingException;
import jp.bitmeister.asn1.processor.ASN1Visitor;
import jp.bitmeister.asn1.type.ASN1TagClass;
import jp.bitmeister.asn1.type.ASN1TagMode;
import jp.bitmeister.asn1.type.ASN1TagValue;
import jp.bitmeister.asn1.type.ASN1Type;
import jp.bitmeister.asn1.type.CollectionType;
import jp.bitmeister.asn1.type.ConstructiveType;
import jp.bitmeister.asn1.type.ElementSpecification;
import jp.bitmeister.asn1.type.StringType;
import jp.bitmeister.asn1.type.TimeType;
import jp.bitmeister.asn1.type.TypeSpecification;
import jp.bitmeister.asn1.type.UnknownType;
import jp.bitmeister.asn1.type.builtin.ANY;
import jp.bitmeister.asn1.type.builtin.BIT_STRING;
import jp.bitmeister.asn1.type.builtin.BOOLEAN;
import jp.bitmeister.asn1.type.builtin.CHOICE;
import jp.bitmeister.asn1.type.builtin.ENUMERATED;
import jp.bitmeister.asn1.type.builtin.INTEGER;
import jp.bitmeister.asn1.type.builtin.NULL;
import jp.bitmeister.asn1.type.builtin.OBJECT_IDENTIFIER;
import jp.bitmeister.asn1.type.builtin.OCTET_STRING;
import jp.bitmeister.asn1.type.builtin.REAL;
import jp.bitmeister.asn1.type.builtin.SEQUENCE;
import jp.bitmeister.asn1.type.builtin.SEQUENCE_OF;
import jp.bitmeister.asn1.type.builtin.SET;
import jp.bitmeister.asn1.type.builtin.SET_OF;

public class BerEncoder
implements ASN1Encoder,
ASN1Visitor<EncodedOctets, ASN1EncodingException> {
    private OutputStream out;

    public BerEncoder(OutputStream out) {
        this.out = out;
    }

    @Override
    public int encode(ASN1Type data) throws ASN1EncodingException {
        try {
            data.validate();
            return this.encode(data, null, null).write(this.out);
        }
        catch (ASN1EncodingException e) {
            throw e;
        }
        catch (Exception e) {
            ASN1EncodingException ex = new ASN1EncodingException();
            ex.setMessage("Exception thrown while encoding process.", e, data.getClass(), null, data);
            throw ex;
        }
    }

    EncodedOctets encode(ASN1Type data, ASN1TagValue tag, TypeSpecification typeSpec) throws ASN1EncodingException {
        EncodedOctets octets;
        if (typeSpec == null) {
            typeSpec = data.specification();
        }
        if (tag == null) {
            do {
                tag = typeSpec.tag();
            } while ((typeSpec = typeSpec.reference()) != null && tag == null);
        }
        if (tag != null && tag.tagMode() == ASN1TagMode.EXPLICIT) {
            ConstructedOctets constructed = this.newConstructedOctets();
            constructed.addElement(this.encode(data, null, typeSpec));
            octets = constructed;
        } else {
            octets = data.accept(this);
        }
        if (tag != null) {
            octets.fix(tag.tagClass(), tag.tagNumber());
        }
        return octets;
    }

    @Override
    public EncodedOctets visit(BOOLEAN data) {
        return this.newPrimitiveOctets((Boolean)data.value() != false ? (byte)-1 : 0);
    }

    @Override
    public EncodedOctets visit(INTEGER data) {
        return this.newPrimitiveOctets(((BigInteger)data.value()).toByteArray());
    }

    @Override
    public EncodedOctets visit(ENUMERATED data) {
        return this.visit((INTEGER)data);
    }

    @Override
    public EncodedOctets visit(REAL data) {
        byte[] encoded;
        if ((Double)data.value() == 0.0) {
            encoded = new byte[]{};
        } else if (((Double)data.value()).isInfinite()) {
            encoded = new byte[]{(Double)data.value() == Double.POSITIVE_INFINITY ? (byte)64 : 65};
        } else {
            String str = ((Double)data.value()).toString();
            encoded = new byte[str.length() + 1];
            encoded[0] = str.indexOf("E") < 0 ? 2 : 3;
            System.arraycopy(str.getBytes(), 0, encoded, 1, str.length());
        }
        return this.newPrimitiveOctets(encoded);
    }

    @Override
    public EncodedOctets visit(BIT_STRING data) {
        if (((boolean[])data.value()).length == 0) {
            return this.newPrimitiveOctets(0);
        }
        int mod = ((boolean[])data.value()).length % 8;
        byte[] encoded = new byte[1 + ((boolean[])data.value()).length / 8 + (mod == 0 ? 0 : 1)];
        encoded[0] = (byte)(mod == 0 ? 0 : 8 - mod);
        int index = 1;
        int mask = 128;
        boolean[] blArray = (boolean[])data.value();
        int n = blArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean b = blArray[n2];
            if (b) {
                int n3 = index;
                encoded[n3] = (byte)(encoded[n3] | mask);
            }
            if ((mask >>>= 1) == 0) {
                mask = 128;
                ++index;
            }
            ++n2;
        }
        return this.newPrimitiveOctets(encoded);
    }

    @Override
    public EncodedOctets visit(OCTET_STRING data) throws ASN1EncodingException {
        return this.newPrimitiveOctets((byte[])data.value());
    }

    @Override
    public EncodedOctets visit(NULL data) throws ASN1EncodingException {
        return this.newPrimitiveOctets(new byte[0]);
    }

    @Override
    public EncodedOctets visit(SEQUENCE data) throws ASN1EncodingException {
        return this.processConstructive(data);
    }

    @Override
    public EncodedOctets visit(SEQUENCE_OF<? extends ASN1Type> data) throws ASN1EncodingException {
        return this.processCollection(data);
    }

    @Override
    public ConstructedOctets visit(SET data) throws ASN1EncodingException {
        return this.processConstructive(data);
    }

    @Override
    public ConstructedOctets visit(SET_OF<? extends ASN1Type> data) throws ASN1EncodingException {
        return this.processCollection(data);
    }

    @Override
    public EncodedOctets visit(CHOICE data) throws ASN1EncodingException {
        return this.encode(data.selectedValue(), data.selectedTag(), null);
    }

    @Override
    public EncodedOctets visit(OBJECT_IDENTIFIER data) throws ASN1EncodingException {
        if (((List)data.value()).size() < 2 || (Integer)((List)data.value()).get(0) < 0 || 2 < (Integer)((List)data.value()).get(0) || (Integer)((List)data.value()).get(1) < 0 || 39 < (Integer)((List)data.value()).get(1)) {
            ASN1EncodingException ex = new ASN1EncodingException();
            ex.setMessage("Invalid OBJECT IDENTIFIER value.", null, data.getClass(), null, data);
            throw ex;
        }
        int size = 1;
        int i = 2;
        while (i < ((List)data.value()).size()) {
            if ((Integer)((List)data.value()).get(i) < 0) {
                ASN1EncodingException ex = new ASN1EncodingException();
                ex.setMessage("OBJECT IDENTIFIER value must be a positive number.", null, data.getClass(), null, data);
                throw ex;
            }
            size += this.sizeBy7bits(((Integer)((List)data.value()).get(i)).intValue());
            ++i;
        }
        byte[] encoded = new byte[size];
        encoded[0] = (byte)((Integer)((List)data.value()).get(0) * 40 + (Integer)((List)data.value()).get(1));
        int offset = 1;
        int i2 = 2;
        while (i2 < ((List)data.value()).size()) {
            offset += this.encodeToMutipleOctets(encoded, offset, ((Integer)((List)data.value()).get(i2)).intValue());
            ++i2;
        }
        return this.newPrimitiveOctets(encoded);
    }

    @Override
    public EncodedOctets visit(StringType data) throws ASN1EncodingException {
        return this.newPrimitiveOctets((byte[])data.value());
    }

    @Override
    public EncodedOctets visit(TimeType data) throws ASN1EncodingException {
        return this.newPrimitiveOctets((byte[])data.value());
    }

    @Override
    public EncodedOctets visit(ANY data) throws ASN1EncodingException {
        return this.encode((ASN1Type)data.value(), null, null);
    }

    @Override
    public EncodedOctets visit(UnknownType data) throws ASN1EncodingException {
        EncodedOctets octets = this.newPrimitiveOctets(data.value());
        octets.fix(data.tagClass(), data.tagNumber());
        return octets;
    }

    ConstructedOctets processConstructive(ConstructiveType data) throws ASN1EncodingException {
        ConstructedOctets octets = this.newConstructedOctets();
        ElementSpecification[] elementSpecificationArray = data.getElementTypeList();
        int n = elementSpecificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ElementSpecification e = elementSpecificationArray[n2];
            ASN1Type element = data.getComponent(e);
            if (element != null && element.hasValue()) {
                octets.addElement(this.encode(element, e.tag(), null));
            }
            ++n2;
        }
        return octets;
    }

    ConstructedOctets processCollection(CollectionType<?> data) throws ASN1EncodingException {
        ConstructedOctets octets = this.newConstructedOctets();
        for (ASN1Type e : data.collection()) {
            octets.addElement(this.encode(e, null, null));
        }
        return octets;
    }

    byte[] encodeTag(ASN1TagClass tagClass, int tagNumber, boolean isConstructed) {
        byte leading = 0;
        switch (tagClass) {
            case UNIVERSAL: {
                break;
            }
            case APPLICATION: {
                leading = 64;
                break;
            }
            case CONTEXT_SPECIFIC: {
                leading = -128;
                break;
            }
            case PRIVATE: {
                leading = -64;
            }
        }
        if (isConstructed) {
            leading = (byte)(leading | 0x20);
        }
        if (tagNumber <= 30) {
            leading = (byte)(leading | tagNumber);
            return new byte[]{leading};
        }
        leading = (byte)(leading | 0x1F);
        int size = this.sizeBy7bits(tagNumber);
        byte[] id = new byte[size + 1];
        id[0] = leading;
        this.encodeToMutipleOctets(id, 1, tagNumber);
        return id;
    }

    byte[] encodeLength(int length) {
        if (length <= 127) {
            return new byte[]{(byte)length};
        }
        byte[] value = BigInteger.valueOf(length).toByteArray();
        byte[] encoded = new byte[value.length + 1];
        encoded[0] = (byte)(value.length | 0x80);
        System.arraycopy(value, 0, encoded, 1, value.length);
        return encoded;
    }

    private int encodeToMutipleOctets(byte[] dest, int offset, long value) {
        int lastIndex;
        int size = this.sizeBy7bits(value);
        int index = lastIndex = offset + size - 1;
        while (index >= offset) {
            int n = index;
            dest[n] = (byte)(dest[n] | (byte)(value & 0x7FL));
            if (index != lastIndex) {
                int n2 = index;
                dest[n2] = (byte)(dest[n2] | 0x80);
            }
            value >>= 7;
            --index;
        }
        return size;
    }

    private int sizeBy7bits(long value) {
        int size = 1;
        while ((value >>= 7) > 0L) {
            ++size;
        }
        return size;
    }

    EncodedOctets newPrimitiveOctets(byte ... contents) {
        return new BerPrimitiveOctets(contents);
    }

    ConstructedOctets newConstructedOctets() {
        return new BerConstructedOctets();
    }

    class BerConstructedOctets
    extends BerOctets
    implements ConstructedOctets {
        private List<EncodedOctets> elements;
        private int length;

        BerConstructedOctets() {
            this.elements = new ArrayList<EncodedOctets>();
        }

        @Override
        public void addElement(EncodedOctets element) {
            this.elements.add(element);
            this.length += element.totalLength();
        }

        @Override
        public boolean isConstructed() {
            return true;
        }

        @Override
        public int contentsLength() {
            return this.length;
        }

        @Override
        void writeContents(OutputStream out) throws IOException {
            for (EncodedOctets e : this.elements) {
                e.write(out);
            }
        }
    }

    abstract class BerOctets
    implements EncodedOctets {
        byte[] identifier;
        byte[] length;

        BerOctets() {
        }

        @Override
        public int totalLength() {
            return this.identifier.length + this.length.length + this.contentsLength();
        }

        @Override
        public void fix(ASN1TagClass tagClass, int tagNumber) {
            this.identifier = BerEncoder.this.encodeTag(tagClass, tagNumber, this.isConstructed());
            this.length = BerEncoder.this.encodeLength(this.contentsLength());
        }

        @Override
        public int write(OutputStream out) throws IOException {
            out.write(this.identifier);
            out.write(this.length);
            this.writeContents(out);
            return this.totalLength();
        }

        abstract void writeContents(OutputStream var1) throws IOException;
    }

    class BerPrimitiveOctets
    extends BerOctets {
        private byte[] contents;

        BerPrimitiveOctets(byte ... contents) {
            this.contents = contents;
        }

        @Override
        public boolean isConstructed() {
            return false;
        }

        @Override
        public int contentsLength() {
            return this.contents.length;
        }

        @Override
        void writeContents(OutputStream out) throws IOException {
            out.write(this.contents);
        }
    }
}

