/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.filter.wizards;

import benten.twa.filter.handler.ImportHtmlHandler;
import benten.twa.filter.messages.BentenImportHtmlMessages;
import benten.twa.ui.jobs.WorkflowJob;
import benten.twa.ui.wizards.AbstractWorkflowWizard;

/**
 * 翻訳対象のインポート
 *
 * <pre>
 * 翻訳対象物をプロジェクトにインポートします。
 *   1.  翻訳対象物のファイルをプロジェクトにインポートします。
 *   2.  インポートされた翻訳対象物は、デフォルトではプロジェクト内の [.benten/source] ディレクトリ以下に配置されます。
 *   3.  インポートされた翻訳対象物は、エクスポートの際に利用されます。
 *   4.  インポートされた翻訳対象物は、直接編集しないでください。
 * </pre>
 *
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳対象物－翻訳中間形式変換機能: HTMLインポート機能」に対応します。
 * 
 * @author YAMAMOTO Koji
 */
public class ImportHtmlWizard extends AbstractWorkflowWizard {
	/**
	 * HTMLインポート機能のためのメッセージ。
	 */
	protected static final BentenImportHtmlMessages fMsg = new BentenImportHtmlMessages();

	@Override
	public void addPages() {
		setWindowTitle(fMsg.getWindowTitle());
		addPage(new ImportHtmlWizardPage());
		addPage(new ImportHtmlWizardPage2(getSelection()));
	}

	@Override
	protected void scheduleJob() {
		final WorkflowJob job = new WorkflowJob(fMsg.getJobName());
		job.setStatus(getStatus());
		job.setHandler(new ImportHtmlHandler());
		job.setCompleteMessage(getWindowTitle(), fMsg.getWizardPage3ResultMessage());
		job.schedule();
	}
}
