/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.ui.preference;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;

import benten.ui.preference.BentenPreference.Preference;
import benten.ui.preference.messages.BentenPreferenceInitializerMessages;

/**
 * Benten 設定初期化クラス。
 *
 * <UL>
 * <LI>Benten 全体で使用する設定定義の初期化クラスです。
 * </UL>
 *
 * @author KASHIHARA Shinji
 */
public class BentenPreferenceInitializer extends AbstractPreferenceInitializer {

	/**
	 * Benten 設定初期化のためのメッセージ。
	 */
	protected static final BentenPreferenceInitializerMessages fMsg = new BentenPreferenceInitializerMessages();

	@Override
	public void initializeDefaultPreferences() {
		final IPreferenceStore store = BentenPreference.getStore();

		store.setDefault(Preference.TM_NAME.name(), fMsg.getDefaultTmName());
		store.setDefault(Preference.USE_TMX_DEFAULT.name(), true);
		store.setDefault(Preference.IGNORE_WHITESPACE_TM_REFERENCE.name(), true);
		store.setDefault(Preference.IGNORE_WHITESPACE_TMX_EXTRACT.name(), true);

		store.setDefault(Preference.GLOSSARY_NAME.name(), fMsg.getDefaultGlossaryName());
		store.setDefault(Preference.USE_TSV_DEFAULT.name(), true);
	}
}
