/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.ui.fields;

import java.io.File;

import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

/**
 * ファイルを選択するためのテキスト・フィールド。
 *
 * <UL>
 * <LI>ファイル・システムのファイルを選択するためのフィールド・クラスです。
 * </UL>
 *
 * @author KASHIHARA Shinji
 */
@SuppressWarnings("restriction")
public class FileTextField extends AbstractBrowseTextField {

	/**
	 * コンストラクター。
	 * @param parent 親コンポジット
	 * @param labelText ラベル・テキスト
	 * @param extensions 拡張子
	 */
	public FileTextField(final Composite parent, final String labelText, final String... extensions) {
		super(parent, labelText, extensions);
	}

	@Override
	protected void openDialog() {
		final FileDialog dialog = new FileDialog(text.getShell());
		dialog.setFilterExtensions(extensions);
		dialog.setFilterPath(getDefaultPath());
		final String selected = dialog.open();
		if (selected != null) {
			text.setText(selected);
		}
	}

	/**
	 * デフォルト・パスの取得。
	 * @return デフォルト・パス
	 */
	protected String getDefaultPath() {
		String path = text.getText() == null ? "" : text.getText().trim(); //$NON-NLS-1$
		if (path.length() == 0) {
			final String prev = previousInputMap.get(labelText);
			path = (prev == null) ? "" : prev; //$NON-NLS-1$
		}
		if (path.length() == 0) {
			return IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getLocation().toOSString();
		} else {
			if (new File(path).exists()) {
				path = resolvePath(path);
				return new Path(path).toOSString();
			}
		}
		return ""; //$NON-NLS-1$
	}
}
