/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

import benten.ui.UiPlugin;
import benten.ui.views.CopySupportTableView;

/**
 * 基底コピー・アクション。
 *
 * <UL>
 * <LI>選択された文字をコピーするアクションの基底クラスです。
 * </UL>
 *
 * @author YAMAMOTO Koji
 * @author KASHIHARA Shinji
 */
public abstract class AbstractCopyAction extends Action {

	/** コピーをサポートするテーブル・ビュー */
	private final CopySupportTableView view;

	/** クリップボード */
	private Clipboard clipboard;

	/**
	 * コンストラクター。
	 * @param view ビュー
	 * @param text テキスト
	 */
	public AbstractCopyAction(final CopySupportTableView view, final String text) {
		super(text);
		this.view = view;
	}

	@Override
	public void run() {
		final IStructuredSelection selection = (IStructuredSelection) view.getSelection();
		if (selection.size() == 0) {
			return;
		}
		try {
			if (clipboard == null) {
				clipboard = new Clipboard(view.getSite().getShell().getDisplay());
			}
			clipboard.setContents(new Object[] { asText(selection) }, new Transfer[] { TextTransfer.getInstance() });
		} catch (final SWTError e) {
			UiPlugin.getDefault().log(e);
		}
	}

	/**
	 * 選択をテキストとして取得するテンプレート・メソッド。
	 * @param selection 選択
	 * @return 選択テキスト
	 */
	abstract protected String asText(final IStructuredSelection selection);
}
