/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.osgi.framework.BundleContext;

/**
 * Benten UI プラグイン。
 * 
 * <UL>
 * <LI>このプラグインを Eclipse 上で有効化するためのプラグイン・クラスです。
 * </UL>
 * 
 * @author KASHIHARA Shinji
 */
public class UiPlugin extends AbstractBentenUiPlugin {

	/** 共用インスタンス */
	private static UiPlugin plugin;

	@Override
	public void start(final BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
	}

	@Override
	public void stop(final BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	/**
	 * このプラグインの共用インスタンスを取得。
	 * @return このプラグインの共用インスタンス
	 */
	public static UiPlugin getDefault() {
		return plugin;
	}

	//-------------------------------------------------------------------------
	// Benten 全体に提供する UI 関連の static メソッド

	/**
	 * ワークベンチ・ウィンドウを取得。
	 * @return ワークベンチ・ウィンドウ。取得できない場合は null。
	 */
	public static IWorkbenchWindow getWorkbenchWindow() {
		return getDefault().getWorkbench().getActiveWorkbenchWindow();
	}

	/**
	 * ワークベンチ・ウィンドウのシェルを取得。
	 * @return シェル。取得できない場合は null。
	 */
	public static Shell getShell() {
		final IWorkbenchWindow window = getWorkbenchWindow();
		if (window != null) {
			return window.getShell();
		}
		return null;
	}

	/**
	 * アクティブなページを取得。
	 * @return アクティブなページ。取得できない場合は null。
	 */
	public static IWorkbenchPage getActivePage() {
		final IWorkbenchWindow window = getWorkbenchWindow();
		if (window != null) {
			return window.getActivePage();
		}
		return null;
	}

	/**
	 * ダイアログを表示。
	 * @param title タイトル
	 * @param status ステータス
	 * @return 結果
	 */
	public static int openDialog(final String title, final IStatus status) {
		return ErrorDialog.openError(getShell(), title, null, status);
	}

	/**
	 * 可視状態のビューを取得。
	 * @param <T> IViewPart を継承したオブジェクト
	 * @param viewPartClass IViewPart クラス
	 * @return ビュー。取得できない場合は null。
	 */
	@SuppressWarnings("unchecked")
	public static <T extends IViewPart> T getView(Class<T> viewPartClass) {
		final IWorkbenchPage page = getActivePage();
		if (page != null) {
			final IViewReference[] references = page.getViewReferences();
			for (final IViewReference reference : references) {
				final IViewPart view = reference.getView(false);
				if (view != null && view.getClass() == viewPartClass) {
					return (T) view;
				}
			}
		}
		return null;
	}
}
