/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.xliff.dialogs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

import benten.twa.ui.dialogs.AbstractWorkflowDialog;
import benten.twa.xliff.messages.BentenCleanXliffMessages;
import benten.twa.xliff.status.BentenCleanXliffStatus;
import benten.ui.UiStatus;
import benten.ui.UiStatusException;
import benten.ui.fields.ResourceFolderTextField;

/**
 * XLIFF フラグメント・クリーン・ダイアログです。
 *
 * XLIFF フラグメントのクリーン
 *
 * <pre>
 * XLIFF フラグメントをクリーンします。
 *   1.  所定のルールにしたがって、XLIFF をクリーンします。
 * </pre>
 *
 * @author IGA Tosiki
 */
public class CleanXliffDialog extends AbstractWorkflowDialog {

	/**
	 * XLIFF クリーン機能のためのメッセージ。
	 */
	protected static final BentenCleanXliffMessages fMsg = new BentenCleanXliffMessages();

	/** コントロール・コンテナー */
	private final CleanXliffControls controls = new CleanXliffControls();

	/** コントロール・コンテナー・クラス */
	public static class CleanXliffControls {

		/** 対象ディレクトリー・テキスト */
		public ResourceFolderTextField targetDirText;
	}

	/**
	 * コンストラクター。
	 * @param parentShell 親シェル
	 * @param selection 選択
	 */
	public CleanXliffDialog(final Shell parentShell, final IStructuredSelection selection) {
		super(parentShell, selection, fMsg.getWindowTitle());
	}

	@Override
	public void createControls(final Composite composite) {
		composite.setLayout(new GridLayout(3, false));

		controls.targetDirText = new ResourceFolderTextField(composite, fMsg.getDialogCtrlLabelTargetXliffDir());
		controls.targetDirText.addModifyListener(this);
		if (getSelectionResource() != null) {
			controls.targetDirText.setText(getSelectionResource().getFullPath().toString());
		}
	}

	@Override
	public IStatus getResultStatus() {
		final BentenCleanXliffStatus status = new BentenCleanXliffStatus();
		status.setTargetDir(controls.targetDirText.getFile());
		status.setProject(controls.targetDirText.getResource());
		return status;
	}

	@Override
	public IStatus validate() throws UiStatusException {
		validatePath(controls.targetDirText);
		return UiStatus.OK_STATUS;
	}
}
