/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.ui.viewers;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

import benten.cat.ui.CatUiPlugin;

/**
 * 展開状態が保管可能な展開コンポジット。
 * 
 * @author KASHIHARA Shinji
 */
public class PersistenceExpandableComposite extends ExpandableComposite {

	/**
	 * コンストラクター。
	 * @param parent 親コンポジット
	 * @param text テキスト
	 */
	public PersistenceExpandableComposite(final Composite parent, final String text) {
		super(parent, SWT.BORDER, ExpandableComposite.TWISTIE);
		setText(text);
		setForeground(Display.getCurrent().getSystemColor(SWT.COLOR_DARK_GRAY));
		setTitleBarForeground(Display.getCurrent().getSystemColor(SWT.COLOR_DARK_GRAY));
		setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		setLayout(new FillLayout());
	}

	/**
	 * 展開設定のロード。
	 * @param persistenceKey 保管キー
	 */
	public void loadExpandedSetting(final String persistenceKey) {
		final IPreferenceStore store = CatUiPlugin.getDefault().getPreferenceStore();
		setExpanded(store.getBoolean(persistenceKey));
		addExpansionListener(new ExpansionAdapter() {
			@Override
			public void expansionStateChanged(ExpansionEvent e) {
				store.setValue(persistenceKey, e.getState());
			}
		});
	}
}
