/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.ui.internal.tabletree;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.wst.xml.ui.internal.tabletree.IDesignViewer;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLMultiPageEditorPart;

import benten.cat.ui.CatUiPlugin;
import benten.cat.ui.internal.tabletree.messages.XLIFFMultiPageEditorPartMessages;
import benten.cat.ui.viewers.TransUnitViewer;

/**
 * XLIFF マルチ・ページ・エディター・パーツ。
 * <p>
 * ★基本設計「翻訳支援機能: 翻訳中間形式エディター機能: 翻訳中間形式(XLIFF)保存」に対応します。
 *
 * @author KASHIHARA Shinji
 */
@SuppressWarnings("restriction")
public class XLIFFMultiPageEditorPart extends XMLMultiPageEditorPart {

	/**
	 * XLIFF マルチ・ページ・エディター・パーツのためのメッセージ。
	 */
	protected static final XLIFFMultiPageEditorPartMessages fMsg = new XLIFFMultiPageEditorPartMessages();

	/** 翻訳単位ビューアー */
	protected TransUnitViewer fTransUnitViewer;

	/**
	 * 翻訳単位ビューアーの取得。
	 * @return 翻訳単位ビューアー
	 */
	public TransUnitViewer getTransUnitViewer() {
		return fTransUnitViewer;
	}

	@Override
	protected IDesignViewer createDesignPage() {
		fTransUnitViewer = new TransUnitViewer(getContainer(), this);
		return fTransUnitViewer;
	}

	@Override
	protected void createPages() {
		super.createPages();
		final CTabFolder tabFolder = (CTabFolder) getContainer();
		tabFolder.getItem(0).setImage(CatUiPlugin.getDefault().getImage("icons/tabtransunit.gif")); //$NON-NLS-1$
		tabFolder.getItem(1).setImage(CatUiPlugin.getDefault().getImage("icons/tabsource.gif")); //$NON-NLS-1$
	}

	/**
	 * XLIFF の保管。
	 *
	 * <UL>
	 * <LI>その他のジョブが上書きする可能性がありますが、これはジョブ実行中に XLIFF ファイルを編集した利用者の責任とします。
	 * </UL>
	 */
	@Override
	public void doSave(final IProgressMonitor monitor) {
		super.doSave(monitor);
	}
}
