/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.ui;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

/**
 * 翻訳パースペクティブのファクトリー。
 *
 * @author KASHIHARA Shinji
 */
public class TranslationPerspectiveFactory implements IPerspectiveFactory {

	/**
	 * プロジェクト・エクスプローラーの id。
	 */
	private static final String ID_PROJECT_EXPLORER = "org.eclipse.ui.navigator.ProjectExplorer"; //$NON-NLS-1$

	/**
	 * Benten 翻訳ビューの id。
	 */
	private static final String ID_TRANSLATION = "benten.cat.tm.ui.views.TranslationView"; //$NON-NLS-1$

	/**
	 * Benten 用語集ビューの id。
	 */
	private static final String ID_GLOSSARY = "benten.cat.glossary.ui.views.GlossaryView"; //$NON-NLS-1$

	/**
	 * {@inheritDoc}
	 */
	public void createInitialLayout(final IPageLayout layout) {
		defineLayout(layout);
	}

	/**
	 * レイアウトの定義。
	 * @param layout レイアウト
	 */
	private void defineLayout(final IPageLayout layout) {

		final String editorArea = layout.getEditorArea();

		final IFolderLayout bottomLeft = layout
				.createFolder("bottomLeft", IPageLayout.BOTTOM, (float) 0.75, editorArea); //$NON-NLS-1$
		bottomLeft.addView(ID_TRANSLATION);
		bottomLeft.addView(ID_GLOSSARY);

		final IFolderLayout bottomRight = layout.createFolder("bottomRight", IPageLayout.RIGHT, (float) 0.4, //$NON-NLS-1$
				"bottomLeft"); //$NON-NLS-1$
		bottomRight.addView(IPageLayout.ID_PROBLEM_VIEW);

		final IFolderLayout left = layout.createFolder("left", IPageLayout.LEFT, (float) 0.25, editorArea); //$NON-NLS-1$
		left.addView(ID_PROJECT_EXPLORER);
		left.addView(IPageLayout.ID_OUTLINE);
	}
}
