/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.core.model.messages;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * Benten コアの model のためのメッセージ。
 *
 * リソースバンドル定義: [BentenCoreModelMessages]。<BR>
 * このクラスはリソースバンドル定義書から自動生成されたリソースバンドルクラスです。<BR>
 * 既知のロケール<BR>
 * <UL>
 * <LI>en
 * <LI>ja
 * </UL>
 */
public class BentenCoreModelMessages {
    /**
     * リソースバンドルオブジェクト。
     *
     * 内部的に実際に入力を行うリソースバンドルを記憶します。
     */
    private ResourceBundle fResourceBundle;

    /**
     * BentenCoreModelMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenCoreModelMessages]、デフォルトのロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     */
    public BentenCoreModelMessages() {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/core/model/messages/BentenCoreModelMessages");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BentenCoreModelMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenCoreModelMessages]、指定されたロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     */
    public BentenCoreModelMessages(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/core/model/messages/BentenCoreModelMessages", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BentenCoreModelMessagesクラスのコンストラクタ。
     *
     * 基底名[BentenCoreModelMessages]、指定されたロケール、指定されたクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     * @param loader クラスローダの指定
     */
    public BentenCoreModelMessages(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/core/model/messages/BentenCoreModelMessages", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * 内部的に保持しているリソースバンドルオブジェクトを取得します。
     *
     * @return 内部的に保持しているリソースバンドルオブジェクト。
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[BentenCoreModelMessages], key[BentenTmx.Msg.001]
     *
     * [The TMX version &quot;{1}&quot; specified in the TMX file &quot;{0}&quot; is not supported. Only version 1.4 is currently supported.] (en)<br>
     * [TMX ファイル ''{0}'' で指定されている TMX バージョン ''{1}'' はサポートされません。現在サポートされているのは、バージョン 1.4 のみです。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @param arg1 置換文字列{1}を置換する値。java.lang.String型を与えてください。
     * @return key[BentenTmx.Msg.001]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getBentenTmxMsg001(final String arg0, final String arg1) {
        // 初期値として定義書の値を利用します。
        String strFormat = "The TMX version \"{1}\" specified in the TMX file \"{0}\" is not supported. Only version 1.4 is currently supported.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("BentenTmx.Msg.001");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BentenCoreModelMessages], key[BentenXliff.Msg.001]
     *
     * [The XLIFF version &quot;{1}&quot; specified in the XLIFF file &quot;{0}&quot; is not supported. Only version 1.2 is currently supported.] (en)<br>
     * [XLIFF ファイル ''{0}'' で指定されている XLIFF バージョン ''{1}'' はサポートされません。現在サポートされているのは、バージョン 1.2 のみです。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @param arg1 置換文字列{1}を置換する値。java.lang.String型を与えてください。
     * @return key[BentenXliff.Msg.001]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getBentenXliffMsg001(final String arg0, final String arg1) {
        // 初期値として定義書の値を利用します。
        String strFormat = "The XLIFF version \"{1}\" specified in the XLIFF file \"{0}\" is not supported. Only version 1.2 is currently supported.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("BentenXliff.Msg.001");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }
}
