/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.tmx.wizards;

import benten.twa.tmx.handler.ExtractTmxFragmentHandler;
import benten.twa.tmx.messages.BentenExtractTmxFragmentMessages;
import benten.twa.ui.jobs.WorkflowJob;
import benten.twa.ui.wizards.AbstractWorkflowWizard;

/**
 * TMX フラグメントの抽出
 *
 * <pre>
 * XLIFF フラグメントから、TMX フラグメントを抽出します。
 *   1.  XLIFF から翻訳単位を抽出して TMX を作成します。
 * </pre>
 *
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳メモリー断片抽出・マージ機能: TMXフラグメント抽出機能」に対応します。
 * 
 * @author YAMAMOTO Koji
 */
public class ExtractTmxFragmentWizard extends AbstractWorkflowWizard {
	/**
	 * TMXフラグメント抽出機能のためのメッセージ。
	 */
	protected static final BentenExtractTmxFragmentMessages fMsg = new BentenExtractTmxFragmentMessages();

	@Override
	public void addPages() {
		setWindowTitle(fMsg.getWindowTitle());
		addPage(new ExtractTmxFragmentWizardPage());
		addPage(new ExtractTmxFragmentWizardPage2(getSelection()));
	}

	@Override
	protected void scheduleJob() {
		final WorkflowJob job = new WorkflowJob(fMsg.getJobName());
		job.setStatus(getStatus());
		job.setHandler(new ExtractTmxFragmentHandler());
		job.setCompleteMessage(getWindowTitle(), fMsg.getWizardPage3ResultMessage());
		job.schedule();
	}
}
