<?php
ini_set('unserialize_callback_func', '__autoload');
if (!function_exists('__autoload')) {
	function __autoload($className) {
	//	echo 'Include class definition (' . $className . ').' . "\n";
		$classNameArray = explode('_', $className);
		if (count($classNameArray) == 2 && $classNameArray[0] == 'ALP') {
			$autoloadClassLocation = dirname(__FILE__) . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR .
				'classes' . DIRECTORY_SEPARATOR . $classNameArray[1] . '.class.php';
	//		echo $autoloadClassLocation;
			if (file_exists($autoloadClassLocation)) {
				require_once $autoloadClassLocation;
				return;
			}
		}
		
		$classDefinitionLocation = ALP_ClassDefLocMap::getClassDefinitionLocation($className);
	//	echo 'Definition location (' . $className . '): ' . $classDefinitionLocation . "\n";
		if (is_file($classDefinitionLocation)) {
			require_once $classDefinitionLocation;
		}
		else {
			$aowpClassesFolder = realpath(dirname(__FILE__) . DIRECTORY_SEPARATOR .
				'..' . DIRECTORY_SEPARATOR .
				'..' . DIRECTORY_SEPARATOR .
				'..' . DIRECTORY_SEPARATOR .
				'classes');
			if (file_exists($aowpClassesFolder)) {
				$defLocMapGenerator = ALP_DefLocMapGenerator::generateDefLocMap($aowpClassesFolder);
				if ($defLocMapGenerator !== null) {
					$defLocMapGenerator->saveMapping();
					$classDefinitionLocation = ALP_ClassDefLocMap::getClassDefinitionLocation($className, true);
					if (file_exists($classDefinitionLocation) && !is_dir($classDefinitionLocation)) {
						require_once $classDefinitionLocation;
					}
				}
			}
		}
	}
}
?>