<?php

class QuestionnaireAspect extends AOWP_PerSessionAspect {

	/* Show the questionnaire after one minuite. */
	const INTERVAL = 10;
	
	private $_firstAccessTime;
	private $_asked = false;
	
	public function __construct() {
		$this->_firstAccessTime = time();
//		$allReqPC = new AOWP_RequestPointcut('^html/.*');
		$allReqPC = new AOWP_RequestPointcut('.*');
		
		$quesAdv = new AOWP_AroundAdvice();
		$chkTimePC = new AOWP_IfPointcut('$aspect->isQuestionTime()');
		$quesAdv->setPointcut($allReqPC->opAnd($chkTimePC));
		$quesAdv->setAdviceBody('ques');
		$this->addAdvice($quesAdv);
	}
	
	public function ques(AOWP_JoinPoint $jp) {
		$this->asked();
		ob_start();
		$jp->proceed();
		$outputSource = ob_get_clean();
		$outputSource = str_replace('</head>', file_get_contents('/Users/keiji/Sites/eccube/eccube/aowp/aspect/questionnaire/header.txt'), $outputSource);
		$outputSource = str_replace('</body>', file_get_contents('/Users/keiji/Sites/eccube/eccube/aowp/aspect/questionnaire/questionnaire.txt'), $outputSource);
		echo $outputSource;
	}
	
	public function isQuestionTime() {
		return !$this->_asked && (time() - $this->_firstAccessTime > QuestionnaireAspect::INTERVAL);
	}
	public function asked() {
		$this->_asked = true;
	}
	
}
?>
