<?php
require_once dirname(__FILE__) . DIRECTORY_SEPARATOR . 'AccessMonitor.class.php';

class AccessMonitorAspect extends AOWP_PerApplicationAspect {

	const MAX_ACCESS_NUMBER = 2;
	const WARNING_PAGE_URL = 'http://localhost/~keiji/eccube/eccube/aowp/aspect/access_monitor/warning.html';
	const IN_TIMEOUT = 5;
	
	private $_accessMonitor;
	
	public function __construct() {
		$this->_accessMonitor = new AccessMonitor();
		$allReqPC = new AOWP_RequestPointcut('.*');
//		$allReqPC = new AOWP_RequestPointcut('^html/.*');
		
		$inAdvice = new AOWP_BeforeAdvice();
		$inAdvice->setPointcut($allReqPC);
		$inAdvice->setAdviceBody('_in');
		$this->addAdvice($inAdvice);
		
		$outAdvice = new AOWP_AfterAdvice();
		$outAdvice->setPointcut($allReqPC);
		$outAdvice->setAdviceBody('_out');
		$this->addAdvice($outAdvice);
	}
	
	protected function _in(AOWP_JoinPoint $jp) {
//		$this->_accessMonitor = new AccessMonitor();
		AOWP_Logger::logToFile('IN [' . $jp->getSessionID() . ']');
		if (!$this->_accessMonitor->in($jp->getSessionID())) {
			header('Location: ' . AccessMonitorAspect::WARNING_PAGE_URL);
			AOWP_AspectInstanceManager::releaseInstance($this);
			exit();
		}
	}
	protected function _out(AOWP_JoinPoint $jp) {
		AOWP_Logger::logToFile('OUT [' . $jp->getSessionID() . ']');
		$this->_accessMonitor->out($jp->getSessionID());
	}
}