<?php
/**
 * 長い説明文
 * 
 * @package aowp.aspect.pointcut.designators
 */
/**
 * メソッド実行のイベントを選択するポイントカット記述子です。
 * 
 * @package aowp.aspect.pointcut.designators
 */
class AOWP_MethodExecutionPointcut extends AOWP_StaticPointcut {
	private $_modifiers;
	private $_className;
	private $_methodName;
	private $_argumentsCount;

	/**
	 * 
	 * @param string $modifiers メソッドの修飾子を空白区切りで記述。
	 * @param string $className クラス名。
	 * @param string $methodName メソッド名。
	 * @param int $argumentsCount 引き数の数。
	 */
	public function __construct ($modifiers, $className, $methodName, $argumentsCount) {
		$this->_modifiers = explode(' ', $modifiers);
		$this->_className = $className;
		$this->_methodName = $methodName;
		$this->_argumentsCount = $argumentsCount;
	}

	protected function _isJoinPointShadow(AOWP_JoinPoint $joinPoint) {
		if ($joinPoint instanceof AOWP_MethodExecutionJoinPoint) {
			foreach ($this->_modifiers as $modifier) {
				if (!$joinPoint->haveModifier($modifier)) {
					return false;
				}
			}
//			AOWP_Logger::logging('ME match: ' . (AOWP_Pointcut::patternMatch($this->_className, $joinPoint->getClassName()) ? 'true' : 'false'));
//			AOWP_Logger::logging('ME match: ' . (AOWP_Pointcut::patternMatch($this->_methodName, $joinPoint->getMethodName()) ? 'true' : 'false'));
//			AOWP_Logger::logging('ME match: ' . (($this->_argumentsCount === -1) || ($this->_argumentsCount === $joinPoint->getParameterCount()) ? 'true' : 'false'));
//			AOWP_Logger::logging('Method name: ' . $this->_methodName . ', ' . $joinPoint->getMethodName());
//			AOWP_Logger::logging('Argument count: ' . $this->_argumentsCount . ', ' . $joinPoint->getParameterCount());
			return AOWP_Pointcut::patternMatch($this->_className, $joinPoint->getClassName()) &&
				AOWP_Pointcut::patternMatch($this->_methodName, $joinPoint->getMethodName()) &&
				(($this->_argumentsCount === -1) || ($this->_argumentsCount === $joinPoint->getParameterCount()));
		}
		else {
			return false;
		}
	}
	
}
?>
