<?php
/**
 * 
 * @package aowp.aspect.joinpoint
 */
/**
 * 
 * @author keiji
 * @package aowp.aspect.joinpoint
 *
 */
abstract class AOWP_JoinPoint {
	
	private $_line;
	private $_fileName;
	private $_fileFullPath;
	private $_ast;
	protected $_proceedFunctionName;
	private $_returnValue;
	private $_timestamp;
	protected $_executedAdvice;
	
	/**
	 * 
	 * @param $element
	 * @param $fileName
	 * @return void
	 */
	public function __construct(AOWP_PHPElement $element = null, $fileName = null) {
		if ($fileName !== null) {
			$this->_fileFullPath = $fileName;
			$this->_fileName = substr($fileName, strlen(AOWP_ConfigurationManager::getProjectHomePath()) + 1);
		}
		if ($element !== null) {
			$this->_ast = $element;
			$this->_line = $element->line();
		}
		$this->_proceedFunctionName = null;
		$this->_returnValue = null;
		$this->_timestamp = time();
	}
	
	public function setExecutedAdvice(AOWP_Advice $executedAdvice) {
		$this->_executedAdvice = $executedAdvice;
	}
	public function getExecutedAdvice() {
		return $this->_executedAdvice;
	}
	
	public function getTimestamp() {
		return $this->_timestamp;
	}
	
	public function getLineNumber() {
		return $this->_line;
	}
	
	public function &getAST() {
//		return $this->_ast != null ? $this->_ast : null;
		return $this->_ast;
	}
	/**
	 * 引き数は、nullも設定できます。
	 * (その為に、引き数の型ヒントを省略してます。)
	 * 
	 * @param AOWP_PHPElement $ast
	 * @return void
	 */
	public function setAST($ast) {
		$this->_ast = $ast;
	}
	
	/**
	 * このジョインポイントが存在するファイル名を取得します。
	 * 
	 * @return string
	 */
	public function getFileName() {
		return $this->_fileName;
	}
	
	public function getFileFullPath() {
		return $this->_fileFullPath;
	}
	
	public function setProceedFunctionName($proceedFunctionName) {
		$this->_proceedFunctionName = $proceedFunctionName;
	}
	
	/**
	 * aroundアドバイスの時に、ポイントカットで選択した元の処理を呼び出します。
	 * もし、ポイントカットで選択したジョインポイントが、引き数を持つ場合、引き数は、配列にして渡して下さい。
	 * aroundアドバイス以外の時に呼び出した場合、何も処理をせず、返り値も返しません。
	 * 返り値は、元の処理に返り値が有る場合、その値が返ります。
	 * 
	 * @param $argumentArray
	 * @return mixed
	 */
	abstract public function proceed(array $argumentArray = array());
	
	public function setReturnValue($returnValue) {
		$this->_returnValue = $returnValue;
	}
	public function getReturnValue() {
		return $this->_returnValue;
	}
	
	public function getSessionID() {
		return AOWP_AspectInstanceManager::getSessionID();
	}
	
	public function getFormData($parameterName) {
		return isset($_POST[$parameterName]) ? $_POST[$parameterName] : (isset($_GET[$parameterName]) ? $_GET[$parameterName] : null);
	}
}
?>