<?php
/**
 * 
 * @package aowp.aspect.joinpoint
 */
/**
 * 
 * @author keiji
 * @package aowp.aspect.joinpoint
 *
 */
class AOWP_FunctionExecutionJoinPoint extends AOWP_JoinPointWithArguments {

	/**
	 * 
	 * @var string
	 */
	private $_functionName;
	/**
	 * 
	 * @var int
	 */
	private $_parameterCount;
	
	public function __construct(AOWP_PHPFunctionElement $element = null, $fileName = null) {
		parent::__construct($element, $fileName);
		$this->setFunctionName($element->getFunctionName());
		$this->setParameterCount($element->getParameterCount());
	}
	
	/**
	 * 
	 * @param int $parameterCount
	 * @return void
	 */
	public function setParameterCount($parameterCount) {
		$this->_parameterCount = $parameterCount;
	}
	/**
	 * 
	 * @return int
	 */
	public function getParameterCount() {
		return $this->_parameterCount;
	}
	
	public function setFunctionName($functionName) {
		$this->_functionName = $functionName;
	}
	/**
	 * 関数名を取得します。
	 * 
	 * @return string
	 */
	public function getFunctionName() {
		return $this->_functionName;
	}
	
	public function proceed(array $argumentArray = array()) {
		if ($this->_proceedFunctionName !== null) {
			return call_user_func_array($this->_proceedFunctionName, $argumentArray);
		}
	}
}
?>