/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util.resource;

import com.jme.util.resource.ResourceLocator;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;

public class SimpleResourceLocator
implements ResourceLocator {
    protected URI baseDir;

    public SimpleResourceLocator(URI uRI) {
        if (uRI == null) {
            throw new NullPointerException("baseDir can not be null.");
        }
        this.baseDir = uRI;
    }

    public SimpleResourceLocator(URL uRL) throws URISyntaxException {
        if (uRL == null) {
            throw new NullPointerException("baseDir can not be null.");
        }
        this.baseDir = uRL.toURI();
    }

    public URL locateResource(String string) {
        try {
            String string2 = URLEncoder.encode(string, "UTF-8");
            string2 = string2.replaceAll("\\+", "%20");
            URL uRL = new URL(this.baseDir.toURL(), string2);
            uRL.openStream().close();
            return uRL;
        }
        catch (IOException iOException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        string = this.trimResourceName(string);
        if (string == null) {
            return null;
        }
        return this.locateResource(string);
    }

    protected String trimResourceName(String string) {
        int n = string.indexOf(47);
        if (n >= 0 && n < string.length() - 1) {
            return string.substring(n + 1);
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object instanceof SimpleResourceLocator) {
            return this.baseDir.equals(((SimpleResourceLocator)object).baseDir);
        }
        return false;
    }
}

